/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.metadata;

import com.liferay.document.library.kernel.util.AudioProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.metadata.BaseRawMetadataProcessor;
import com.xuggle.xuggler.IContainer;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;

public class XugglerRawMetadataProcessor
extends BaseRawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(XugglerRawMetadataProcessor.class);
    private static final DecimalFormat _decimalFormatter = new DecimalFormat("00");

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) {
    }

    protected String convertTime(long microseconds) {
        long milliseconds = microseconds / 1000L;
        return StringBundler.concat((String[])new String[]{_decimalFormatter.format(milliseconds / 3600000L), ":", _decimalFormatter.format(milliseconds % 3600000L / 60000L), ":", _decimalFormatter.format(milliseconds % 60000L / 1000L), ".", _decimalFormatter.format(milliseconds % 1000L / 10L)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata extractMetadata(File file) throws Exception {
        IContainer container = IContainer.make();
        try {
            int result = container.open(file.getCanonicalPath(), IContainer.Type.READ, null);
            if (result < 0) {
                throw new IllegalArgumentException("Could not open stream");
            }
            if (container.queryStreamMetaData() < 0) {
                throw new IllegalStateException("Could not query stream metadata");
            }
            Metadata metadata = new Metadata();
            long microseconds = container.getDuration();
            metadata.set(XMPDM.DURATION, this.convertTime(microseconds));
            Metadata metadata2 = metadata;
            return metadata2;
        }
        finally {
            if (container.isOpened()) {
                container.close();
            }
        }
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, File file) {
        if (!this.isSupported(mimeType)) {
            return null;
        }
        try {
            return this.extractMetadata(file);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Metadata extractMetadata(String extension, String mimeType, InputStream inputStream) {
        if (!this.isSupported(mimeType)) {
            return null;
        }
        File file = null;
        try {
            file = FileUtil.createTempFile((String)extension);
            FileUtil.write((File)file, (InputStream)inputStream);
            Metadata metadata = this.extractMetadata(file);
            return metadata;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        finally {
            FileUtil.delete((File)file);
        }
        return null;
    }

    protected boolean isSupported(String mimeType) {
        return XugglerUtil.isEnabled() && (AudioProcessorUtil.isAudioSupported((String)mimeType) || VideoProcessorUtil.isVideoSupported((String)mimeType));
    }
}

