/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import org.osgi.framework.BundleContext;

public class PermissionCheckerUtil {
    private static final Log _log = LogFactoryUtil.getLog(PermissionCheckerUtil.class);
    private static final ServiceTrackerList<RoleContributor> _roleContributors = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), RoleContributor.class);

    public static void setThreadValues(User user) {
        if (user == null) {
            PrincipalThreadLocal.setName(null);
            PermissionThreadLocal.setPermissionChecker(null);
            return;
        }
        PrincipalThreadLocal.setName((String)String.valueOf(user.getUserId()));
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker == null) {
                Class<?> clazz = Class.forName(PropsValues.PERMISSIONS_CHECKER);
                permissionChecker = (PermissionChecker)clazz.newInstance();
            }
            ArrayList roleContributors = new ArrayList();
            _roleContributors.forEach(roleContributors::add);
            permissionChecker.init(user, roleContributors.toArray(new RoleContributor[0]));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }
}

