/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.service.base.WorkflowDefinitionLinkLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

public class WorkflowDefinitionLinkLocalServiceImpl
extends WorkflowDefinitionLinkLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public WorkflowDefinitionLink addWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        long workflowDefinitionLinkId = this.counterLocalService.increment();
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.create(workflowDefinitionLinkId);
        workflowDefinitionLink.setGroupId(StagingUtil.getLiveGroupId((long)groupId));
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setClassNameId(this._classNameLocalService.getClassNameId(className));
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        return (WorkflowDefinitionLink)this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink);
    }

    public void deleteWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, true);
        if (workflowDefinitionLink != null) {
            this.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
    }

    public WorkflowDefinitionLink fetchDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        return this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
    }

    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        return this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(StagingUtil.getLiveGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
        if (!strict && workflowDefinitionLink == null && (workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(PortalUtil.getSiteGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK)) == null) {
            workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
        }
        return workflowDefinitionLink;
    }

    public List<WorkflowDefinitionLink> fetchWorkflowDefinitionLinks(long companyId, long groupId, String className, long classPK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return Collections.emptyList();
        }
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C(StagingUtil.getLiveGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public WorkflowDefinitionLink getDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C_T(0L, companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) throws PortalException {
        return this.getWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, strict);
        if (workflowDefinitionLink == null) {
            throw new NoSuchWorkflowDefinitionLinkException(StringBundler.concat((Object[])new Object[]{"No workflow exists with the key {groupId=", StagingUtil.getLiveGroupId((long)groupId), ", companyId=", companyId, ", and className=", className, "}"}));
        }
        return workflowDefinitionLink;
    }

    public List<WorkflowDefinitionLink> getWorkflowDefinitionLinks(long companyId, long groupId, long classPK) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByG_C_CPK(groupId, companyId, classPK);
    }

    public List<WorkflowDefinitionLink> getWorkflowDefinitionLinks(long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C(companyId, StagingUtil.getLiveGroupId((long)groupId), this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<WorkflowDefinitionLink> getWorkflowDefinitionLinks(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    public int getWorkflowDefinitionLinksCount(long companyId, long groupId, String className) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return 0;
        }
        return this.workflowDefinitionLinkPersistence.countByG_C_C(StagingUtil.getLiveGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className));
    }

    public int getWorkflowDefinitionLinksCount(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return 0;
        }
        return this.workflowDefinitionLinkPersistence.countByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    @Transactional(enabled=false)
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        int count = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLinksCount(companyId, StagingUtil.getLiveGroupId((long)groupId), className);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLinksCount(companyId, PortalUtil.getSiteGroupId((long)groupId), className);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLinksCount(companyId, 0L, className);
        return count > 0;
    }

    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        int count = this.workflowDefinitionLinkPersistence.countByG_C_C_C(StagingUtil.getLiveGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkPersistence.countByG_C_C_C(PortalUtil.getSiteGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkPersistence.countByG_C_C_C(0L, companyId, this._classNameLocalService.getClassNameId(className), classPK);
        return count > 0;
    }

    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        int count = this.workflowDefinitionLinkPersistence.countByG_C_C_C_T(StagingUtil.getLiveGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkPersistence.countByG_C_C_C_T(PortalUtil.getSiteGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkPersistence.countByG_C_C_C_T(0L, companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
        return count > 0;
    }

    public void updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinition) throws PortalException {
        if (Validator.isNull((String)workflowDefinition)) {
            this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
        } else {
            String[] workflowDefinitionParts = StringUtil.split((String)workflowDefinition, (char)'@');
            String workflowDefinitionName = workflowDefinitionParts[0];
            int workflowDefinitionVersion = GetterUtil.getInteger((String)workflowDefinitionParts[1]);
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
    }

    public WorkflowDefinitionLink updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(StagingUtil.getLiveGroupId((long)groupId), companyId, this._classNameLocalService.getClassNameId(className), classPK, typePK);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this.addWorkflowDefinitionLink(userId, companyId, StagingUtil.getLiveGroupId((long)groupId), className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
        workflowDefinitionLink.setGroupId(StagingUtil.getLiveGroupId((long)groupId));
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setClassNameId(this._classNameLocalService.getClassNameId(className));
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        return (WorkflowDefinitionLink)this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink);
    }

    public void updateWorkflowDefinitionLinks(long userId, long companyId, long groupId, String className, long classPK, List<ObjectValuePair<Long, String>> workflowDefinitionOVPs) throws PortalException {
        for (ObjectValuePair<Long, String> workflowDefinitionOVP : workflowDefinitionOVPs) {
            long typePK = (Long)workflowDefinitionOVP.getKey();
            String workflowDefinitionName = (String)workflowDefinitionOVP.getValue();
            if (Validator.isNull((String)workflowDefinitionName)) {
                this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
                continue;
            }
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName);
        }
    }
}

