/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.asm.ASMWrapperUtil;
import com.liferay.portal.change.tracking.registry.CTModelRegistration;
import com.liferay.portal.change.tracking.registry.CTModelRegistry;
import com.liferay.portal.dao.orm.hibernate.event.MVCCSynchronizerPostUpdateEventListener;
import com.liferay.portal.dao.orm.hibernate.event.ResetOriginalValuesLoadEventListener;
import com.liferay.portal.dao.orm.hibernate.event.ResetOriginalValuesPostLoadEventListener;
import com.liferay.portal.internal.change.tracking.hibernate.CTSQLInterceptor;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PreloadClassLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.QueryPlanCache;
import org.hibernate.event.EventListeners;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class PortalHibernateConfiguration
extends LocalSessionFactoryBean {
    private static final String[] _PRELOAD_CLASS_NAMES = PropsValues.SPRING_HIBERNATE_CONFIGURATION_PROXY_FACTORY_PRELOAD_CLASSLOADER_CLASSES;
    private static final Log _log = LogFactoryUtil.getLog(PortalHibernateConfiguration.class);
    private static final Map<ProxyFactory, ClassLoader> _proxyFactoryClassLoaders = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private boolean _mvccEnabled = true;

    public PortalHibernateConfiguration() {
        Properties properties = new Properties();
        properties.put("javax.persistence.validation.mode", "none");
        this.setHibernateProperties(properties);
    }

    public SessionFactory buildSessionFactory() throws Exception {
        this.setBeanClassLoader(this.getConfigurationClassLoader());
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)super.buildSessionFactory();
        if (!this._mvccEnabled) {
            return sessionFactoryImplementor;
        }
        boolean containCTModel = false;
        Map classMetadatas = sessionFactoryImplementor.getAllClassMetadata();
        for (ClassMetadata classMetadata : classMetadatas.values()) {
            Class mappedClass = classMetadata.getMappedClass(EntityMode.POJO);
            if (!CTModel.class.isAssignableFrom(mappedClass)) continue;
            Class<?> modelClass = this._findCTModelClass(classMetadata, mappedClass.getSuperclass());
            if (modelClass == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find CT model class for " + mappedClass));
                continue;
            }
            containCTModel = true;
        }
        CTSQLInterceptor ctSQLInterceptor = (CTSQLInterceptor)sessionFactoryImplementor.getInterceptor();
        ctSQLInterceptor.setEnabled(containCTModel);
        return sessionFactoryImplementor;
    }

    public void destroy() throws HibernateException {
        SessionFactory sessionFactory = this.getSessionFactory();
        Map classMetadatas = sessionFactory.getAllClassMetadata();
        for (ClassMetadata classMetadata : classMetadatas.values()) {
            Class mappedClass = classMetadata.getMappedClass(EntityMode.POJO);
            if (!CTModel.class.isAssignableFrom(mappedClass)) continue;
            OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)classMetadata;
            CTModelRegistry.unregisterCTModel(outerJoinLoadable.getTableName());
        }
        this.setBeanClassLoader(null);
        super.destroy();
    }

    public void setMvccEnabled(boolean mvccEnabled) {
        this._mvccEnabled = mvccEnabled;
    }

    protected static Map<String, Class<?>> getPreloadClassLoaderClasses() {
        try {
            HashMap classes = new HashMap();
            for (String className : _PRELOAD_CLASS_NAMES) {
                ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
                Class<?> clazz = portalClassLoader.loadClass(className);
                classes.put(className, clazz);
            }
            return classes;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    protected ClassLoader getConfigurationClassLoader() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getClassLoader();
    }

    protected String[] getConfigurationResources() {
        return PropsUtil.getArray("hibernate.configs");
    }

    protected Configuration newConfiguration() {
        Dialect dialect = DialectDetector.getDialect(this.getDataSource());
        if (DBManagerUtil.getDBType((Object)dialect) == DBType.ORACLE) {
            System.setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        }
        Configuration configuration = new Configuration();
        Properties properties = PropsUtil.getProperties();
        Properties hibernateProperties = this.getHibernateProperties();
        for (Map.Entry<Object, Object> entry : hibernateProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            properties.setProperty(key, value);
        }
        if (DBManagerUtil.getDBType((Object)dialect) == DBType.SYBASE) {
            properties.setProperty("hibernate.jdbc.batch_size", "0");
        }
        if (Validator.isNull((String)PropsValues.HIBERNATE_DIALECT)) {
            Class<?> clazz = dialect.getClass();
            properties.setProperty("hibernate.dialect", clazz.getName());
        }
        properties.setProperty("hibernate.cache.use_query_cache", "false");
        properties.setProperty("hibernate.cache.use_second_level_cache", "false");
        properties.remove("hibernate.cache.region.factory_class");
        configuration.setProperties(properties);
        try {
            String[] resources;
            for (String resource : resources = this.getConfigurationResources()) {
                try {
                    this.readResource(configuration, resource);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)exception, (Throwable)exception);
                }
            }
            EventListeners eventListeners = configuration.getEventListeners();
            eventListeners.setLoadEventListeners(new LoadEventListener[]{ResetOriginalValuesLoadEventListener.INSTANCE});
            eventListeners.setPostLoadEventListeners(new PostLoadEventListener[]{ResetOriginalValuesPostLoadEventListener.INSTANCE});
            if (this._mvccEnabled) {
                eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[]{MVCCSynchronizerPostUpdateEventListener.INSTANCE});
                configuration.setInterceptor((Interceptor)new CTSQLInterceptor());
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return configuration;
    }

    protected SessionFactory newSessionFactory(Configuration configuration) throws HibernateException {
        SessionFactory sessionFactory;
        block3: {
            sessionFactory = super.newSessionFactory(configuration);
            if (Objects.equals(PropsValues.HIBERNATE_SESSION_FACTORY_IMPORTED_CLASS_NAME_REGEXP, ".*")) {
                return sessionFactory;
            }
            try {
                Field queryPlanCacheField = ReflectionUtil.getDeclaredField(sessionFactory.getClass(), (String)"queryPlanCache");
                QueryPlanCache queryPlanCache = (QueryPlanCache)queryPlanCacheField.get(sessionFactory);
                Field sessionFactoryField = ReflectionUtil.getDeclaredField(QueryPlanCache.class, (String)"factory");
                sessionFactoryField.set(queryPlanCache, this._wrapSessionFactoryImplementor((SessionFactoryImplementor)sessionFactory, configuration.getImports()));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to inject optimized query plan cache", (Throwable)exception);
            }
        }
        return sessionFactory;
    }

    protected void postProcessConfiguration(Configuration configuration) {
        String connectionReleaseMode = PropsUtil.get("hibernate.connection.release_mode");
        if (Validator.isNotNull((String)connectionReleaseMode)) {
            configuration.setProperty("hibernate.connection.release_mode", connectionReleaseMode);
        }
    }

    protected void readResource(Configuration configuration, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return;
        }
        configuration.addInputStream(inputStream);
        inputStream.close();
    }

    protected void readResource(Configuration configuration, String resource) throws Exception {
        ClassLoader classLoader = this.getConfigurationClassLoader();
        if (resource.startsWith("classpath*:")) {
            String name = resource.substring("classpath*:".length());
            Enumeration<URL> enumeration = classLoader.getResources(name);
            if (_log.isDebugEnabled() && !enumeration.hasMoreElements()) {
                _log.debug((Object)("No resources found for " + name));
            }
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream inputStream = url.openStream();
                this.readResource(configuration, inputStream);
            }
        } else {
            InputStream inputStream = classLoader.getResourceAsStream(resource);
            this.readResource(configuration, inputStream);
        }
    }

    private Class<?> _findCTModelClass(ClassMetadata classMetadata, Class<?> modelClass) {
        while (BaseModelImpl.class != modelClass) {
            for (Class<?> interfaceClazz : modelClass.getInterfaces()) {
                if (!BaseModel.class.isAssignableFrom(interfaceClazz)) continue;
                OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)classMetadata;
                String[] identifierColumnNames = outerJoinLoadable.getPropertyColumnNames(outerJoinLoadable.getIdentifierPropertyName());
                CTModelRegistry.registerCTModel(new CTModelRegistration(interfaceClazz, outerJoinLoadable.getTableName(), identifierColumnNames[0]));
                return interfaceClazz;
            }
            modelClass = modelClass.getSuperclass();
        }
        return null;
    }

    private SessionFactoryImplementor _wrapSessionFactoryImplementor(SessionFactoryImplementor sessionFactoryImplementor, Map<String, String> imports) {
        NoPatternSessionFactoryDelegate sessionFactoryDelegate = null;
        sessionFactoryDelegate = Validator.isBlank((String)PropsValues.HIBERNATE_SESSION_FACTORY_IMPORTED_CLASS_NAME_REGEXP) ? new NoPatternSessionFactoryDelegate(imports) : new PatternedSessionFactoryDelegate(imports, PropsValues.HIBERNATE_SESSION_FACTORY_IMPORTED_CLASS_NAME_REGEXP, sessionFactoryImplementor);
        return ASMWrapperUtil.createASMWrapper(SessionFactoryImplementor.class.getClassLoader(), SessionFactoryImplementor.class, sessionFactoryDelegate, sessionFactoryImplementor);
    }

    static {
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            public ClassLoader get(ProxyFactory proxyFactory) {
                return _proxyFactoryClassLoaders.computeIfAbsent(proxyFactory, pf -> {
                    Thread currentThread;
                    ClassLoader contextClassLoader;
                    ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
                    if (classLoader != (contextClassLoader = (currentThread = Thread.currentThread()).getContextClassLoader())) {
                        classLoader = new PreloadClassLoader(contextClassLoader, PortalHibernateConfiguration.getPreloadClassLoaderClasses());
                    }
                    return classLoader;
                });
            }
        };
    }

    private static class PatternedSessionFactoryDelegate
    extends NoPatternSessionFactoryDelegate {
        private final Pattern _importedClassNamePattern;
        private final SessionFactoryImplementor _sessionFactoryImplementor;

        @Override
        public String getImportedClassName(String className) {
            String importedClassName = super.getImportedClassName(className);
            if (importedClassName != null) {
                return importedClassName;
            }
            Matcher matcher = this._importedClassNamePattern.matcher(className);
            if (!matcher.matches()) {
                return null;
            }
            return this._sessionFactoryImplementor.getImportedClassName(className);
        }

        private PatternedSessionFactoryDelegate(Map<String, String> imports, String importedClassNameRegexp, SessionFactoryImplementor sessionFactoryImplementor) {
            super(imports);
            this._importedClassNamePattern = Pattern.compile(importedClassNameRegexp);
            this._sessionFactoryImplementor = sessionFactoryImplementor;
        }
    }

    private static class NoPatternSessionFactoryDelegate {
        private final Map<String, String> _imports;

        public String getImportedClassName(String className) {
            return this._imports.get(className);
        }

        protected NoPatternSessionFactoryDelegate(Map<String, String> imports) {
            this._imports = new HashMap<String, String>(imports);
        }
    }
}

