/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.DocUtil;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.PluginContextListener;
import com.liferay.portal.kernel.servlet.PortalClassLoaderServlet;
import com.liferay.portal.kernel.servlet.PortalDelegateServlet;
import com.liferay.portal.kernel.servlet.PortletServlet;
import com.liferay.portal.kernel.servlet.SecurePluginContextListener;
import com.liferay.portal.kernel.servlet.SecureServlet;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.tools.WebXMLBuilder;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.DynamicResourceServlet;
import com.liferay.util.ant.CopyTask;
import com.liferay.util.ant.DeleteTask;
import com.liferay.util.ant.ExpandTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.oro.io.GlobFilenameFilter;

public class BaseAutoDeployer
implements AutoDeployer {
    public static final String DEPLOY_TO_PREFIX = "DEPLOY_TO__";
    protected String auiTaglibDTD;
    protected String portletExtTaglibDTD;
    protected String portletTaglibDTD;
    protected String securityTaglibDTD;
    protected final Set<Path> tempDirPaths = new HashSet<Path>();
    protected String themeTaglibDTD;
    protected String uiTaglibDTD;
    protected String utilTaglibDTD;
    private static final Log _log = LogFactoryUtil.getLog(BaseAutoDeployer.class);
    private static final List<String> _jars = Arrays.asList("util-bridges.jar", "util-java.jar", "util-taglib.jar");
    private final String _pluginType;

    public BaseAutoDeployer(String pluginType) {
        this._pluginType = pluginType;
    }

    public int autoDeploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        String specifiedContext;
        File srcFile = autoDeploymentContext.getFile();
        PluginPackage pluginPackage = autoDeploymentContext.getPluginPackage();
        if (pluginPackage == null) {
            pluginPackage = this._readPluginPackage(srcFile);
            autoDeploymentContext.setPluginPackage(pluginPackage);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying " + srcFile.getName()));
        }
        String displayName = specifiedContext = autoDeploymentContext.getContext();
        boolean overwrite = false;
        String preliminaryContext = specifiedContext;
        String srcFileName = srcFile.getName();
        if (Validator.isNull((String)specifiedContext) && srcFileName.startsWith(DEPLOY_TO_PREFIX)) {
            displayName = srcFileName.substring(DEPLOY_TO_PREFIX.length(), srcFileName.length() - 4);
            overwrite = true;
            preliminaryContext = displayName;
        }
        if (preliminaryContext == null) {
            preliminaryContext = this._getDisplayName(srcFile);
        }
        if (pluginPackage != null) {
            if (!PluginPackageUtil.isCurrentVersionSupported(pluginPackage.getLiferayVersions())) {
                throw new AutoDeployException(srcFile.getName() + " does not support this version of Liferay");
            }
            if (displayName == null) {
                displayName = pluginPackage.getRecommendedDeploymentContext();
            }
            if (Validator.isNull((String)displayName)) {
                displayName = this._getDisplayName(srcFile);
            }
            pluginPackage.setContext(displayName);
            PluginPackageUtil.updateInstallingPluginPackage(preliminaryContext, pluginPackage);
        }
        String deployDir = null;
        if (Validator.isNotNull((String)displayName)) {
            deployDir = displayName + ".war";
        } else {
            deployDir = srcFile.getName();
            displayName = this._getDisplayName(srcFile);
        }
        String destDir = autoDeploymentContext.getDestDir();
        File deployDirFile = new File(destDir + "/" + deployDir);
        try {
            PluginPackage previousPluginPackage = this._readPluginPackage(deployDirFile);
            if (pluginPackage != null && previousPluginPackage != null) {
                String name = pluginPackage.getName();
                String previousVersion = previousPluginPackage.getVersion();
                String version = pluginPackage.getVersion();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Updating ", name, " from version ", previousVersion, " to version ", version}));
                }
                if (pluginPackage.isPreviousVersionThan(previousPluginPackage)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((String[])new String[]{"Not updating ", name, " because version ", previousVersion, " is newer than version ", version}));
                    }
                    return 2;
                }
                overwrite = true;
            }
            File mergeDirFile = new File(srcFile.getParent() + "/merge/" + srcFile.getName());
            if (srcFile.isDirectory()) {
                this._deployDirectory(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
            } else {
                boolean deployed = this._deployFile(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
                if (!deployed) {
                    String context = preliminaryContext;
                    if (pluginPackage != null) {
                        context = pluginPackage.getContext();
                    }
                    PluginPackageUtil.endPluginPackageInstallation(context);
                }
            }
            return 1;
        }
        catch (Exception exception) {
            try {
                if (pluginPackage != null) {
                    PluginPackageUtil.endPluginPackageInstallation(pluginPackage.getContext());
                }
                throw exception;
            }
            catch (Exception exception2) {
                throw new AutoDeployException((Throwable)exception2);
            }
        }
    }

    public void close() throws IOException {
        UnsafeConsumer.accept(this.tempDirPaths, DeployUtil::deletePath, IOException.class);
    }

    public void copyDependencyXml(String fileName, String targetDir) throws Exception {
        this.copyDependencyXml(fileName, targetDir, null);
    }

    public void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap) throws Exception {
        this.copyDependencyXml(fileName, targetDir, filterMap, false);
    }

    public void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap, boolean overwrite) throws Exception {
        DeployUtil.copyDependencyXml(fileName, targetDir, fileName, filterMap, overwrite);
    }

    public void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        this.copyDependencyXml("web.xml", srcFile + "/WEB-INF");
    }

    public void deployDirectory(File srcFile, String displayName, boolean override, PluginPackage pluginPackage) throws Exception {
        this._deployDirectory(srcFile, null, null, displayName, override, pluginPackage);
    }

    public String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        if (displayName.startsWith("/")) {
            displayName = displayName.substring(1);
        }
        StringBundler sb = new StringBundler(70);
        sb.append("<display-name>");
        sb.append(displayName);
        sb.append("</display-name>");
        if (webXmlVersion < 2.4) {
            sb.append("<context-param>");
            sb.append("<param-name>liferay-invoker-enabled</param-name>");
            sb.append("<param-value>false</param-value>");
            sb.append("</context-param>");
        }
        if (PropsValues.SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
            sb.append("<listener>");
            sb.append("<listener-class>");
            sb.append(SerializableSessionAttributeListener.class.getName());
            sb.append("</listener-class>");
            sb.append("</listener>");
        }
        sb.append(this._getDynamicResourceServletContent());
        boolean hasTaglib = false;
        if (Validator.isNotNull((String)this.auiTaglibDTD) || Validator.isNotNull((String)this.portletTaglibDTD) || Validator.isNotNull((String)this.portletExtTaglibDTD) || Validator.isNotNull((String)this.securityTaglibDTD) || Validator.isNotNull((String)this.themeTaglibDTD) || Validator.isNotNull((String)this.uiTaglibDTD) || Validator.isNotNull((String)this.utilTaglibDTD)) {
            hasTaglib = true;
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("<jsp-config>");
        }
        if (Validator.isNotNull((String)this.auiTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/aui</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-aui.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.portletTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://java.sun.com/portlet_2_0");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet_2_0.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://xmlns.jcp.org/portlet_3_0");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.portletExtTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/portlet");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet-ext.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.securityTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/security");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-security.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.themeTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/theme</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-theme.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.uiTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/ui</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-ui.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.utilTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/util</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-util.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("</jsp-config>");
        }
        return sb.toString();
    }

    public String getExtraFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        return FileUtil.read((String)DeployUtil.getResourcePath(this.tempDirPaths, "session-filters-web.xml"));
    }

    public String getIgnoreFiltersContent(File srcFile) throws Exception {
        boolean ignoreFiltersEnabled = true;
        Properties properties = this._getPluginPackageProperties(srcFile);
        if (properties != null) {
            ignoreFiltersEnabled = GetterUtil.getBoolean((String)properties.getProperty("ignore-filters-enabled"), (boolean)true);
        }
        if (ignoreFiltersEnabled) {
            return FileUtil.read((String)DeployUtil.getResourcePath(this.tempDirPaths, "ignore-filters-web.xml"));
        }
        return "";
    }

    public String getPluginType() {
        return this._pluginType;
    }

    public String getServletContextIncludeFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        if (webXmlVersion < 2.4) {
            return "";
        }
        Properties properties = this._getPluginPackageProperties(srcFile);
        if (properties == null || !GetterUtil.getBoolean((String)properties.getProperty("servlet-context-include-filters-enabled"), (boolean)true)) {
            return "";
        }
        return FileUtil.read((String)DeployUtil.getResourcePath(this.tempDirPaths, "servlet-context-include-filters-web.xml"));
    }

    public String getSpeedFiltersContent(File srcFile) throws Exception {
        boolean speedFiltersEnabled = true;
        Properties properties = this._getPluginPackageProperties(srcFile);
        if (properties != null) {
            speedFiltersEnabled = GetterUtil.getBoolean((String)properties.getProperty("speed-filters-enabled"), (boolean)true);
        }
        if (speedFiltersEnabled) {
            return FileUtil.read((String)DeployUtil.getResourcePath(this.tempDirPaths, "speed-filters-web.xml"));
        }
        return "";
    }

    public Map<String, String> processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (pluginPackage == null) {
            return null;
        }
        Properties properties = this._getPluginPackageProperties(srcFile);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        Map<String, String> filterMap = this._getPluginPackageXmlFilterMap(pluginPackage);
        if (filterMap == null) {
            return null;
        }
        this.copyDependencyXml("liferay-plugin-package.xml", srcFile + "/WEB-INF", filterMap, true);
        return filterMap;
    }

    public void updateDeployDirectory(File srcFile) throws Exception {
    }

    private void _copyJars(File srcFile) throws Exception {
        for (String jar : _jars) {
            String jarFullName = DeployUtil.getResourcePath(this.tempDirPaths, jar);
            String jarName = jarFullName.substring(jarFullName.lastIndexOf("/") + 1);
            if (!FileUtil.exists((String)jarFullName)) {
                DeployUtil.getResourcePath(this.tempDirPaths, jarName);
            }
            FileUtil.copyFile((String)jarFullName, (String)(srcFile + "/WEB-INF/lib/" + jarName), (boolean)false);
        }
    }

    private void _copyPortalDependencies(File srcFile) throws Exception {
        Object[] log4jJars;
        Object[] commonsLoggingJars;
        String[] portalTlds;
        String[] portalJars;
        Properties properties = this._getPluginPackageProperties(srcFile);
        if (properties == null) {
            return;
        }
        for (String portalJar : portalJars = StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")))) {
            portalJar = portalJar.trim();
            portalJar = this._fixPortalDependencyJar(portalJar);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Copy portal JAR " + portalJar));
            }
            try {
                String portalJarPath = PortalUtil.getPortalLibDir() + portalJar;
                FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/" + portalJar), (boolean)true);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to copy portal JAR " + portalJar), (Throwable)exception);
            }
        }
        for (String portalTld : portalTlds = StringUtil.split((String)properties.getProperty("portal-dependency-tlds", properties.getProperty("portal.dependency.tlds")))) {
            portalTld = portalTld.trim();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Copy portal TLD " + portalTld));
            }
            try {
                String portalTldPath = DeployUtil.getResourcePath(this.tempDirPaths, portalTld);
                FileUtil.copyFile((String)portalTldPath, (String)(srcFile + "/WEB-INF/tld/" + portalTld), (boolean)true);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to copy portal TLD " + portalTld), (Throwable)exception);
            }
        }
        File pluginLibDir = new File(srcFile + "/WEB-INF/lib/");
        if (PropsValues.AUTO_DEPLOY_COPY_COMMONS_LOGGING && ArrayUtil.isEmpty((Object[])(commonsLoggingJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("commons-logging*.jar"))))) {
            String portalJarPath = PortalUtil.getPortalLibDir() + "commons-logging.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/commons-logging.jar"), (boolean)true);
        }
        if (PropsValues.AUTO_DEPLOY_COPY_LOG4J && ArrayUtil.isEmpty((Object[])(log4jJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("log4j*.jar"))))) {
            String portalJarPath = PortalUtil.getPortalLibDir() + "log4j-api.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/log4j-api.jar"), (boolean)true);
            portalJarPath = PortalUtil.getPortalLibDir() + "log4j-1.2-api.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/log4j-1.2-api.jar"), (boolean)true);
            portalJarPath = PortalUtil.getPortalLibDir() + "log4j-core.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/log4j-core.jar"), (boolean)true);
        }
    }

    private void _copyProperties(File srcFile, PluginPackage pluginPackage) throws Exception {
        File servicePropertiesFile;
        if (PropsValues.AUTO_DEPLOY_COPY_COMMONS_LOGGING) {
            this.copyDependencyXml("logging.properties", srcFile + "/WEB-INF/classes");
        }
        if (PropsValues.AUTO_DEPLOY_COPY_LOG4J) {
            this.copyDependencyXml("log4j2.properties", srcFile + "/WEB-INF/classes");
        }
        if (!(servicePropertiesFile = new File(srcFile.getAbsolutePath() + "/WEB-INF/classes/service.properties")).exists()) {
            return;
        }
        File portletPropertiesFile = new File(srcFile.getAbsolutePath() + "/WEB-INF/classes/portlet.properties");
        if (portletPropertiesFile.exists()) {
            return;
        }
        String pluginPackageName = null;
        pluginPackageName = pluginPackage != null ? pluginPackage.getName() : srcFile.getName();
        FileUtil.write((File)portletPropertiesFile, (String)("plugin.package.name=" + pluginPackageName));
    }

    private void _copyTlds(File srcFile) throws Exception {
        if (Validator.isNotNull((String)this.auiTaglibDTD)) {
            FileUtil.copyFile((String)this.auiTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-aui.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.portletTaglibDTD)) {
            FileUtil.copyFile((String)this.portletTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-portlet.tld"), (boolean)true);
            FileUtil.copyFile((String)DeployUtil.getResourcePath(this.tempDirPaths, "liferay-portlet_2_0.tld"), (String)(srcFile + "/WEB-INF/tld/liferay-portlet_2_0.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.portletExtTaglibDTD)) {
            FileUtil.copyFile((String)this.portletExtTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-portlet-ext.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.securityTaglibDTD)) {
            FileUtil.copyFile((String)this.securityTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-security.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.themeTaglibDTD)) {
            FileUtil.copyFile((String)this.themeTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-theme.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.uiTaglibDTD)) {
            FileUtil.copyFile((String)this.uiTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-ui.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.utilTaglibDTD)) {
            FileUtil.copyFile((String)this.utilTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-util.tld"), (boolean)true);
        }
    }

    private void _deployDirectory(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        this._rewriteFiles(srcFile);
        this._mergeDirectory(mergeDir, srcFile);
        this.processPluginPackageProperties(srcFile, displayName, pluginPackage);
        this._copyJars(srcFile);
        this._copyProperties(srcFile, pluginPackage);
        this._copyTlds(srcFile);
        this.copyXmls(srcFile, displayName, pluginPackage);
        this._copyPortalDependencies(srcFile);
        File webXml = new File(srcFile + "/WEB-INF/web.xml");
        this._updateWebXml(webXml, srcFile, displayName);
        if (deployDir == null) {
            return;
        }
        this.updateDeployDirectory(srcFile);
        CopyTask.copyDirectory((File)srcFile, (File)deployDir, null, null, (boolean)overwrite, (boolean)true);
    }

    private boolean _deployFile(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        Path tempDirPath = Files.createTempDirectory(Paths.get(SystemProperties.get((String)"java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
        File tempDir = tempDirPath.toFile();
        ExpandTask.expand((File)srcFile, (File)tempDir);
        this._deployDirectory(tempDir, mergeDir, deployDir, displayName, overwrite, pluginPackage);
        DeleteTask.deleteDirectory((File)tempDir);
        return true;
    }

    private String _fixPortalDependencyJar(String portalJar) {
        if (portalJar.equals("antlr.jar")) {
            portalJar = "antlr2.jar";
        }
        return portalJar;
    }

    private String _getDisplayName(File srcFile) {
        String displayName = srcFile.getName();
        if (StringUtil.endsWith((String)displayName, (String)".war") || StringUtil.endsWith((String)displayName, (String)".xml")) {
            displayName = displayName.substring(0, displayName.length() - 4);
        }
        return displayName;
    }

    private String _getDynamicResourceServletContent() {
        StringBundler sb = new StringBundler();
        sb.append("<servlet>");
        sb.append("<servlet-name>");
        sb.append("Dynamic Resource Servlet");
        sb.append("</servlet-name>");
        sb.append("<servlet-class>");
        sb.append(PortalClassLoaderServlet.class.getName());
        sb.append("</servlet-class>");
        sb.append("<init-param>");
        sb.append("<param-name>");
        sb.append("servlet-class");
        sb.append("</param-name>");
        sb.append("<param-value>");
        sb.append(DynamicResourceServlet.class.getName());
        sb.append("</param-value>");
        sb.append("</init-param>");
        sb.append("<load-on-startup>1</load-on-startup>");
        sb.append("</servlet>");
        for (String allowedPath : PropsValues.DYNAMIC_RESOURCE_SERVLET_ALLOWED_PATHS) {
            sb.append("<servlet-mapping>");
            sb.append("<servlet-name>");
            sb.append("Dynamic Resource Servlet");
            sb.append("</servlet-name>");
            sb.append("<url-pattern>");
            sb.append(allowedPath);
            if (!allowedPath.endsWith("/")) {
                sb.append("/");
            }
            sb.append("*</url-pattern>");
            sb.append("</servlet-mapping>");
        }
        return sb.toString();
    }

    private String _getInvokerFilterContent() {
        return StringBundler.concat((String[])new String[]{this._getInvokerFilterContent("ASYNC"), this._getInvokerFilterContent("ERROR"), this._getInvokerFilterContent("FORWARD"), this._getInvokerFilterContent("INCLUDE"), this._getInvokerFilterContent("REQUEST")});
    }

    private String _getInvokerFilterContent(String dispatcher) {
        StringBundler sb = new StringBundler(24);
        sb.append("<filter>");
        sb.append("<filter-name>Invoker Filter - ");
        sb.append(dispatcher);
        sb.append("</filter-name>");
        sb.append("<filter-class>");
        sb.append(InvokerFilter.class.getName());
        sb.append("</filter-class>");
        sb.append("<async-supported>true</async-supported>");
        sb.append("<init-param>");
        sb.append("<param-name>dispatcher</param-name>");
        sb.append("<param-value>");
        sb.append(dispatcher);
        sb.append("</param-value>");
        sb.append("</init-param>");
        sb.append("</filter>");
        sb.append("<filter-mapping>");
        sb.append("<filter-name>Invoker Filter - ");
        sb.append(dispatcher);
        sb.append("</filter-name>");
        sb.append("<url-pattern>/*</url-pattern>");
        sb.append("<dispatcher>");
        sb.append(dispatcher);
        sb.append("</dispatcher>");
        sb.append("</filter-mapping>");
        return sb.toString();
    }

    private String _getPluginPackageLicensesXml(List<License> licenses) {
        if (licenses.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(5 * licenses.size() + 2);
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<license osi-approved=\"");
            sb.append(license.isOsiApproved());
            sb.append("\">");
            sb.append(license.getName());
            sb.append("</license>\r\n");
            if (i + 1 != licenses.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    private String _getPluginPackageLiferayVersionsXml(List<String> liferayVersions) {
        if (liferayVersions.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(liferayVersions.size() * 3 + 2);
        for (int i = 0; i < liferayVersions.size(); ++i) {
            String liferayVersion = liferayVersions.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<liferay-version>");
            sb.append(liferayVersion);
            sb.append("</liferay-version>\r\n");
            if (i + 1 != liferayVersions.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    private Properties _getPluginPackageProperties(File srcFile) throws Exception {
        File propertiesFile = new File(srcFile + "/WEB-INF/liferay-plugin-package.properties");
        if (!propertiesFile.exists()) {
            return null;
        }
        String propertiesString = FileUtil.read((File)propertiesFile);
        return PropertiesUtil.load((String)propertiesString);
    }

    private String _getPluginPackageRequiredDeploymentContextsXml(List<String> requiredDeploymentContexts) {
        if (requiredDeploymentContexts.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(requiredDeploymentContexts.size() * 3 + 2);
        for (int i = 0; i < requiredDeploymentContexts.size(); ++i) {
            String requiredDeploymentContext = requiredDeploymentContexts.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<required-deployment-context>");
            sb.append(requiredDeploymentContext);
            sb.append("</required-deployment-context>\r\n");
            if (i + 1 != requiredDeploymentContexts.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    private String _getPluginPackageTagsXml(List<String> tags) {
        if (tags.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(tags.size() * 3 + 2);
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<tag>");
            sb.append(tag);
            sb.append("</tag>\r\n");
            if (i + 1 != tags.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    private Map<String, String> _getPluginPackageXmlFilterMap(PluginPackage pluginPackage) {
        List pluginTypes = pluginPackage.getTypes();
        String pluginType = (String)pluginTypes.get(0);
        if (!pluginType.equals(this.getPluginType())) {
            return null;
        }
        return HashMapBuilder.put((Object)"author", (Object)this._wrapCDATA(pluginPackage.getAuthor())).put((Object)"change_log", (Object)this._wrapCDATA(pluginPackage.getChangeLog())).put((Object)"licenses", (Object)this._getPluginPackageLicensesXml(pluginPackage.getLicenses())).put((Object)"liferay_versions", (Object)this._getPluginPackageLiferayVersionsXml(pluginPackage.getLiferayVersions())).put((Object)"long_description", (Object)this._wrapCDATA(pluginPackage.getLongDescription())).put((Object)"module_artifact_id", (Object)pluginPackage.getArtifactId()).put((Object)"module_group_id", (Object)pluginPackage.getGroupId()).put((Object)"module_version", (Object)pluginPackage.getVersion()).put((Object)"page_url", (Object)pluginPackage.getPageURL()).put((Object)"plugin_name", (Object)this._wrapCDATA(pluginPackage.getName())).put((Object)"plugin_type", (Object)pluginType).put((Object)"plugin_type_name", (Object)TextFormatter.format((String)pluginType, (int)9)).put((Object)"recommended_deployment_context", (Object)pluginPackage.getRecommendedDeploymentContext()).put((Object)"required_deployment_contexts", (Object)this._getPluginPackageRequiredDeploymentContextsXml(pluginPackage.getRequiredDeploymentContexts())).put((Object)"short_description", (Object)this._wrapCDATA(pluginPackage.getShortDescription())).put((Object)"tags", (Object)this._getPluginPackageTagsXml(pluginPackage.getTags())).build();
    }

    private void _mergeDirectory(File mergeDir, File targetDir) {
        if (mergeDir == null || !mergeDir.exists()) {
            return;
        }
        CopyTask.copyDirectory((File)mergeDir, (File)targetDir, null, null, (boolean)true, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginPackage _readPluginPackage(File file) {
        if (!file.exists()) {
            return null;
        }
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            ZipEntry zipEntry;
            File pluginPackageXmlFile;
            boolean parseProps = false;
            if (file.isDirectory()) {
                String path = file.getPath();
                File pluginPackageXmlFile2 = new File(StringBundler.concat((String[])new String[]{file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.xml"}));
                if (pluginPackageXmlFile2.exists()) {
                    inputStream = new FileInputStream(pluginPackageXmlFile2);
                } else {
                    pluginPackageXmlFile2 = new File(path + "/WEB-INF/liferay-plugin-package.xml");
                    if (pluginPackageXmlFile2.exists()) {
                        inputStream = new FileInputStream(pluginPackageXmlFile2);
                    }
                }
                File pluginPackagePropertiesFile = new File(StringBundler.concat((String[])new String[]{file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.properties"}));
                if (inputStream == null && pluginPackagePropertiesFile.exists()) {
                    inputStream = new FileInputStream(pluginPackagePropertiesFile);
                    parseProps = true;
                } else {
                    pluginPackagePropertiesFile = new File(path + "/WEB-INF/liferay-plugin-package.properties");
                    if (inputStream == null && pluginPackagePropertiesFile.exists()) {
                        inputStream = new FileInputStream(pluginPackagePropertiesFile);
                        parseProps = true;
                    }
                }
            } else {
                zipFile = new ZipFile(file);
                pluginPackageXmlFile = new File(StringBundler.concat((String[])new String[]{file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.xml"}));
                if (pluginPackageXmlFile.exists()) {
                    inputStream = new FileInputStream(pluginPackageXmlFile);
                } else {
                    ZipEntry zipEntry2 = zipFile.getEntry("WEB-INF/liferay-plugin-package.xml");
                    if (zipEntry2 != null) {
                        inputStream = zipFile.getInputStream(zipEntry2);
                    }
                }
                File pluginPackagePropertiesFile = new File(StringBundler.concat((String[])new String[]{file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.properties"}));
                if (inputStream == null && pluginPackagePropertiesFile.exists()) {
                    inputStream = new FileInputStream(pluginPackagePropertiesFile);
                    parseProps = true;
                } else {
                    zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.properties");
                    if (inputStream == null && zipEntry != null) {
                        inputStream = zipFile.getInputStream(zipEntry);
                        parseProps = true;
                    }
                }
            }
            if (inputStream == null) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{file.getPath(), " does not have a ", "WEB-INF/liferay-plugin-package.xml or ", "WEB-INF/liferay-plugin-package.properties"}));
                }
                pluginPackageXmlFile = null;
                return pluginPackageXmlFile;
            }
            if (parseProps) {
                String propertiesString = StringUtil.read((InputStream)inputStream);
                Properties properties = PropertiesUtil.load((String)propertiesString);
                zipEntry = PluginPackageUtil.readPluginPackageProperties(this._getDisplayName(file), properties);
                return zipEntry;
            }
            String xml = StringUtil.read((InputStream)inputStream);
            xml = XMLUtil.fixProlog((String)xml);
            PluginPackage pluginPackage = PluginPackageUtil.readPluginPackageXml(xml);
            return pluginPackage;
        }
        catch (Exception exception) {
            _log.error((Object)(file.getPath() + ": " + exception.toString()), (Throwable)exception);
        }
        finally {
            block49: {
                block48: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ioException) {
                            if (!_log.isDebugEnabled()) break block48;
                            _log.debug((Object)ioException, (Throwable)ioException);
                        }
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ioException) {
                        if (!_log.isDebugEnabled()) break block49;
                        _log.debug((Object)ioException, (Throwable)ioException);
                    }
                }
            }
        }
        return null;
    }

    private void _rewriteFiles(File srcDir) throws Exception {
        String[] fileNames;
        for (String fileName : fileNames = FileUtil.listFiles((String)(srcDir + "/WEB-INF/"))) {
            String ext;
            String shortFileName = GetterUtil.getString((String)FileUtil.getShortFileName((String)fileName));
            if (StringUtil.equalsIgnoreCase((String)shortFileName, (String)"mule-config.xml") || !StringUtil.equalsIgnoreCase((String)(ext = GetterUtil.getString((String)FileUtil.getExtension((String)fileName))), (String)"xml")) continue;
            File file = new File(srcDir + "/WEB-INF/" + fileName);
            try {
                Document doc = UnsecureSAXReaderUtil.read((File)file);
                String content = doc.formattedString("\t", true);
                FileUtil.write((File)file, (String)content);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to format ", file, ": ", exception.getMessage()}));
            }
        }
    }

    private String _secureWebXml(String content, boolean hasCustomServletListener, boolean securityManagerEnabled) throws Exception {
        if (!hasCustomServletListener && !securityManagerEnabled) {
            return content;
        }
        Document document = UnsecureSAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        ArrayList<String> listenerClasses = new ArrayList<String>();
        List listenerElements = rootElement.elements("listener");
        for (Element listenerElement : listenerElements) {
            String listenerClass = GetterUtil.getString((String)listenerElement.elementText("listener-class"));
            if (listenerClass.equals(PluginContextListener.class.getName()) || listenerClass.equals(SecurePluginContextListener.class.getName())) continue;
            listenerClasses.add(listenerClass);
            listenerElement.detach();
        }
        Element contextParamElement = rootElement.addElement("context-param");
        DocUtil.add((Element)contextParamElement, (String)"param-name", (String)"portalListenerClasses");
        DocUtil.add((Element)contextParamElement, (String)"param-value", (String)StringUtil.merge(listenerClasses));
        if (!securityManagerEnabled) {
            return document.compactString();
        }
        List servletElements = rootElement.elements("servlet");
        for (Element servletElement : servletElements) {
            Element servletClassElement = servletElement.element("servlet-class");
            String servletClass = GetterUtil.getString((String)servletClassElement.getText());
            if (servletClass.equals(PortalClassLoaderServlet.class.getName()) || servletClass.equals(PortalDelegateServlet.class.getName()) || servletClass.equals(PortletServlet.class.getName())) continue;
            servletClassElement.setText(SecureServlet.class.getName());
            Element initParamElement = servletElement.addElement("init-param");
            DocUtil.add((Element)initParamElement, (String)"param-name", (String)"servlet-class");
            DocUtil.add((Element)initParamElement, (String)"param-value", (String)servletClass);
        }
        return document.compactString();
    }

    private String _updateLiferayWebXml(double webXmlVersion, File srcFile, String webXmlContent) throws Exception {
        boolean liferayWebXmlEnabled = true;
        Properties properties = this._getPluginPackageProperties(srcFile);
        if (properties != null) {
            liferayWebXmlEnabled = GetterUtil.getBoolean((String)properties.getProperty("liferay-web-xml-enabled"), (boolean)true);
        }
        webXmlContent = WebXMLBuilder.organizeWebXML(webXmlContent);
        int x = webXmlContent.indexOf("<filter>");
        int y = webXmlContent.lastIndexOf("</filter-mapping>");
        String webXmlFiltersContent = "";
        if (x == -1 || y == -1) {
            y = x = webXmlContent.lastIndexOf("</display-name>") + 15;
        } else if (liferayWebXmlEnabled && webXmlVersion > 2.3) {
            webXmlFiltersContent = webXmlContent.substring(x, y + 17);
            y += 17;
        } else {
            x = y + 17;
            y += 17;
        }
        if (webXmlVersion < 2.4) {
            return webXmlContent.substring(0, x) + this.getExtraFiltersContent(webXmlVersion, srcFile) + webXmlContent.substring(y);
        }
        String filtersContent = webXmlFiltersContent + this.getExtraFiltersContent(webXmlVersion, srcFile);
        String liferayWebXmlContent = FileUtil.read((String)DeployUtil.getResourcePath(this.tempDirPaths, "web.xml"));
        int z = liferayWebXmlContent.indexOf("</web-app>");
        liferayWebXmlContent = liferayWebXmlContent.substring(0, z) + filtersContent + liferayWebXmlContent.substring(z);
        liferayWebXmlContent = WebXMLBuilder.organizeWebXML(liferayWebXmlContent);
        FileUtil.write((String)(srcFile + "/WEB-INF/liferay-web.xml"), (String)liferayWebXmlContent);
        return webXmlContent.substring(0, x) + this._getInvokerFilterContent() + webXmlContent.substring(y);
    }

    private void _updateWebXml(File webXml, File srcFile, String displayName) throws Exception {
        Document document;
        Element rootElement;
        double webXmlVersion;
        String content = FileUtil.read((File)webXml);
        int x = (content = WebXMLBuilder.organizeWebXML(content)).indexOf("<display-name>");
        if (x != -1) {
            int y = content.indexOf("</display-name>", x);
            y = content.indexOf(">", y) + 1;
            content = content.substring(0, x) + content.substring(y);
        }
        if ((webXmlVersion = GetterUtil.getDouble((String)(rootElement = (document = UnsecureSAXReaderUtil.read((String)content)).getRootElement()).attributeValue("version"), (double)2.3)) <= 2.3) {
            throw new AutoDeployException(webXml.getName() + " must be updated to the Servlet 2.4 specification");
        }
        StringBundler sb = new StringBundler(5);
        sb.append("<listener>");
        sb.append("<listener-class>");
        boolean hasCustomServletListener = false;
        List listenerElements = rootElement.elements("listener");
        for (Element listenerElement : listenerElements) {
            String listenerClass = GetterUtil.getString((String)listenerElement.elementText("listener-class"));
            if (listenerClass.equals(PluginContextListener.class.getName()) || listenerClass.equals(SerializableSessionAttributeListener.class.getName()) || listenerClass.equals(SecurePluginContextListener.class.getName())) continue;
            hasCustomServletListener = true;
            break;
        }
        boolean securityManagerEnabled = false;
        Properties properties = this._getPluginPackageProperties(srcFile);
        if (properties != null) {
            securityManagerEnabled = GetterUtil.getBoolean((String)properties.getProperty("security-manager-enabled"));
        }
        if (hasCustomServletListener || securityManagerEnabled) {
            sb.append(SecurePluginContextListener.class.getName());
        } else {
            sb.append(PluginContextListener.class.getName());
        }
        sb.append("</listener-class>");
        sb.append("</listener>");
        String pluginContextListenerContent = sb.toString();
        String extraContent = this.getExtraContent(webXmlVersion, srcFile, displayName);
        int pos = content.indexOf("<listener>");
        if (pos == -1) {
            pos = content.indexOf("</web-app>");
        }
        String newContent = StringBundler.concat((String[])new String[]{content.substring(0, pos), pluginContextListenerContent, extraContent, content.substring(pos)});
        newContent = this._updateLiferayWebXml(webXmlVersion, srcFile, newContent);
        newContent = this._secureWebXml(newContent, hasCustomServletListener, securityManagerEnabled);
        newContent = WebXMLBuilder.organizeWebXML(newContent);
        FileUtil.write((File)webXml, (String)newContent, (boolean)true);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Modifying Servlet ", webXmlVersion, " ", webXml}));
        }
    }

    private String _wrapCDATA(String string) {
        return "<![CDATA[" + string + "]]>";
    }
}

