/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.internal.dao.sql.transformer.SQLFunctionTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2SQLTransformerLogic
extends BaseSQLTransformerLogic {
    private static final Pattern _questionMarkPattern = Pattern.compile("((?![\\'|\\\"][\\w\\s]*[\\\\'|\\\\\"]*[\\w\\s]*) \\?(?![\\w\\s]*[\\\\'|\\\\\"]*[\\w\\s]*[\\'|\\\"]))", 2);

    public DB2SQLTransformerLogic(DB db) {
        super(db);
        Object[] functions = new Function[]{this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getConcatFunction(), this.getDropTableIfExistsTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction(), this._getQuestionMarkFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = (Function[])ArrayUtil.append((Object[])functions, this.getLowerFunction());
        }
        this.setFunctions((Function[])functions);
    }

    @Override
    protected Function<String, String> getConcatFunction() {
        SQLFunctionTransformer sqlFunctionTransformer = new SQLFunctionTransformer("CONCAT(", "", " CONCAT ", "");
        return sqlFunctionTransformer::transform;
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS VARCHAR(2000))");
    }

    @Override
    protected String replaceDropTableIfExistsText(Matcher matcher) {
        String dropTableIfExists = StringBundler.concat((String[])new String[]{"BEGIN\n", "DECLARE CONTINUE HANDLER FOR SQLSTATE '42704'\n", "BEGIN END;\n", "EXECUTE IMMEDIATE 'DROP TABLE $1';\n", "END"});
        return matcher.replaceAll(dropTableIfExists);
    }

    private Function<String, String> _getQuestionMarkFunction() {
        return sql -> {
            Matcher matcher = _questionMarkPattern.matcher((CharSequence)sql);
            return matcher.replaceAll(" COALESCE(CAST(? AS VARCHAR(2000)),'')");
        };
    }
}

