/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogContext;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class LogContextLogWrapper
extends LogWrapper {
    private static volatile ServiceTrackerList<LogContext> _serviceTrackerList;

    public LogContextLogWrapper(Log log) {
        super(log);
        this.setLogWrapperClassName(LogContextLogWrapper.class.getName());
    }

    public void debug(Object message) {
        super.debug(this._getLogContextMessage(message));
    }

    public void debug(Object message, Throwable throwable) {
        super.debug(this._getLogContextMessage(message), throwable);
    }

    public void debug(Throwable throwable) {
        super.debug(this._getLogContextMessage(null), throwable);
    }

    public void error(Object message) {
        super.error(this._getLogContextMessage(message));
    }

    public void error(Object message, Throwable throwable) {
        super.error(this._getLogContextMessage(message), throwable);
    }

    public void error(Throwable throwable) {
        super.error(this._getLogContextMessage(null), throwable);
    }

    public void fatal(Object message) {
        super.fatal(this._getLogContextMessage(message));
    }

    public void fatal(Object message, Throwable throwable) {
        super.fatal(this._getLogContextMessage(message), throwable);
    }

    public void fatal(Throwable throwable) {
        super.fatal(this._getLogContextMessage(null), throwable);
    }

    public void info(Object message) {
        super.info(this._getLogContextMessage(message));
    }

    public void info(Object message, Throwable throwable) {
        super.info(this._getLogContextMessage(message), throwable);
    }

    public void info(Throwable throwable) {
        super.info(this._getLogContextMessage(null), throwable);
    }

    public void trace(Object message) {
        super.trace(this._getLogContextMessage(message));
    }

    public void trace(Object message, Throwable throwable) {
        super.trace(this._getLogContextMessage(message), throwable);
    }

    public void trace(Throwable throwable) {
        super.trace(this._getLogContextMessage(null), throwable);
    }

    public void warn(Object message) {
        super.warn(this._getLogContextMessage(message));
    }

    public void warn(Object message, Throwable throwable) {
        super.warn(this._getLogContextMessage(message), throwable);
    }

    public void warn(Throwable throwable) {
        super.warn(this._getLogContextMessage(null), throwable);
    }

    private Object _getLogContextMessage(Object message) {
        ServiceTrackerList<LogContext> serviceTrackerList = _serviceTrackerList;
        if (serviceTrackerList == null) {
            return message;
        }
        StringBundler sb = new StringBundler();
        for (LogContext logContext : serviceTrackerList) {
            Map context = logContext.getContext();
            if (context.isEmpty()) continue;
            sb.append("{");
            sb.append(logContext.getName());
            sb.append("{");
            List keys = ListUtil.fromMapKeys((Map)context);
            Collections.sort(keys);
            for (String key : keys) {
                sb.append("\"");
                sb.append(key);
                sb.append("\":\"");
                sb.append((String)context.get(key));
                sb.append("\"");
                sb.append(",");
            }
            sb.setStringAt("}}", sb.index() - 1);
            sb.append(",");
        }
        if (sb.index() == 0) {
            return message;
        }
        if (message != null) {
            sb.setStringAt(message.toString(), sb.index() - 1);
        } else {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    static {
        PortalLifecycleUtil.register((PortalLifecycle)new BasePortalLifecycle(){

            protected void doPortalDestroy() {
                ServiceTrackerList serviceTrackerList = _serviceTrackerList;
                _serviceTrackerList = null;
                if (serviceTrackerList != null) {
                    serviceTrackerList.close();
                }
            }

            protected void doPortalInit() {
                _serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), LogContext.class);
            }
        }, (int)0);
    }
}

