/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.themepreview;

import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.strip.StripFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThemePreviewFilter
extends BasePortalFilter {
    private static final String _THEME_PREVIEW = "themePreview";

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.isThemePreview(httpServletRequest);
    }

    protected String getContent(HttpServletRequest httpServletRequest, String content) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Pattern cssPattern = Pattern.compile(themeDisplay.getPathThemeCss());
        Matcher cssMatcher = cssPattern.matcher(content);
        content = cssMatcher.replaceAll("css");
        Pattern imagePattern = Pattern.compile(themeDisplay.getPathThemeImages());
        Matcher imageMatcher = imagePattern.matcher(content);
        return imageMatcher.replaceAll("images");
    }

    protected boolean isThemePreview(HttpServletRequest httpServletRequest) {
        return ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)_THEME_PREVIEW);
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        httpServletRequest.setAttribute(StripFilter.SKIP_FILTER, (Object)Boolean.TRUE);
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        this.processFilter(ThemePreviewFilter.class.getName(), httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, filterChain);
        String content = bufferCacheServletResponse.getString();
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)this.getContent(httpServletRequest, content));
    }
}

