/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PortalInstances {
    private static final String _GET_COMPANY_IDS = "select companyId from Company";
    private static final Log _log = LogFactoryUtil.getLog(PortalInstances.class);
    private static final Set<String> _autoLoginIgnoreHosts;
    private static final Set<String> _autoLoginIgnorePaths;
    private static long[] _companyIds;
    private static final Set<String> _virtualHostsIgnoreHosts;
    private static final Set<String> _virtualHostsIgnorePaths;
    private static String[] _webIds;

    public static void addCompanyId(long companyId) {
        if (ArrayUtil.contains((long[])_companyIds, (long)companyId)) {
            return;
        }
        long[] companyIds = new long[_companyIds.length + 1];
        System.arraycopy(_companyIds, 0, companyIds, 0, _companyIds.length);
        companyIds[PortalInstances._companyIds.length] = companyId;
        _companyIds = companyIds;
    }

    public static long getCompanyId(HttpServletRequest httpServletRequest) {
        long cookieCompanyId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        Long companyIdObj = (Long)httpServletRequest.getAttribute("COMPANY_ID");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from request " + companyIdObj));
        }
        if (companyIdObj != null) {
            return companyIdObj;
        }
        long companyId = PortalInstances._getCompanyIdByVirtualHosts(httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from host " + companyId));
        }
        if (companyId <= 0L && (cookieCompanyId = GetterUtil.getLong((String)CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)"COMPANY_ID", (boolean)false))) > 0L) {
            try {
                Company cookieCompany = CompanyLocalServiceUtil.fetchCompanyById((long)cookieCompanyId);
                if (cookieCompany == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Company id from cookie " + cookieCompanyId + " does not exist"));
                    }
                } else {
                    companyId = cookieCompanyId;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Company id from cookie " + companyId));
                    }
                }
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        if (companyId <= 0L) {
            companyId = PortalInstances.getDefaultCompanyId();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Default company id " + companyId));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set company id " + companyId));
        }
        httpServletRequest.setAttribute("COMPANY_ID", (Object)companyId);
        CompanyThreadLocal.setCompanyId((Long)companyId);
        if (Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET") == null) {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)companyId, (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
                TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
                if (virtualHostnames.isEmpty()) {
                    httpServletRequest.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
                }
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        return companyId;
    }

    public static long[] getCompanyIds() {
        return _companyIds;
    }

    public static long[] getCompanyIdsBySQL() throws SQLException {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        long defaultCompanyId = PortalInstances.getDefaultCompanyIdBySQL();
        if (defaultCompanyId != 0L) {
            companyIds.add(defaultCompanyId);
        }
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(_GET_COMPANY_IDS);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                if (companyId == defaultCompanyId) continue;
                companyIds.add(companyId);
            }
        }
        return ArrayUtil.toArray((Long[])companyIds.toArray(new Long[0]));
    }

    public static long getDefaultCompanyId() {
        return _companyIds[0];
    }

    public static long getDefaultCompanyIdBySQL() throws SQLException {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = '" + PropsValues.COMPANY_DEFAULT_WEB_ID + "'");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
        }
        return 0L;
    }

    public static String[] getWebIds() {
        if (_webIds != null) {
            return _webIds;
        }
        if (Validator.isNull((String)PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new RuntimeException("Default web id must not be null");
        }
        try {
            ArrayList webIdsList = new ArrayList();
            CompanyLocalServiceUtil.forEachCompany(company -> {
                String webId = company.getWebId();
                if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                    webIdsList.add(0, webId);
                } else {
                    webIdsList.add(webId);
                }
            });
            _webIds = webIdsList.toArray(new String[0]);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        if (ArrayUtil.isEmpty((Object[])_webIds)) {
            _webIds = new String[]{PropsValues.COMPANY_DEFAULT_WEB_ID};
        }
        return _webIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long initCompany(ServletContext servletContext, String webId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Begin initializing company with web id " + webId));
        }
        long companyId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.getCompanyByWebId((String)webId);
            companyId = company.getCompanyId();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return companyId;
        }
        Long currentThreadCompanyId = CompanyThreadLocal.getCompanyId();
        String currentThreadPrincipalName = PrincipalThreadLocal.getName();
        try {
            User user;
            CompanyThreadLocal.setCompanyId((Long)companyId);
            try {
                CompanyLocalServiceUtil.checkCompany((String)webId);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
            String principalName = null;
            long userId = PrincipalThreadLocal.getUserId();
            if (userId > 0L && (user = UserLocalServiceUtil.fetchUser((long)userId)) != null && user.getCompanyId() == companyId) {
                principalName = currentThreadPrincipalName;
            }
            PrincipalThreadLocal.setName(principalName);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initialize display");
            }
            try {
                String xml = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-display.xml"));
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                if (portletCategory == null) {
                    portletCategory = new PortletCategory();
                }
                PortletCategory newPortletCategory = PortletLocalServiceUtil.getEARDisplay((String)xml);
                portletCategory.merge(newPortletCategory);
                for (long currentCompanyId : _companyIds) {
                    PortletCategory currentPortletCategory = (PortletCategory)WebAppPool.get(currentCompanyId, "PORTLET_CATEGORY");
                    if (currentPortletCategory == null) continue;
                    portletCategory.merge(currentPortletCategory);
                }
                WebAppPool.put(companyId, "PORTLET_CATEGORY", portletCategory);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Process application startup events");
            }
            try {
                EventsProcessorUtil.process("application.startup.events", PropsValues.APPLICATION_STARTUP_EVENTS, new String[]{String.valueOf(companyId)});
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"End initializing company with web id ", webId, " and company id ", companyId}));
            }
            PortalInstances.addCompanyId(companyId);
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)currentThreadCompanyId);
            PrincipalThreadLocal.setName((String)currentThreadPrincipalName);
        }
        return companyId;
    }

    public static boolean isAutoLoginIgnoreHost(String host) {
        return _autoLoginIgnoreHosts.contains(host);
    }

    public static boolean isAutoLoginIgnorePath(String path) {
        return _autoLoginIgnorePaths.contains(path);
    }

    public static boolean isCompanyActive(long companyId) {
        try {
            Company company = CompanyLocalServiceUtil.fetchCompanyById((long)companyId);
            if (company != null) {
                return company.isActive();
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return false;
    }

    public static boolean isVirtualHostsIgnoreHost(String host) {
        return _virtualHostsIgnoreHosts.contains(host);
    }

    public static boolean isVirtualHostsIgnorePath(String path) {
        return _virtualHostsIgnorePaths.contains(path);
    }

    public static void reload(ServletContext servletContext) {
        String[] webIds;
        _companyIds = new long[0];
        _webIds = null;
        for (String webId : webIds = PortalInstances.getWebIds()) {
            PortalInstances.initCompany(servletContext, webId);
        }
    }

    public static void removeCompany(long companyId) {
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        _companyIds = ArrayUtil.remove((long[])_companyIds, (long)companyId);
        _webIds = null;
        PortalInstances.getWebIds();
        WebAppPool.remove(companyId, "PORTLET_CATEGORY");
    }

    private static long _getCompanyIdByVirtualHosts(HttpServletRequest httpServletRequest) {
        String host = PortalUtil.getHost((HttpServletRequest)httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Host " + host));
        }
        if (Validator.isNull((String)host) || PortalInstances.isVirtualHostsIgnoreHost(host)) {
            return 0L;
        }
        try {
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)host);
            if (virtualHost == null) {
                return 0L;
            }
            if (virtualHost.getLayoutSetId() != 0L) {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)virtualHost.getLayoutSetId());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Company ", virtualHost.getCompanyId(), " is associated with layout set ", virtualHost.getLayoutSetId()}));
                }
                httpServletRequest.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
                String languageId = virtualHost.getLanguageId();
                if (Validator.isNotNull((String)languageId) && LanguageUtil.isAvailableLocale((long)layoutSet.getGroupId(), (String)languageId)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Virtual host ", virtualHost.getHostname(), " has default language ", languageId}));
                    }
                    httpServletRequest.setAttribute("I18N_LANGUAGE_ID", (Object)languageId);
                }
            }
            return virtualHost.getCompanyId();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return 0L;
        }
    }

    private PortalInstances() {
    }

    static {
        _companyIds = new long[0];
        _autoLoginIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.hosts"));
        _autoLoginIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.paths"));
        _virtualHostsIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.hosts"));
        _virtualHostsIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.paths"));
    }
}

