/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.memory.DeleteFileFinalizeAction;
import com.liferay.petra.memory.FinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ZipWriterImpl
implements ZipWriter {
    private List<Map.Entry<String, byte[]>> _exportEntries;
    private long _exportEntriesBytes;
    private final File _file;
    private final URI _uri;

    public ZipWriterImpl() {
        this(new File(StringBundler.concat((String[])new String[]{SystemProperties.get((String)"java.io.tmpdir"), "/", PortalUUIDUtil.generate(), ".zip"})));
        FinalizeManager.register((Object)this._file, (FinalizeAction)new DeleteFileFinalizeAction(this._file.getAbsolutePath()), (FinalizeManager.ReferenceFactory)FinalizeManager.PHANTOM_REFERENCE_FACTORY);
    }

    public ZipWriterImpl(File file) {
        this._file = file.getAbsoluteFile();
        URI fileURI = this._file.toURI();
        this._uri = URI.create("jar:file:" + fileURI.getPath());
        try {
            FileSystem fileSystem = FileSystems.newFileSystem(this._uri, Collections.singletonMap("create", "true"));
            Throwable throwable = null;
            if (fileSystem != null) {
                if (throwable != null) {
                    try {
                        fileSystem.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    fileSystem.close();
                }
            }
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    public void addEntry(String name, byte[] bytes) throws IOException {
        if (bytes == null) {
            return;
        }
        if (ExportImportThreadLocal.isExportInProcess()) {
            if (this._exportEntries == null) {
                this._exportEntries = new LinkedList<Map.Entry<String, byte[]>>();
            }
            this._exportEntries.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>(name, bytes));
            this._exportEntriesBytes += (long)bytes.length;
            if (this._exportEntriesBytes >= PropsValues.ZIP_FILE_WRITER_EXPORT_BUFFER_SIZE) {
                this._writeExportEntries();
            }
            return;
        }
        try (FileSystem fileSystem = FileSystems.newFileSystem(this._uri, Collections.emptyMap());){
            Path path = fileSystem.getPath(name, new String[0]);
            Path parentPath = path.getParent();
            if (parentPath != null) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            Files.write(path, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    public void addEntry(String name, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        if (ExportImportThreadLocal.isExportInProcess()) {
            this.addEntry(name, StreamUtil.toByteArray((InputStream)inputStream));
            return;
        }
        try (FileSystem fileSystem = FileSystems.newFileSystem(this._uri, Collections.emptyMap());){
            Path path = fileSystem.getPath(name, new String[0]);
            Path parentPath = path.getParent();
            if (parentPath != null) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void addEntry(String name, String s) throws IOException {
        if (s == null) {
            return;
        }
        this.addEntry(name, s.getBytes("UTF-8"));
    }

    public void addEntry(String name, StringBuilder sb) throws IOException {
        if (sb == null) {
            return;
        }
        this.addEntry(name, sb.toString());
    }

    @Deprecated
    public byte[] finish() throws IOException {
        return FileUtil.getBytes((File)this.getFile());
    }

    public File getFile() {
        if (this._exportEntries != null) {
            this._writeExportEntries();
        }
        return this._file;
    }

    @Deprecated
    public String getPath() {
        return this._file.getPath();
    }

    @Deprecated
    public void umount() {
    }

    private void _writeExportEntries() {
        try (FileSystem fileSystem = FileSystems.newFileSystem(this._uri, Collections.emptyMap());){
            Iterator<Map.Entry<String, byte[]>> iterator = this._exportEntries.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, byte[]> entry = iterator.next();
                iterator.remove();
                Path path = fileSystem.getPath(entry.getKey(), new String[0]);
                Path parentPath = path.getParent();
                if (parentPath != null) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                Files.write(path, entry.getValue(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            }
            this._exportEntries = null;
            this._exportEntriesBytes = 0L;
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }
}

