/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.Map;

@Settings.Config(settingsIds={"com.liferay.document.library"})
public class DLGroupServiceSettings {
    private final TypedSettings _typedSettings;

    public static DLGroupServiceSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.document.library"));
        return new DLGroupServiceSettings(settings);
    }

    public static DLGroupServiceSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.document.library"));
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new DLGroupServiceSettings((Settings)parameterMapSettings);
    }

    public static void registerSettingsMetadata() {
        SettingsFactoryUtil.registerSettingsMetadata(DLGroupServiceSettings.class, null, (FallbackKeys)DLGroupServiceSettings._getFallbackKeys());
    }

    public DLGroupServiceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public LocalizedValuesMap getEmailFileEntryAddedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryAddedBody");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryAddedBodyXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryAddedBody(), (String)"emailFileEntryAdded");
    }

    public LocalizedValuesMap getEmailFileEntryAddedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryAddedSubject");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryAddedSubjectXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryAddedSubject(), (String)"emailFileEntryAddedSubject");
    }

    public LocalizedValuesMap getEmailFileEntryExpiredBody() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryExpiredBody");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryExpiredBodyXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryExpiredBody(), (String)"emailFileEntryExpired");
    }

    public LocalizedValuesMap getEmailFileEntryExpiredSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryExpiredSubject");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryExpiredSubjectXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryExpiredSubject(), (String)"emailFileEntryExpiredSubject");
    }

    public LocalizedValuesMap getEmailFileEntryReviewBody() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryReviewBody");
    }

    public String getEmailFileEntryReviewBodyXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryReviewBody(), (String)"emailFileEntryReview");
    }

    public LocalizedValuesMap getEmailFileEntryReviewSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryReviewSubject");
    }

    public String getEmailFileEntryReviewSubjectXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryReviewSubject(), (String)"emailFileEntryReviewSubject");
    }

    public LocalizedValuesMap getEmailFileEntryUpdatedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryUpdatedBody");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryUpdatedBodyXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryUpdatedBody(), (String)"emailFileEntryUpdatedBody");
    }

    public LocalizedValuesMap getEmailFileEntryUpdatedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryUpdatedSubject");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryUpdatedSubjectXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailFileEntryUpdatedSubject(), (String)"emailFileEntryUpdatedSubject");
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public boolean isEmailFileEntryAddedEnabled() {
        return this._typedSettings.getBooleanValue("emailFileEntryAddedEnabled");
    }

    public boolean isEmailFileEntryExpiredEnabled() {
        return this._typedSettings.getBooleanValue("emailFileEntryExpiredEnabled");
    }

    public boolean isEmailFileEntryReviewEnabled() {
        return this._typedSettings.getBooleanValue("emailFileEntryReviewEnabled");
    }

    public boolean isEmailFileEntryUpdatedEnabled() {
        return this._typedSettings.getBooleanValue("emailFileEntryUpdatedEnabled");
    }

    public boolean isShowHiddenMountFolders() {
        return this._typedSettings.getBooleanValue("showHiddenMountFolders");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("emailFileEntryAddedBody", new String[]{"dl.email.file.entry.added.body"});
        fallbackKeys.add("emailFileEntryAddedEnabled", new String[]{"dl.email.file.entry.added.enabled"});
        fallbackKeys.add("emailFileEntryAddedSubject", new String[]{"dl.email.file.entry.added.subject"});
        fallbackKeys.add("emailFileEntryExpiredBody", new String[]{"dl.email.file.entry.expired.body"});
        fallbackKeys.add("emailFileEntryExpiredEnabled", new String[]{"dl.email.file.entry.expired.enabled"});
        fallbackKeys.add("emailFileEntryExpiredSubject", new String[]{"dl.email.file.entry.expired.subject"});
        fallbackKeys.add("emailFileEntryReviewBody", new String[]{"dl.email.file.entry.review.body"});
        fallbackKeys.add("emailFileEntryReviewEnabled", new String[]{"dl.email.file.entry.review.enabled"});
        fallbackKeys.add("emailFileEntryReviewSubject", new String[]{"dl.email.file.entry.review.subject"});
        fallbackKeys.add("emailFileEntryUpdatedBody", new String[]{"dl.email.file.entry.updated.body"});
        fallbackKeys.add("emailFileEntryUpdatedEnabled", new String[]{"dl.email.file.entry.updated.enabled"});
        fallbackKeys.add("emailFileEntryUpdatedSubject", new String[]{"dl.email.file.entry.updated.subject"});
        fallbackKeys.add("emailFromAddress", new String[]{"dl.email.from.address", "admin.email.from.address"});
        fallbackKeys.add("emailFromName", new String[]{"dl.email.from.name", "admin.email.from.name"});
        fallbackKeys.add("enableCommentRatings", new String[]{"dl.comment.ratings.enabled"});
        fallbackKeys.add("enableRatings", new String[]{"dl.ratings.enabled"});
        fallbackKeys.add("enableRelatedAssets", new String[]{"dl.related.assets.enabled"});
        fallbackKeys.add("entriesPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("entryColumns", new String[]{"dl.entry.columns"});
        fallbackKeys.add("fileEntryColumns", new String[]{"dl.file.entry.columns"});
        fallbackKeys.add("folderColumns", new String[]{"dl.folder.columns"});
        fallbackKeys.add("foldersPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("fileEntriesPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("showFoldersSearch", new String[]{"dl.folders.search.visible"});
        fallbackKeys.add("showHiddenMountFolders", new String[]{"dl.show.hidden.mount.folders"});
        fallbackKeys.add("showSubfolders", new String[]{"dl.subfolders.visible"});
        return fallbackKeys;
    }

    static {
        SettingsFactoryUtil.registerSettingsMetadata(DLGroupServiceSettings.class, null, (FallbackKeys)DLGroupServiceSettings._getFallbackKeys());
    }
}

