/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryExternalReferenceCodeException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.ImageSizeException;
import com.liferay.document.library.kernel.exception.InvalidFileEntryTypeException;
import com.liferay.document.library.kernel.exception.InvalidFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryTable;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryMetadataPersistence;
import com.liferay.document.library.kernel.service.persistence.DLFileVersionPersistence;
import com.liferay.document.library.kernel.service.persistence.DLFolderPersistence;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.versioning.VersioningStrategy;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLinkManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.InvalidLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WebDAVPropsLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.persistence.RepositoryPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.WebDAVPropsPersistence;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupSubscriptionCheckSubscriptionSender;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.DLGroupServiceSettings;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.impl.DLFolderLocalServiceImpl;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DLFileEntryLocalServiceImpl
extends DLFileEntryLocalServiceBaseImpl {
    private static final int _EMAIL_TYPE_EXPIRED = 0;
    private static final int _EMAIL_TYPE_REVIEW = 1;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryLocalServiceImpl.class);
    private static final Pattern _fileVersionPattern = Pattern.compile("\\d+\\.\\d+");
    private static volatile VersioningStrategy _versioningStrategy = (VersioningStrategy)ServiceProxyFactory.newServiceTrackedInstance(VersioningStrategy.class, DLFileEntryLocalServiceImpl.class, (String)"_versioningStrategy", (boolean)false, (boolean)true);
    private static volatile ViewCountManager _viewCountManager = (ViewCountManager)ServiceProxyFactory.newServiceTrackedInstance(ViewCountManager.class, DLFileEntryLocalServiceImpl.class, (String)"_viewCountManager", (boolean)false, (boolean)true);
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @BeanReference(type=DLAppHelperLocalService.class)
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @BeanReference(type=DLFileEntryMetadataLocalService.class)
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @BeanReference(type=DLFileEntryMetadataPersistence.class)
    private DLFileEntryMetadataPersistence _dlFileEntryMetadataPersistence;
    @BeanReference(type=DLFileEntryTypeLocalService.class)
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @BeanReference(type=DLFileVersionLocalService.class)
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @BeanReference(type=DLFileVersionPersistence.class)
    private DLFileVersionPersistence _dlFileVersionPersistence;
    @BeanReference(type=DLFolderLocalService.class)
    private DLFolderLocalService _dlFolderLocalService;
    @BeanReference(type=DLFolderPersistence.class)
    private DLFolderPersistence _dlFolderPersistence;
    @BeanReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @BeanReference(type=ExpandoTableLocalService.class)
    private ExpandoTableLocalService _expandoTableLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=ImageLocalService.class)
    private ImageLocalService _imageLocalService;
    @BeanReference(type=OrganizationLocalService.class)
    private OrganizationLocalService _organizationLocalService;
    private Date _previousCheckDate;
    @BeanReference(type=RatingsStatsLocalService.class)
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @BeanReference(type=RepositoryPersistence.class)
    private RepositoryPersistence _repositoryPersistence;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;
    @BeanReference(type=UserGroupLocalService.class)
    private UserGroupLocalService _userGroupLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;
    @BeanReference(type=WebDAVPropsLocalService.class)
    private WebDAVPropsLocalService _webDAVPropsLocalService;
    @BeanReference(type=WebDAVPropsPersistence.class)
    private WebDAVPropsPersistence _webDAVPropsPersistence;
    @BeanReference(type=WorkflowInstanceLinkLocalService.class)
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    @Deprecated
    public DLFileEntry addFileEntry(long userId, long groupId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(null, userId, groupId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, ddmFormValuesMap, file, inputStream, size, null, null, serviceContext);
    }

    public DLFileEntry addFileEntry(String externalReferenceCode, long userId, long groupId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new FileNameException(StringBundler.concat((String[])new String[]{"Unable to add file entry with file name ", sourceFileName, " because title is null"}));
        }
        User user = this._userPersistence.findByPrimaryKey(userId);
        folderId = DLFolderLocalServiceImpl.getFolderId(this._dlFolderPersistence, user.getCompanyId(), folderId);
        String name = String.valueOf(this.counterLocalService.increment(DLFileEntry.class.getName()));
        String extension = FileUtil.getExtension((String)sourceFileName);
        String fileName = null;
        fileName = Validator.isNotNull((String)sourceFileName) ? DLUtil.getSanitizedFileName((String)FileUtil.stripExtension((String)sourceFileName), (String)extension) : DLValidatorUtil.fixName((String)DLUtil.getSanitizedFileName((String)title, (String)extension));
        if (fileEntryTypeId == -1L) {
            fileEntryTypeId = this._dlFileEntryTypeLocalService.getDefaultFileEntryTypeId(folderId);
        }
        this.validateFileEntryTypeId(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), folderId, fileEntryTypeId);
        this.validateFile(groupId, folderId, 0L, fileName, extension, title);
        long fileEntryId = this.counterLocalService.increment();
        if (Validator.isNull((String)externalReferenceCode)) {
            externalReferenceCode = String.valueOf(fileEntryId);
        }
        this._validateExternalReferenceCode(externalReferenceCode, groupId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.create(fileEntryId);
        dlFileEntry.setUuid(serviceContext.getUuid());
        dlFileEntry.setExternalReferenceCode(externalReferenceCode);
        dlFileEntry.setGroupId(groupId);
        dlFileEntry.setCompanyId(user.getCompanyId());
        dlFileEntry.setUserId(user.getUserId());
        dlFileEntry.setUserName(user.getFullName());
        DLFolder repositoryDLFolder = null;
        if (repositoryId != groupId) {
            Repository repository = this._repositoryPersistence.findByPrimaryKey(repositoryId);
            repositoryDLFolder = this._dlFolderPersistence.findByPrimaryKey(repository.getDlFolderId());
        }
        long classNameId = 0L;
        long classPK = 0L;
        if (repositoryDLFolder != null && repositoryDLFolder.isHidden()) {
            classNameId = this._classNameLocalService.getClassNameId((String)((Object)serviceContext.getAttribute("className")));
            classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
        }
        dlFileEntry.setClassNameId(classNameId);
        dlFileEntry.setClassPK(classPK);
        dlFileEntry.setRepositoryId(repositoryId);
        dlFileEntry.setFolderId(folderId);
        dlFileEntry.setTreePath(dlFileEntry.buildTreePath());
        dlFileEntry.setName(name);
        dlFileEntry.setFileName(fileName);
        dlFileEntry.setExtension(extension);
        dlFileEntry.setMimeType(mimeType);
        dlFileEntry.setTitle(title);
        dlFileEntry.setDescription(description);
        dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
        dlFileEntry.setVersion("1.0");
        dlFileEntry.setSize(size);
        dlFileEntry.setExpirationDate(expirationDate);
        dlFileEntry.setReviewDate(reviewDate);
        dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        this.addFileVersion(user, dlFileEntry, fileName, extension, mimeType, title, description, changeLog, "", fileEntryTypeId, ddmFormValuesMap, "1.0", size, expirationDate, reviewDate, 2, serviceContext);
        if (folderId != 0L) {
            this._dlFolderLocalService.updateLastPostDate(dlFileEntry.getFolderId(), dlFileEntry.getModifiedDate());
        }
        DLStoreRequest dlStoreRequest = DLStoreRequest.builder((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)name).className(dlFileEntry.getModelClassName()).classPK(dlFileEntry.getFileEntryId()).size(dlFileEntry.getSize()).sourceFileName(dlFileEntry.getFileName()).build();
        if (file != null) {
            DLStoreUtil.addFile((DLStoreRequest)dlStoreRequest, (File)file);
        } else {
            DLStoreUtil.addFile((DLStoreRequest)dlStoreRequest, (InputStream)inputStream);
        }
        return dlFileEntry;
    }

    public DLFileVersion cancelCheckOut(long userId, long fileEntryId) throws PortalException {
        if (!this.isFileEntryCheckedOut(fileEntryId)) {
            return null;
        }
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        this.removeFileVersion(dlFileEntry, dlFileVersion);
        return dlFileVersion;
    }

    public void checkFileEntries(long checkInterval) throws PortalException {
        Date date = new Date();
        if (this._previousCheckDate == null) {
            this._previousCheckDate = new Date(date.getTime() - checkInterval * 60000L);
        }
        this._checkFileEntriesByExpirationDate(date);
        this._checkFileEntriesByReviewDate(date);
        this._previousCheckDate = date;
    }

    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        DLFileVersion latestDLFileVersion;
        DLFileVersion lastDLFileVersion;
        DLVersionNumberIncrease computedDLVersionNumberIncrease;
        if (!this.isFileEntryCheckedOut(fileEntryId)) {
            return;
        }
        User user = this._userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean webDAVCheckInMode = GetterUtil.getBoolean((Object)serviceContext.getAttribute("webDAVCheckInMode"));
        boolean manualCheckInRequired = dlFileEntry.isManualCheckInRequired();
        if (!webDAVCheckInMode && manualCheckInRequired) {
            dlFileEntry.setManualCheckInRequired(false);
            dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        }
        if ((computedDLVersionNumberIncrease = this._computeDLVersionNumberIncrease(dlVersionNumberIncrease, lastDLFileVersion = this._dlFileVersionLocalService.getFileVersion(dlFileEntry.getFileEntryId(), dlFileEntry.getVersion()), latestDLFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false), serviceContext.getWorkflowAction())) == DLVersionNumberIncrease.NONE) {
            this._overwritePreviousFileVersion(user, dlFileEntry, latestDLFileVersion, lastDLFileVersion, serviceContext);
            this.unlockFileEntry(fileEntryId);
            return;
        }
        String version = this.getNextVersion(dlFileEntry, computedDLVersionNumberIncrease);
        latestDLFileVersion = this._dlFileVersionPersistence.fetchByPrimaryKey(latestDLFileVersion.getFileVersionId());
        latestDLFileVersion.setVersion(version);
        latestDLFileVersion.setChangeLog(changeLog);
        latestDLFileVersion = (DLFileVersion)this._dlFileVersionPersistence.update((BaseModel)latestDLFileVersion);
        if (dlFileEntry.getFolderId() != 0L) {
            this._dlFolderLocalService.updateLastPostDate(dlFileEntry.getFolderId(), latestDLFileVersion.getModifiedDate());
        }
        DLStoreUtil.copyFileVersion((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC", (String)version);
        this.unlockFileEntry(fileEntryId);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        Lock lock;
        if (Validator.isNotNull((String)lockUuid) && (lock = LockManagerUtil.fetchLock((String)DLFileEntry.class.getName(), (long)fileEntryId)) != null && !Objects.equals(lock.getUuid(), lockUuid)) {
            throw new InvalidLockException("UUIDs do not match");
        }
        this.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.MINOR, "", serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, long fileEntryTypeId, ServiceContext serviceContext) throws PortalException {
        return this.checkOutFileEntry(userId, fileEntryId, fileEntryTypeId, "", DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, long fileEntryTypeId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        String oldVersion = dlFileVersion.getVersion();
        DLFileEntry dlFileEntry = this._checkOutDLFileEntryModel(userId, fileEntryId, fileEntryTypeId, owner, expirationTime, serviceContext);
        if (!oldVersion.equals("PWC")) {
            if (DLStoreUtil.hasFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC")) {
                DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC");
            }
            DLStoreUtil.copyFileVersion((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)oldVersion, (String)"PWC");
        }
        return dlFileEntry;
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return this.checkOutFileEntry(userId, fileEntryId, "", DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        return this.checkOutFileEntry(userId, fileEntryId, dlFileEntry.getFileEntryTypeId(), owner, expirationTime, serviceContext);
    }

    public void convertExtraSettings(String[] keys) throws PortalException {
        int total = this.dlFileEntryFinder.countByExtraSettings();
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List dlFileEntries = this.dlFileEntryFinder.findByExtraSettings(start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                this.convertExtraSettings(dlFileEntry, keys);
            }
            intervalActionProcessor.incrementStart(dlFileEntries.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    public DLFileEntry copyFileEntry(long userId, long groupId, long repositoryId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        String sourceFileName = "A";
        String extension = dlFileEntry.getExtension();
        if (Validator.isNotNull((String)extension)) {
            sourceFileName = StringBundler.concat((String[])new String[]{sourceFileName, ".", extension});
        }
        InputStream inputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName());
        DLFileEntry newDLFileEntry = this.addFileEntry(null, userId, groupId, repositoryId, destFolderId, sourceFileName, dlFileEntry.getMimeType(), dlFileEntry.getTitle(), dlFileEntry.getDescription(), null, dlFileEntry.getFileEntryTypeId(), null, null, inputStream, dlFileEntry.getSize(), dlFileEntry.getExpirationDate(), dlFileEntry.getReviewDate(), serviceContext);
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        DLFileVersion newDLFileVersion = newDLFileEntry.getFileVersion();
        ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)dlFileVersion.getExpandoBridge(), (ExpandoBridge)newDLFileVersion.getExpandoBridge());
        this.copyFileEntryMetadata(dlFileVersion.getCompanyId(), dlFileVersion.getFileEntryTypeId(), fileEntryId, dlFileVersion.getFileVersionId(), newDLFileVersion.getFileVersionId(), serviceContext);
        return newDLFileEntry;
    }

    public void copyFileEntryMetadata(long companyId, long fileEntryTypeId, long fileEntryId, long fromFileVersionId, long toFileVersionId, ServiceContext serviceContext) throws PortalException {
        List ddmStructures;
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        if (fileEntryTypeId > 0L) {
            DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
            ddmStructures = dlFileEntryType.getDDMStructures();
        } else {
            long classNameId = this._classNameLocalService.getClassNameId(DLFileEntryMetadata.class);
            ddmStructures = DDMStructureManagerUtil.getClassStructures((long)companyId, (long)classNameId);
        }
        this.copyFileEntryMetadata(companyId, fileEntryId, fromFileVersionId, toFileVersionId, serviceContext, ddmFormValuesMap, ddmStructures);
    }

    public void deleteFileEntries(long groupId, long folderId) throws PortalException {
        this.deleteFileEntries(groupId, folderId, true);
    }

    public void deleteFileEntries(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        RepositoryEventTrigger repositoryEventTrigger = this.getFolderRepositoryEventTrigger(groupId, folderId);
        ActionableDynamicQuery actionableDynamicQuery = this.dlFileEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdproperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdproperty.eq((Object)folderId));
        });
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            if (includeTrashedEntries || !dlFileEntry.isInTrashExplicitly()) {
                repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)new LiferayFileEntry((DLFileEntry)dlFileEntry));
                this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
            }
        });
        actionableDynamicQuery.performActions();
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DLFileEntry deleteFileEntry(DLFileEntry dlFileEntry) throws PortalException {
        block4: {
            this.dlFileEntryPersistence.remove((BaseModel)dlFileEntry);
            this._resourceLocalService.deleteResource(dlFileEntry.getCompanyId(), DLFileEntry.class.getName(), 4, dlFileEntry.getFileEntryId());
            WebDAVProps webDAVProps = this._webDAVPropsPersistence.fetchByC_C(this._classNameLocalService.getClassNameId(DLFileEntry.class), dlFileEntry.getFileEntryId());
            if (webDAVProps != null) {
                this._webDAVPropsLocalService.deleteWebDAVProps(webDAVProps);
            }
            this._dlFileEntryMetadataLocalService.deleteFileEntryMetadata(dlFileEntry.getFileEntryId());
            List dlFileVersions = this._dlFileVersionPersistence.findByFileEntryId(dlFileEntry.getFileEntryId());
            for (DLFileVersion dlFileVersion : dlFileVersions) {
                this._dlFileVersionPersistence.remove((BaseModel)dlFileVersion);
                this._expandoRowLocalService.deleteRows(dlFileVersion.getFileVersionId());
                this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            }
            this._expandoRowLocalService.deleteRows(dlFileEntry.getFileEntryId());
            this._ratingsStatsLocalService.deleteStats(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
            _viewCountManager.deleteViewCount(dlFileEntry.getCompanyId(), this._classNameLocalService.getClassNameId(DLFileEntry.class), dlFileEntry.getFileEntryId());
            this.unlockFileEntry(dlFileEntry.getFileEntryId());
            try {
                DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return dlFileEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFileEntry deleteFileEntry(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        return this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.DELETE)
    public DLFileEntry deleteFileEntry(long userId, long fileEntryId) throws PortalException {
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        try {
            DLFileEntry dLFileEntry = this.dlFileEntryLocalService.deleteFileEntry(fileEntryId);
            return dLFileEntry;
        }
        finally {
            this.unlockFileEntry(fileEntryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.REINDEX)
    public DLFileEntry deleteFileVersion(long userId, long fileEntryId, String version) throws PortalException {
        if (!this._isValidFileVersionNumber(version)) {
            throw new InvalidFileVersionException(StringBundler.concat((Object[])new Object[]{"Unable to delete version for file entry ", fileEntryId, " because version number ", version, " is invalid"}));
        }
        if (version.equals("PWC")) {
            throw new InvalidFileVersionException(StringBundler.concat((Object[])new Object[]{"Unable to delete a private working copy file version ", version, " for file entry ", fileEntryId}));
        }
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        boolean latestVersion = false;
        DLFileEntry dlFileEntry = null;
        try {
            DLFileVersion dlLatestFileVersion;
            DLFileVersion dlFileVersion = this._dlFileVersionPersistence.findByF_V(fileEntryId, version);
            if (!dlFileVersion.isApproved()) {
                throw new InvalidFileVersionException(StringBundler.concat((Object[])new Object[]{"Unable to delete the unapproved file version ", version, " for file entry ", fileEntryId}));
            }
            int count = this._dlFileVersionPersistence.countByF_S(fileEntryId, 0);
            if (count <= 1) {
                throw new InvalidFileVersionException(StringBundler.concat((Object[])new Object[]{"Unable to delete the only approved file version ", version, " for file entry ", fileEntryId}));
            }
            this._dlFileVersionPersistence.remove((BaseModel)dlFileVersion);
            this._expandoRowLocalService.deleteRows(dlFileVersion.getFileVersionId());
            this._dlFileEntryMetadataLocalService.deleteFileVersionFileEntryMetadata(dlFileVersion.getFileVersionId());
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(dlFileVersion.getCompanyId(), dlFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), dlFileVersion.getFileVersionId());
            dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
            latestVersion = version.equals(dlFileEntry.getVersion());
            if (latestVersion && (dlLatestFileVersion = this._dlFileVersionLocalService.fetchLatestFileVersion(dlFileEntry.getFileEntryId(), true)) != null) {
                long fileEntryTypeId = this.getValidFileEntryTypeId(dlLatestFileVersion.getFileEntryTypeId(), dlFileEntry);
                dlLatestFileVersion.setModifiedDate(new Date());
                dlLatestFileVersion.setFileEntryTypeId(fileEntryTypeId);
                dlLatestFileVersion.setStatusDate(new Date());
                dlLatestFileVersion = (DLFileVersion)this._dlFileVersionPersistence.update((BaseModel)dlLatestFileVersion);
                dlFileEntry.setModifiedDate(new Date());
                dlFileEntry.setFileName(dlLatestFileVersion.getFileName());
                dlFileEntry.setExtension(dlLatestFileVersion.getExtension());
                dlFileEntry.setMimeType(dlLatestFileVersion.getMimeType());
                dlFileEntry.setTitle(dlLatestFileVersion.getTitle());
                dlFileEntry.setDescription(dlLatestFileVersion.getDescription());
                dlFileEntry.setExtraSettings(dlLatestFileVersion.getExtraSettings());
                dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
                dlFileEntry.setVersion(dlLatestFileVersion.getVersion());
                dlFileEntry.setSize(dlLatestFileVersion.getSize());
                dlFileEntry.setExpirationDate(dlLatestFileVersion.getExpirationDate());
                dlFileEntry.setReviewDate(dlLatestFileVersion.getReviewDate());
                dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
            }
            DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version);
        }
        finally {
            this.unlockFileEntry(fileEntryId);
        }
        if (latestVersion) {
            return dlFileEntry;
        }
        return null;
    }

    public void deleteRepositoryFileEntries(long repositoryId) throws PortalException {
        RepositoryEventTrigger repositoryEventTrigger = RepositoryUtil.getRepositoryEventTrigger(repositoryId);
        int total = this.dlFileEntryPersistence.countByRepositoryId(repositoryId);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List dlFileEntries = this.dlFileEntryPersistence.findByRepositoryId(repositoryId, start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)new LiferayFileEntry(dlFileEntry));
                this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
            }
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    public void deleteRepositoryFileEntries(long repositoryId, long folderId) throws PortalException {
        this.deleteRepositoryFileEntries(repositoryId, folderId, true);
    }

    public void deleteRepositoryFileEntries(long repositoryId, long folderId, boolean includeTrashedEntries) throws PortalException {
        RepositoryEventTrigger repositoryEventTrigger = RepositoryUtil.getRepositoryEventTrigger(repositoryId);
        int total = this.dlFileEntryPersistence.countByR_F(repositoryId, folderId);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List dlFileEntries = this.dlFileEntryPersistence.findByR_F(repositoryId, folderId, start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                if (includeTrashedEntries || !dlFileEntry.isInTrashExplicitly()) {
                    repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)new LiferayFileEntry(dlFileEntry));
                    this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
                    continue;
                }
                intervalActionProcessor.incrementStart();
            }
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    public DLFileEntry fetchFileEntry(long groupId, long folderId, String title) {
        return this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
    }

    public DLFileEntry fetchFileEntry(String uuid, long groupId) {
        return this.dlFileEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public DLFileEntry fetchFileEntryByAnyImageId(long imageId) {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.fetchBySmallImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        fileEntry = this.dlFileEntryPersistence.fetchByLargeImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        fileEntry = this.dlFileEntryPersistence.fetchByCustom1ImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        fileEntry = this.dlFileEntryPersistence.fetchByCustom2ImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        return null;
    }

    public DLFileEntry fetchFileEntryByExternalReferenceCode(long groupId, String externalReferenceCode) {
        return this.dlFileEntryPersistence.fetchByG_ERC(groupId, externalReferenceCode);
    }

    public DLFileEntry fetchFileEntryByFileName(long groupId, long folderId, String fileName) {
        return this.dlFileEntryPersistence.fetchByG_F_FN(groupId, folderId, fileName);
    }

    public DLFileEntry fetchFileEntryByName(long groupId, long folderId, String name) {
        return this.dlFileEntryPersistence.fetchByG_F_N(groupId, folderId, name);
    }

    public List<DLFileEntry> getDDMStructureFileEntries(long groupId, long[] ddmStructureIds) {
        return this.dlFileEntryFinder.findByDDMStructureIds(groupId, ddmStructureIds, -1, -1);
    }

    public List<DLFileEntry> getDDMStructureFileEntries(long[] ddmStructureIds) {
        return this.dlFileEntryFinder.findByDDMStructureIds(ddmStructureIds, -1, -1);
    }

    public List<DLFileEntry> getExtraSettingsFileEntries(int start, int end) {
        return this.dlFileEntryFinder.findByExtraSettings(start, end);
    }

    public int getExtraSettingsFileEntriesCount() {
        return this.dlFileEntryFinder.countByExtraSettings();
    }

    public InputStream getFileAsStream(long fileEntryId, String version) throws PortalException {
        return this.getFileAsStream(fileEntryId, version, true, 1);
    }

    public InputStream getFileAsStream(long fileEntryId, String version, boolean incrementCounter) throws PortalException {
        return this.getFileAsStream(fileEntryId, version, incrementCounter, 1);
    }

    public InputStream getFileAsStream(long fileEntryId, String version, boolean incrementCounter, int increment) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        if (incrementCounter) {
            this.dlFileEntryLocalService.incrementViewCounter(dlFileEntry, increment);
        }
        return DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version);
    }

    public List<DLFileEntry> getFileEntries(int start, int end) {
        return this.dlFileEntryPersistence.findAll(start, end);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId) {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<DLFileEntry> orderByComparator) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        QueryDefinition queryDefinition = new QueryDefinition(status, false, start, end, orderByComparator);
        return this.dlFileEntryFinder.findByG_F(groupId, folderIds, queryDefinition);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator<DLFileEntry> orderByComparator) {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.findByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.findByG_U_F_M(groupId, userId, folderIds, mimeTypes, queryDefinition);
    }

    public List<DLFileEntry> getFileEntries(long folderId, String name) {
        return this.dlFileEntryPersistence.findByF_N(folderId, name);
    }

    public int getFileEntriesCount() {
        return this.dlFileEntryPersistence.countAll();
    }

    public int getFileEntriesCount(long groupId, long folderId) {
        return this.dlFileEntryPersistence.countByG_F(groupId, folderId);
    }

    public int getFileEntriesCount(long groupId, long folderId, int status) {
        return this.dlFileEntryFinder.countByG_F(groupId, ListUtil.fromArray((Object[])new Long[]{folderId}), new QueryDefinition(status));
    }

    public int getFileEntriesCount(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.countByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition);
    }

    public int getFileEntriesCount(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.countByG_U_F_M(groupId, userId, folderIds, mimeTypes, queryDefinition);
    }

    public DLFileEntry getFileEntry(long fileEntryId) throws PortalException {
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    public DLFileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
        if (dlFileEntry != null) {
            return dlFileEntry;
        }
        List dlFileVersions = this._dlFileVersionPersistence.findByG_F_T_V(groupId, folderId, title, "PWC");
        long userId = PrincipalThreadLocal.getUserId();
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            if (!this.hasFileEntryLock(userId, dlFileVersion.getFileEntryId(), dlFileVersion.getFolderId())) continue;
            return dlFileVersion.getFileEntry();
        }
        throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No DLFileEntry exists with the key {groupId=", groupId, ", folderId=", folderId, ", title=", title, "}"}));
    }

    public DLFileEntry getFileEntryByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        return this.dlFileEntryPersistence.findByG_ERC(groupId, externalReferenceCode);
    }

    public DLFileEntry getFileEntryByFileName(long groupId, long folderId, String fileName) throws PortalException {
        return this.dlFileEntryPersistence.findByG_F_FN(groupId, folderId, fileName);
    }

    public DLFileEntry getFileEntryByName(long groupId, long folderId, String name) throws PortalException {
        return this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
    }

    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end) {
        return this.getGroupFileEntries(groupId, start, end, (OrderByComparator<DLFileEntry>)new RepositoryModelModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end, OrderByComparator<DLFileEntry> orderByComparator) {
        return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) {
        return this.getGroupFileEntries(groupId, userId, start, end, (OrderByComparator<DLFileEntry>)new RepositoryModelModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator<DLFileEntry> orderByComparator) {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
        }
        return this.dlFileEntryPersistence.findByG_U(groupId, userId, start, end, orderByComparator);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<DLFileEntry> orderByComparator) {
        return this.getGroupFileEntries(groupId, userId, 0L, rootFolderId, start, end, orderByComparator);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long repositoryId, long rootFolderId, int start, int end, OrderByComparator<DLFileEntry> orderByComparator) {
        List folderIds = repositoryId != 0L ? this._dlFolderLocalService.getRepositoryFolderIds(repositoryId, rootFolderId) : this._dlFolderLocalService.getGroupFolderIds(groupId, rootFolderId);
        if (folderIds.isEmpty()) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, orderByComparator);
        if (repositoryId == 0L) {
            if (userId <= 0L) {
                return this.dlFileEntryFinder.findByG_F(groupId, folderIds, queryDefinition);
            }
            return this.dlFileEntryFinder.findByG_U_F(groupId, userId, folderIds, queryDefinition);
        }
        ArrayList<Long> repositoryIds = new ArrayList<Long>();
        repositoryIds.add(repositoryId);
        if (userId <= 0L) {
            return this.dlFileEntryFinder.findByG_R_F(groupId, repositoryIds, folderIds, queryDefinition);
        }
        return this.dlFileEntryFinder.findByG_U_R_F(groupId, userId, repositoryIds, folderIds, queryDefinition);
    }

    public int getGroupFileEntriesCount(long groupId) {
        return this.dlFileEntryPersistence.countByGroupId(groupId);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.countByGroupId(groupId);
        }
        return this.dlFileEntryPersistence.countByG_U(groupId, userId);
    }

    public List<DLFileEntry> getNoAssetFileEntries() {
        return this.dlFileEntryFinder.findByNoAssets();
    }

    public List<DLFileEntry> getRepositoryFileEntries(long repositoryId, int start, int end) {
        return this.dlFileEntryPersistence.findByRepositoryId(repositoryId, start, end);
    }

    public int getRepositoryFileEntriesCount(long repositoryId) {
        return this.dlFileEntryPersistence.countByRepositoryId(repositoryId);
    }

    public String getUniqueTitle(long groupId, long folderId, long fileEntryId, String title, String extension) throws PortalException {
        String uniqueTitle = title;
        int i = 1;
        while (true) {
            String uniqueFileName = DLUtil.getSanitizedFileName((String)uniqueTitle, (String)extension);
            try {
                this.validateFile(groupId, folderId, fileEntryId, uniqueFileName, uniqueTitle);
                return uniqueTitle;
            }
            catch (DuplicateFileEntryException | DuplicateFolderNameException exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)exception, exception);
                }
                uniqueTitle = FileUtil.appendParentheticalSuffix((String)title, (String)String.valueOf(i));
                ++i;
                continue;
            }
            break;
        }
    }

    public boolean hasExtraSettings() {
        return this.dlFileEntryFinder.countByExtraSettings() > 0;
    }

    public boolean hasFileEntryLock(long userId, long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        return this.hasFileEntryLock(userId, fileEntryId, dlFileEntry.getFolderId());
    }

    public boolean hasFileEntryLock(long userId, long fileEntryId, long folderId) {
        boolean hasLock = LockManagerUtil.hasLock((long)userId, (String)DLFileEntry.class.getName(), (long)fileEntryId);
        if (hasLock || folderId == 0L) {
            return hasLock;
        }
        return this._dlFolderLocalService.hasInheritableLock(folderId);
    }

    @Transactional(enabled=false)
    public void incrementViewCounter(DLFileEntry dlFileEntry, int increment) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        _viewCountManager.incrementViewCount(dlFileEntry.getCompanyId(), this._classNameLocalService.getClassNameId(DLFileEntry.class), dlFileEntry.getFileEntryId(), increment);
    }

    public boolean isFileEntryCheckedOut(long fileEntryId) {
        int count = this._dlFileVersionPersistence.countByF_V(fileEntryId, "PWC");
        return count > 0;
    }

    public Lock lockFileEntry(long userId, long fileEntryId) throws PortalException {
        return LockManagerUtil.lock((long)userId, (String)DLFileEntry.class.getName(), (long)fileEntryId, null, (boolean)false, (long)DLFileEntryImpl.LOCK_EXPIRATION_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.REINDEX)
    public DLFileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        try {
            DLFileEntry dlFileEntry = this.moveFileEntryImpl(userId, fileEntryId, newFolderId, serviceContext);
            DLFileEntry dLFileEntry = this._dlFileEntryTypeLocalService.updateFileEntryFileEntryType(dlFileEntry, serviceContext);
            return dLFileEntry;
        }
        finally {
            if (!this.isFileEntryCheckedOut(fileEntryId)) {
                this.unlockFileEntry(fileEntryId);
            }
        }
    }

    public void rebuildTree(long companyId) throws PortalException {
        this._dlFolderLocalService.rebuildTree(companyId);
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        if (!this._isValidFileVersionNumber(version)) {
            throw new InvalidFileVersionException(StringBundler.concat((Object[])new Object[]{"Unable to revert file entry ", fileEntryId, " to version ", version, " because it is invalid"}));
        }
        if (version.equals("PWC")) {
            throw new InvalidFileVersionException("Unable to revert a private working copy file version");
        }
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getFileVersion(fileEntryId, version);
        if (!dlFileVersion.isApproved()) {
            throw new InvalidFileVersionException("Unable to revert from an unapproved file version");
        }
        DLFileVersion latestDLFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        if (version.equals(latestDLFileVersion.getVersion())) {
            throw new InvalidFileVersionException("Unable to revert from the latest file version");
        }
        String sourceFileName = dlFileVersion.getFileName();
        String changeLog = LanguageUtil.format((Locale)serviceContext.getLocale(), (String)"reverted-to-x", (Object)version, (boolean)false);
        DLVersionNumberIncrease dlVersionNumberIncrease = DLVersionNumberIncrease.MAJOR;
        Map<String, DDMFormValues> ddmFormValuesMap = null;
        InputStream inputStream = this.getFileAsStream(fileEntryId, version, false);
        serviceContext.setCommand("revert");
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        long fileEntryTypeId = this.getValidFileEntryTypeId(dlFileVersion.getFileEntryTypeId(), dlFileEntry);
        this.updateFileEntry(userId, fileEntryId, sourceFileName, dlFileVersion.getExtension(), dlFileVersion.getMimeType(), dlFileVersion.getTitle(), dlFileVersion.getDescription(), changeLog, dlVersionNumberIncrease, dlFileVersion.getExtraSettings(), fileEntryTypeId, ddmFormValuesMap, null, inputStream, dlFileVersion.getSize(), dlFileVersion.getExpirationDate(), dlFileVersion.getReviewDate(), serviceContext);
        DLFileVersion newDLFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        this.copyFileEntryMetadata(dlFileVersion.getCompanyId(), dlFileVersion.getFileEntryTypeId(), fileEntryId, dlFileVersion.getFileVersionId(), newDLFileVersion.getFileVersionId(), serviceContext);
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.search(groupId, userId, creatorUserId, 0L, null, status, start, end);
    }

    public Hits search(long groupId, long userId, long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)DLFileEntryConstants.getClassName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            searchContext.setAttribute("mimeTypes", (Serializable)mimeTypes);
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        Group group = this._groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setFolderIds(new long[]{folderId});
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return indexer.search(searchContext);
    }

    public void setTreePaths(long folderId, String treePath, boolean reindex) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
            Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
        });
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)DLFileEntry.class.getName());
        indexableActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            dlFileEntry.setTreePath(treePath);
            this.dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
            if (!reindex) {
                return;
            }
            indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(dlFileEntry)});
        });
        indexableActionableDynamicQuery.performActions();
    }

    public void unlockFileEntry(long fileEntryId) {
        LockManagerUtil.unlock((String)DLFileEntry.class.getName(), (long)fileEntryId);
    }

    public DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        DLFileEntryMetadata dlFileEntryMetadata;
        DDMStructure ddmStructure;
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        String extension = FileUtil.getExtension((String)sourceFileName);
        if (file == null && inputStream == null) {
            if (Validator.isNull((String)extension)) {
                extension = dlFileEntry.getExtension();
            }
            mimeType = dlFileEntry.getMimeType();
        }
        String extraSettings = "";
        if (fileEntryTypeId == -1L) {
            fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        }
        this.validateFileEntryTypeId(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)dlFileEntry.getGroupId()), dlFileEntry.getFolderId(), fileEntryTypeId);
        if (fileEntryTypeId != dlFileEntry.getFileEntryTypeId() && dlFileEntry.getFileEntryTypeId() != 0L && (ddmStructure = DDMStructureManagerUtil.fetchStructure((long)(dlFileEntryMetadata = this._dlFileEntryMetadataPersistence.fetchByFileEntryId_Last(fileEntryId, null)).getDDMStructureId())) != null) {
            DDMStructureLinkManagerUtil.deleteStructureLink((long)this._classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (long)dlFileEntryMetadata.getFileEntryMetadataId(), (long)ddmStructure.getStructureId());
        }
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, extension, mimeType, title, description, changeLog, dlVersionNumberIncrease, extraSettings, fileEntryTypeId, ddmFormValuesMap, file, inputStream, size, expirationDate, reviewDate, serviceContext);
    }

    @Deprecated
    public DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, fileEntryTypeId, ddmFormValuesMap, file, inputStream, size, null, null, serviceContext);
    }

    public DLFileEntry updateFileEntryType(long userId, long fileEntryId, long fileEntryTypeId, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
        this.dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, !dlFileEntry.isCheckedOut());
        dlFileVersion.setUserId(user.getUserId());
        dlFileVersion.setUserName(user.getFullName());
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
        return dlFileEntry;
    }

    @Deprecated
    public void updateSmallImage(long smallImageId, long largeImageId) throws PortalException {
        try {
            Image largeImage = this._imageLocalService.getImage(largeImageId);
            byte[] bytes = largeImage.getTextObj();
            if (bytes == null) {
                return;
            }
            ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            if (renderedImage == null) {
                return;
            }
            int height = PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.height");
            int width = PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.width");
            RenderedImage thumbnailRenderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)height, (int)width);
            this._imageLocalService.updateImage(smallImageId, ImageToolUtil.getBytes((RenderedImage)thumbnailRenderedImage, (String)largeImage.getType()));
        }
        catch (IOException ioException) {
            throw new ImageSizeException(StringBundler.concat((Object[])new Object[]{"Unable to update small image with smallImageId ", smallImageId, ", largeImageId ", largeImageId}), (Throwable)ioException);
        }
    }

    public DLFileEntry updateStatus(long userId, DLFileEntry dlFileEntry, DLFileVersion dlFileVersion, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        int oldStatus = dlFileVersion.getStatus();
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(new Date());
        dlFileVersion = (DLFileVersion)this._dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        if (status == 0) {
            int compare = DLUtil.compareVersions((String)dlFileEntry.getVersion(), (String)dlFileVersion.getVersion());
            if (compare <= 0) {
                dlFileEntry.setModifiedDate(dlFileVersion.getModifiedDate());
                dlFileEntry.setFileName(dlFileVersion.getFileName());
                dlFileEntry.setExtension(dlFileVersion.getExtension());
                dlFileEntry.setMimeType(dlFileVersion.getMimeType());
                dlFileEntry.setTitle(dlFileVersion.getTitle());
                dlFileEntry.setDescription(dlFileVersion.getDescription());
                dlFileEntry.setExtraSettings(dlFileVersion.getExtraSettings());
                dlFileEntry.setFileEntryTypeId(dlFileVersion.getFileEntryTypeId());
                dlFileEntry.setVersion(dlFileVersion.getVersion());
                dlFileEntry.setSize(dlFileVersion.getSize());
                dlFileEntry.setExpirationDate(dlFileVersion.getExpirationDate());
                dlFileEntry.setReviewDate(dlFileVersion.getReviewDate());
                dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
            }
        } else {
            if (status != 8 && Objects.equals(dlFileEntry.getVersion(), dlFileVersion.getVersion())) {
                String newVersion = "1.0";
                List approvedFileVersions = this._dlFileVersionPersistence.findByF_S(dlFileEntry.getFileEntryId(), 0);
                if (!approvedFileVersions.isEmpty()) {
                    DLFileVersion firstApprovedFileVersion = (DLFileVersion)approvedFileVersions.get(0);
                    newVersion = firstApprovedFileVersion.getVersion();
                }
                dlFileEntry.setVersion(newVersion);
                dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
            }
            if (Objects.equals(dlFileVersion.getVersion(), "1.0")) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
                indexer.delete((Object)dlFileEntry);
            }
        }
        this._dlAppHelperLocalService.updateStatus(userId, (FileEntry)new LiferayFileEntry(dlFileEntry), (FileVersion)new LiferayFileVersion(dlFileVersion), oldStatus, status, serviceContext, workflowContext);
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            if (status == 8) {
                CommentManagerUtil.moveDiscussionToTrash((String)DLFileEntry.class.getName(), (long)dlFileEntry.getFileEntryId());
            } else if (oldStatus == 8) {
                CommentManagerUtil.restoreDiscussionFromTrash((String)DLFileEntry.class.getName(), (long)dlFileEntry.getFileEntryId());
            }
        }
        if (!(status != 0 && status != 8 && oldStatus != 8 || serviceContext != null && !serviceContext.isIndexingEnabled())) {
            this.reindex(dlFileEntry);
        }
        return dlFileEntry;
    }

    public DLFileEntry updateStatus(long userId, long fileVersionId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        DLFileVersion dlFileVersion = this._dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(dlFileVersion.getFileEntryId());
        return this.updateStatus(userId, dlFileEntry, dlFileVersion, status, serviceContext, workflowContext);
    }

    public void validateFile(long groupId, long folderId, long fileEntryId, String fileName, String title) throws PortalException {
        this._validateFolder(groupId, folderId, title);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
        if (dlFileEntry != null && dlFileEntry.getFileEntryId() != fileEntryId) {
            throw new DuplicateFileEntryException("A file entry already exists with title " + title);
        }
        dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_FN(groupId, folderId, fileName);
        if (dlFileEntry != null && dlFileEntry.getFileEntryId() != fileEntryId) {
            throw new DuplicateFileEntryException("A file entry already exists with file name " + fileName);
        }
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return this.verifyFileEntryLock(fileEntryId, lockUuid) && this.isFileEntryCheckedOut(fileEntryId);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        Lock lock = LockManagerUtil.fetchLock((String)DLFileEntry.class.getName(), (long)fileEntryId);
        if (lock != null) {
            return Objects.equals(lock.getUuid(), lockUuid);
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        return this._dlFolderLocalService.verifyInheritableLock(dlFileEntry.getFolderId(), lockUuid);
    }

    protected void addFileEntryResources(DLFileEntry dlFileEntry, ServiceContext serviceContext) throws PortalException {
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this._resourceLocalService.addResources(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), false, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(dlFileEntry.getRepositoryId(), DLFileEntryConstants.getClassName());
            }
            this._resourceLocalService.addModelResources(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), serviceContext.getModelPermissions());
        }
    }

    protected DLFileVersion addFileVersion(User user, DLFileEntry dlFileEntry, String fileName, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, String version, long size, Date expirationDate, Date reviewDate, int status, ServiceContext serviceContext) throws PortalException {
        long fileVersionId = this.counterLocalService.increment();
        DLFileVersion dlFileVersion = this._dlFileVersionPersistence.create(fileVersionId);
        String uuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"fileVersionUuid", (String)serviceContext.getUuid());
        dlFileVersion.setUuid(uuid);
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(dlFileEntry.getCompanyId());
        dlFileVersion.setUserId(user.getUserId());
        dlFileVersion.setUserName(user.getFullName());
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFolderId(dlFileEntry.getFolderId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setTreePath(dlFileVersion.buildTreePath());
        dlFileVersion.setFileName(fileName);
        dlFileVersion.setExtension(extension);
        dlFileVersion.setMimeType(mimeType);
        dlFileVersion.setTitle(title);
        dlFileVersion.setDescription(description);
        dlFileVersion.setChangeLog(changeLog);
        dlFileVersion.setExtraSettings(extraSettings);
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        dlFileVersion.setVersion(version);
        dlFileVersion.setSize(size);
        dlFileVersion.setExpirationDate(expirationDate);
        dlFileVersion.setReviewDate(reviewDate);
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(dlFileEntry.getModifiedDate());
        ExpandoBridge oldExpandoBridge = dlFileVersion.getExpandoBridge();
        DLFileVersion latestFileVersion = this._dlFileVersionLocalService.fetchLatestFileVersion(dlFileEntry.getFileEntryId(), false);
        if (latestFileVersion != null) {
            oldExpandoBridge = latestFileVersion.getExpandoBridge();
        }
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)oldExpandoBridge, (ExpandoBridge)dlFileVersion.getExpandoBridge(), (ServiceContext)serviceContext);
        dlFileVersion = (DLFileVersion)this._dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        if (fileEntryTypeId > 0L && ddmFormValuesMap != null) {
            this._dlFileEntryMetadataLocalService.updateFileEntryMetadata(fileEntryTypeId, dlFileEntry.getFileEntryId(), fileVersionId, ddmFormValuesMap, serviceContext);
        }
        return dlFileVersion;
    }

    protected void convertExtraSettings(DLFileEntry dlFileEntry, DLFileVersion dlFileVersion, String[] keys) throws PortalException {
        int compare;
        UnicodeProperties extraSettingsUnicodeProperties = dlFileVersion.getExtraSettingsProperties();
        this.convertExtraSettings(extraSettingsUnicodeProperties, dlFileVersion.getExpandoBridge(), keys);
        dlFileVersion.setExtraSettingsProperties(extraSettingsUnicodeProperties);
        dlFileVersion = (DLFileVersion)this._dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        int status = dlFileVersion.getStatus();
        if (status == 0 && (compare = DLUtil.compareVersions((String)dlFileEntry.getVersion(), (String)dlFileVersion.getVersion())) <= 0) {
            this.reindex(dlFileEntry);
        }
    }

    protected void convertExtraSettings(DLFileEntry dlFileEntry, String[] keys) throws PortalException {
        UnicodeProperties extraSettingsUnicodeProperties = dlFileEntry.getExtraSettingsProperties();
        this.convertExtraSettings(extraSettingsUnicodeProperties, dlFileEntry.getExpandoBridge(), keys);
        dlFileEntry.setExtraSettingsProperties(extraSettingsUnicodeProperties);
        dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        List dlFileVersions = this._dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), -1);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            this.convertExtraSettings(dlFileEntry, dlFileVersion, keys);
        }
    }

    protected void convertExtraSettings(UnicodeProperties extraSettingsUnicodeProperties, ExpandoBridge expandoBridge, String[] keys) {
        for (String key : keys) {
            String value = extraSettingsUnicodeProperties.remove((Object)key);
            if (Validator.isNull((String)value)) continue;
            int type = expandoBridge.getAttributeType(key);
            Serializable serializable = ExpandoColumnConstants.getSerializable((int)type, (String)value);
            expandoBridge.setAttribute(key, serializable);
        }
    }

    protected void copyExpandoRowModifiedDate(long companyId, long sourceFileVersionId, long destinationFileVersionId) {
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchDefaultTable(companyId, DLFileEntry.class.getName());
        if (expandoTable == null) {
            return;
        }
        ExpandoRow sourceExpandoRow = this._expandoRowLocalService.fetchRow(expandoTable.getTableId(), sourceFileVersionId);
        if (sourceExpandoRow == null) {
            return;
        }
        ExpandoRow destinationExpandoRow = this._expandoRowLocalService.fetchRow(expandoTable.getTableId(), destinationFileVersionId);
        if (destinationExpandoRow == null) {
            return;
        }
        destinationExpandoRow.setModifiedDate(sourceExpandoRow.getModifiedDate());
        this._expandoRowLocalService.updateExpandoRow(destinationExpandoRow);
    }

    protected void copyFileEntryMetadata(long companyId, long fileEntryId, long fromFileVersionId, long toFileVersionId, ServiceContext serviceContext, Map<String, DDMFormValues> ddmFormValuesMap, List<DDMStructure> ddmStructures) throws PortalException {
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), fromFileVersionId);
            if (dlFileEntryMetadata == null) continue;
            DDMFormValues ddmFormValues = StorageEngineManagerUtil.getDDMFormValues((long)dlFileEntryMetadata.getDDMStorageId());
            ddmFormValuesMap.put(ddmStructure.getStructureKey(), ddmFormValues);
        }
        if (!ddmFormValuesMap.isEmpty()) {
            this._dlFileEntryMetadataLocalService.updateFileEntryMetadata(companyId, ddmStructures, fileEntryId, toFileVersionId, ddmFormValuesMap, serviceContext);
        }
    }

    protected RepositoryEventTrigger getFolderRepositoryEventTrigger(long groupId, long folderId) throws PortalException {
        if (folderId != 0L) {
            return RepositoryUtil.getFolderRepositoryEventTrigger(folderId);
        }
        return RepositoryUtil.getRepositoryEventTrigger(groupId);
    }

    protected String getNextVersion(DLFileEntry dlFileEntry, DLVersionNumberIncrease dlVersionNumberIncrease) throws InvalidFileVersionException {
        String version = dlFileEntry.getVersion();
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.fetchLatestFileVersion(dlFileEntry.getFileEntryId(), true);
        if (dlFileVersion != null) {
            version = dlFileVersion.getVersion();
        }
        if (!this._isValidFileVersionNumber(version)) {
            throw new InvalidFileVersionException(StringBundler.concat((Object[])new Object[]{"Unable to increase version number for file entry ", dlFileEntry.getFileEntryId(), " because original version number ", version, " is invalid"}));
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (dlVersionNumberIncrease == DLVersionNumberIncrease.MAJOR) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected long getValidFileEntryTypeId(long fileEntryTypeId, DLFileEntry dlFileEntry) throws PortalException {
        try {
            this.validateFileEntryTypeId(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)dlFileEntry.getGroupId()), dlFileEntry.getFolderId(), fileEntryTypeId);
            return fileEntryTypeId;
        }
        catch (InvalidFileEntryTypeException invalidFileEntryTypeException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)invalidFileEntryTypeException, (Throwable)invalidFileEntryTypeException);
            }
            return this._dlFileEntryTypeLocalService.getDefaultFileEntryTypeId(dlFileEntry.getFolderId());
        }
    }

    protected DLFileEntry moveFileEntryImpl(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        long oldDataRepositoryId = dlFileEntry.getDataRepositoryId();
        this.validateFile(dlFileEntry.getGroupId(), newFolderId, dlFileEntry.getFileEntryId(), dlFileEntry.getFileName(), dlFileEntry.getTitle());
        dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        dlFileEntry.setFolderId(newFolderId);
        dlFileEntry.setTreePath(dlFileEntry.buildTreePath());
        dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        List dlFileVersions = this._dlFileVersionPersistence.findByFileEntryId(fileEntryId);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            dlFileVersion.setFolderId(newFolderId);
            dlFileVersion.setTreePath(dlFileVersion.buildTreePath());
            dlFileVersion.setStatusByUserId(userId);
            dlFileVersion.setStatusByUserName(user.getFullName());
            this._dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        }
        this._dlFolderLocalService.updateLastPostDate(newFolderId, serviceContext.getModifiedDate(null));
        DLStoreUtil.updateFile((long)user.getCompanyId(), (long)oldDataRepositoryId, (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName());
        return dlFileEntry;
    }

    protected void reindex(DLFileEntry dlFileEntry) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        indexer.reindex((Object)dlFileEntry);
    }

    protected void removeFileVersion(DLFileEntry dlFileEntry, DLFileVersion dlFileVersion) throws PortalException {
        this._dlFileVersionPersistence.remove((BaseModel)dlFileVersion);
        this._expandoRowLocalService.deleteRows(dlFileVersion.getFileVersionId());
        this._dlFileEntryMetadataLocalService.deleteFileVersionFileEntryMetadata(dlFileVersion.getFileVersionId());
        this._assetEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), dlFileVersion.getPrimaryKey());
        DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC");
        this.unlockFileEntry(dlFileEntry.getFileEntryId());
    }

    protected DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String extension, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, String extraSettings, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean checkedOut = dlFileEntry.isCheckedOut();
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, !checkedOut);
        boolean autoCheckIn = false;
        if (!checkedOut && dlFileVersion.isApproved() && !Objects.equals(dlFileVersion.getUuid(), serviceContext.getUuidWithoutReset())) {
            autoCheckIn = true;
        }
        if (autoCheckIn) {
            dlFileEntry = file != null || inputStream != null ? this._checkOutDLFileEntryModel(userId, fileEntryId, fileEntryTypeId, serviceContext) : this.checkOutFileEntry(userId, fileEntryId, fileEntryTypeId, serviceContext);
        }
        if (!this.hasFileEntryLock(userId, fileEntryId, dlFileEntry.getFolderId())) {
            this.lockFileEntry(userId, fileEntryId);
        }
        if (checkedOut || autoCheckIn) {
            dlFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        }
        try {
            if (Validator.isNull((String)extension)) {
                extension = dlFileEntry.getExtension();
            }
            if (Validator.isNull((String)mimeType)) {
                mimeType = dlFileEntry.getMimeType();
            }
            if (Validator.isNull((String)title) && Validator.isNull((String)(title = sourceFileName))) {
                title = dlFileEntry.getTitle();
            }
            String fileName = DLUtil.getSanitizedFileName((String)title, (String)extension);
            if (Validator.isNotNull((String)sourceFileName)) {
                fileName = DLUtil.getSanitizedFileName((String)FileUtil.stripExtension((String)sourceFileName), (String)extension);
            }
            Date date = new Date();
            this.validateFile(dlFileEntry.getGroupId(), dlFileEntry.getFolderId(), dlFileEntry.getFileEntryId(), fileName, extension, title);
            String version = dlFileVersion.getVersion();
            if (size == 0L) {
                size = dlFileVersion.getSize();
            }
            this.updateFileVersion(user, dlFileVersion, sourceFileName, fileName, extension, mimeType, title, description, changeLog, extraSettings, fileEntryTypeId, ddmFormValuesMap, version, size, expirationDate, reviewDate, dlFileVersion.getStatus(), serviceContext.getModifiedDate(date), serviceContext);
            if (!checkedOut && dlFileEntry.getFolderId() != 0L) {
                this._dlFolderLocalService.updateLastPostDate(dlFileEntry.getFolderId(), serviceContext.getModifiedDate(date));
            }
            if (file != null || inputStream != null) {
                DLStoreUtil.deleteFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)version);
                if (file != null) {
                    DLStoreUtil.updateFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)dlFileEntry.getExtension(), (boolean)false, (String)version, (String)sourceFileName, (File)file);
                } else {
                    DLStoreUtil.updateFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)dlFileEntry.getExtension(), (boolean)false, (String)version, (String)sourceFileName, (InputStream)inputStream);
                }
            }
            if (autoCheckIn) {
                this.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
            }
        }
        catch (PortalException | SystemException exception1) {
            if (autoCheckIn) {
                try {
                    this.cancelCheckOut(userId, fileEntryId);
                }
                catch (Exception exception2) {
                    _log.error((Object)exception2, (Throwable)exception2);
                }
            }
            throw exception1;
        }
        finally {
            if (!autoCheckIn && !checkedOut) {
                this.unlockFileEntry(fileEntryId);
            }
        }
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    protected DLFileVersion updateFileVersion(User user, DLFileVersion dlFileVersion, String sourceFileName, String fileName, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, String version, long size, Date expirationDate, Date reviewDate, int status, Date statusDate, ServiceContext serviceContext) throws PortalException {
        dlFileVersion.setUserId(user.getUserId());
        dlFileVersion.setUserName(user.getFullName());
        dlFileVersion.setModifiedDate(statusDate);
        dlFileVersion.setFileName(fileName);
        if (Validator.isNotNull((String)sourceFileName)) {
            dlFileVersion.setExtension(extension);
            dlFileVersion.setMimeType(mimeType);
        }
        dlFileVersion.setTitle(title);
        dlFileVersion.setDescription(description);
        dlFileVersion.setChangeLog(changeLog);
        dlFileVersion.setExtraSettings(extraSettings);
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        dlFileVersion.setVersion(version);
        dlFileVersion.setSize(size);
        dlFileVersion.setSize(size);
        dlFileVersion.setExpirationDate(expirationDate);
        dlFileVersion.setReviewDate(reviewDate);
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(statusDate);
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)dlFileVersion.getExpandoBridge(), (ExpandoBridge)dlFileVersion.getExpandoBridge(), (ServiceContext)serviceContext);
        dlFileVersion = (DLFileVersion)this._dlFileVersionPersistence.update((BaseModel)dlFileVersion);
        if (fileEntryTypeId > 0L && ddmFormValuesMap != null) {
            this._dlFileEntryMetadataLocalService.updateFileEntryMetadata(fileEntryTypeId, dlFileVersion.getFileEntryId(), dlFileVersion.getFileVersionId(), ddmFormValuesMap, serviceContext);
        }
        return dlFileVersion;
    }

    protected void validateFile(long groupId, long folderId, long fileEntryId, String fileName, String extension, String title) throws PortalException {
        DLValidatorUtil.validateFileName((String)fileName);
        this.validateFileExtension(fileName, extension);
        this.validateFile(groupId, folderId, fileEntryId, fileName, title);
    }

    protected void validateFileEntryTypeId(long[] groupIds, long folderId, long fileEntryTypeId) throws PortalException {
        List dlFileEntryTypes = this._dlFileEntryTypeLocalService.getFolderFileEntryTypes(groupIds, folderId, true);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (dlFileEntryType.getFileEntryTypeId() != fileEntryTypeId) continue;
            return;
        }
        throw new InvalidFileEntryTypeException(StringBundler.concat((Object[])new Object[]{"Invalid file entry type ", fileEntryTypeId, " for folder ", folderId}));
    }

    protected void validateFileExtension(String fileName, String extension) throws PortalException {
        if (!DLAppHelperThreadLocal.isEnabled()) {
            return;
        }
        DLValidatorUtil.validateFileExtension((String)fileName);
        if (Validator.isNull((String)extension)) {
            return;
        }
        int maxLength = ModelHintsUtil.getMaxLength((String)DLFileEntry.class.getName(), (String)"extension");
        if (extension.length() > maxLength) {
            throw new FileExtensionException(StringBundler.concat((Object[])new Object[]{extension, " of file ", fileName, " exceeds max length of ", maxLength}));
        }
    }

    private String _buildEntryURL(DLFileVersion fileVersion) throws PortalException {
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        String entryURL = PortalUtil.getControlPanelFullURL((long)fileVersion.getGroupId(), (String)portletId, null);
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        entryURL = HttpUtil.addParameter((String)entryURL, (String)(namespace + "mvcRenderCommandName"), (String)"/document_library/edit_file_entry");
        entryURL = HttpUtil.addParameter((String)entryURL, (String)(namespace + "redirect"), (String)HttpUtil.addParameter((String)PortalUtil.getControlPanelFullURL((long)fileVersion.getGroupId(), (String)portletId, null), (String)(namespace + "folderId"), (long)fileVersion.getFolderId()));
        entryURL = HttpUtil.addParameter((String)entryURL, (String)(namespace + "groupId"), (long)fileVersion.getGroupId());
        entryURL = HttpUtil.addParameter((String)entryURL, (String)(namespace + "folderId"), (long)fileVersion.getFolderId());
        entryURL = HttpUtil.addParameter((String)entryURL, (String)(namespace + "fileEntryId"), (String)String.valueOf(fileVersion.getFileEntryId()));
        return entryURL;
    }

    private void _checkFileEntriesByExpirationDate(Date expirationDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring file entries with expiration date previous to " + expirationDate));
        }
        this._companyLocalService.forEachCompanyId(companyId -> this._expireFileEntriesByCompanyId((long)companyId, expirationDate, Collections.emptyMap(), new ServiceContext()));
    }

    private void _checkFileEntriesByReviewDate(Date reviewDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending review notification for file entries with review ", "date between ", this._previousCheckDate, " and ", reviewDate}));
        }
        List<DLFileEntry> fileEntries = this._getFileEntriesByReviewDate(reviewDate, this._previousCheckDate);
        for (DLFileEntry fileEntry : fileEntries) {
            if (fileEntry.isInTrash()) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Sending review notification for file entry " + fileEntry.getFileEntryId()));
            }
            DLFileVersion latestFileVersion = this._dlFileVersionLocalService.fetchLatestFileVersion(fileEntry.getFileEntryId(), false);
            this._notifySubscribers(fileEntry.getUserId(), 1, this._buildEntryURL(latestFileVersion), latestFileVersion, new ServiceContext());
            this._notifyOwner(fileEntry.getUserId(), 1, this._buildEntryURL(latestFileVersion), latestFileVersion, new ServiceContext());
        }
    }

    private DLFileEntry _checkOutDLFileEntryModel(long userId, long fileEntryId, long fileEntryTypeId, ServiceContext serviceContext) throws PortalException {
        return this._checkOutDLFileEntryModel(userId, fileEntryId, fileEntryTypeId, "", DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    private DLFileEntry _checkOutDLFileEntryModel(long userId, long fileEntryId, long fileEntryTypeId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        String version;
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean hasLock = this.hasFileEntryLock(userId, fileEntryId, dlFileEntry.getFolderId());
        if (!hasLock) {
            if (expirationTime <= 0L || expirationTime > DLFileEntryImpl.LOCK_EXPIRATION_TIME) {
                expirationTime = DLFileEntryImpl.LOCK_EXPIRATION_TIME;
            }
            LockManagerUtil.lock((long)userId, (String)DLFileEntry.class.getName(), (long)fileEntryId, (String)owner, (boolean)false, (long)expirationTime);
        }
        User user = this._userPersistence.findByPrimaryKey(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        serviceContext.setUserId(userId);
        boolean manualCheckinRequired = GetterUtil.getBoolean((Object)serviceContext.getAttribute("manualCheckInRequired"));
        if (dlFileEntry.isManualCheckInRequired() ^ manualCheckinRequired) {
            dlFileEntry.setManualCheckInRequired(manualCheckinRequired);
            dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        }
        if (!(version = dlFileVersion.getVersion()).equals("PWC")) {
            DLFileVersion oldDLFileVersion = dlFileVersion;
            long oldDLFileVersionId = dlFileVersion.getFileVersionId();
            long existingDLFileVersionId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"existingDLFileVersionId");
            if (existingDLFileVersionId > 0L) {
                DLFileVersion existingDLFileVersion = this._dlFileVersionPersistence.findByPrimaryKey(existingDLFileVersionId);
                dlFileVersion = this.updateFileVersion(user, existingDLFileVersion, null, existingDLFileVersion.getFileName(), existingDLFileVersion.getExtension(), existingDLFileVersion.getMimeType(), existingDLFileVersion.getTitle(), existingDLFileVersion.getDescription(), existingDLFileVersion.getChangeLog(), existingDLFileVersion.getExtraSettings(), existingDLFileVersion.getFileEntryTypeId(), null, "PWC", existingDLFileVersion.getSize(), existingDLFileVersion.getExpirationDate(), existingDLFileVersion.getReviewDate(), 2, serviceContext.getModifiedDate(null), serviceContext);
            } else {
                dlFileVersion = this.addFileVersion(user, dlFileEntry, oldDLFileVersion.getFileName(), oldDLFileVersion.getExtension(), oldDLFileVersion.getMimeType(), oldDLFileVersion.getTitle(), oldDLFileVersion.getDescription(), oldDLFileVersion.getChangeLog(), oldDLFileVersion.getExtraSettings(), oldDLFileVersion.getFileEntryTypeId(), null, "PWC", oldDLFileVersion.getSize(), oldDLFileVersion.getExpirationDate(), oldDLFileVersion.getReviewDate(), 2, serviceContext);
                this.copyExpandoRowModifiedDate(dlFileEntry.getCompanyId(), oldDLFileVersionId, dlFileVersion.getFileVersionId());
            }
            Serializable validateDDMFormValues = serviceContext.getAttribute("validateDDMFormValues");
            serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
            if (fileEntryTypeId == oldDLFileVersion.getFileEntryTypeId()) {
                this.copyFileEntryMetadata(dlFileEntry.getCompanyId(), fileEntryTypeId, fileEntryId, oldDLFileVersionId, dlFileVersion.getFileVersionId(), serviceContext);
            }
            serviceContext.setAttribute("validateDDMFormValues", validateDDMFormValues);
        }
        return dlFileEntry;
    }

    private DLVersionNumberIncrease _computeDLVersionNumberIncrease(DLVersionNumberIncrease dlVersionNumberIncrease, DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion, int workflowAction) {
        if (workflowAction == 2) {
            return DLVersionNumberIncrease.MINOR;
        }
        VersioningStrategy versioningStrategy = _versioningStrategy;
        if (versioningStrategy == null) {
            if (dlVersionNumberIncrease == null || dlVersionNumberIncrease == DLVersionNumberIncrease.AUTOMATIC) {
                return DLVersionNumberIncrease.NONE;
            }
            return dlVersionNumberIncrease;
        }
        if (versioningStrategy.isOverridable() && dlVersionNumberIncrease != null && dlVersionNumberIncrease != DLVersionNumberIncrease.AUTOMATIC) {
            return dlVersionNumberIncrease;
        }
        return versioningStrategy.computeDLVersionNumberIncrease(previousDLFileVersion, nextDLFileVersion);
    }

    private void _expireFileEntriesByCompanyId(long companyId, Date expirationDate, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        long userId = this._getActiveCompanyAdminUserId(companyId);
        List<DLFileEntry> fileEntries = this._getFileEntriesByCompanyIdAndExpirationDate(companyId, expirationDate);
        for (DLFileEntry fileEntry : fileEntries) {
            DLFileVersion latestFileVersion = this._dlFileVersionLocalService.fetchLatestFileVersion(fileEntry.getFileEntryId(), false);
            if (latestFileVersion.isExpired()) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Expiring file entry ", fileEntry.getFileEntryId(), " with expiration date ", fileEntry.getExpirationDate()}));
            }
            this.updateStatus(userId, fileEntry, latestFileVersion, 3, serviceContext, workflowContext);
            this._notifySubscribers(userId, 0, this._buildEntryURL(latestFileVersion), latestFileVersion, new ServiceContext());
            this._notifyOwner(userId, 0, this._buildEntryURL(latestFileVersion), latestFileVersion, new ServiceContext());
        }
    }

    private long _getActiveCompanyAdminUserId(long companyId) throws PortalException {
        Role role = this._roleLocalService.getRole(companyId, "Administrator");
        Long userId = this._getActiveUser(this._userLocalService.getRoleUserIds(role.getRoleId()));
        if (userId != null) {
            return userId;
        }
        List groups = this._groupLocalService.getRoleGroups(role.getRoleId());
        for (Group group : groups) {
            if (!(group.isDepot() || group.isRegularSite() ? (userId = this._getActiveUser(this._groupLocalService.getUserPrimaryKeys(group.getGroupId()))) != null : (group.isOrganization() ? (userId = this._getActiveUser(this._organizationLocalService.getUserPrimaryKeys(group.getClassPK()))) != null : group.isUserGroup() && (userId = this._getActiveUser(this._userGroupLocalService.getUserPrimaryKeys(group.getClassPK()))) != null))) continue;
            return userId;
        }
        throw new PortalException("Unable to find an administrator user in company " + companyId);
    }

    private Long _getActiveUser(long[] userIds) {
        if (!ArrayUtil.isEmpty((long[])userIds)) {
            for (long userId : userIds) {
                User user = this._userLocalService.fetchUser(userId);
                if (user == null || !user.isActive()) continue;
                return userId;
            }
        }
        return null;
    }

    private List<DLFileEntry> _getFileEntriesByCompanyIdAndExpirationDate(long companyId, Date expirationDate) {
        return (List)this.dlFileEntryPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)DLFileEntryTable.INSTANCE).from((Table)DLFileEntryTable.INSTANCE).where(DLFileEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)DLFileEntryTable.INSTANCE.expirationDate.lte((Object)expirationDate))));
    }

    private List<DLFileEntry> _getFileEntriesByReviewDate(Date reviewDateLT, Date reviewDateGT) {
        return (List)this.dlFileEntryPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)DLFileEntryTable.INSTANCE).from((Table)DLFileEntryTable.INSTANCE).where(DLFileEntryTable.INSTANCE.reviewDate.gte((Object)reviewDateGT).and((Expression)DLFileEntryTable.INSTANCE.reviewDate.lte((Object)reviewDateLT))));
    }

    private boolean _isValidFileVersionNumber(String version) {
        if (Validator.isNull((String)version)) {
            return false;
        }
        if (version.equals("PWC")) {
            return true;
        }
        Matcher matcher = _fileVersionPattern.matcher(version);
        return matcher.matches();
    }

    private void _notifyOwner(long userId, int emailType, String entryURL, DLFileVersion fileVersion, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)entryURL)) {
            return;
        }
        User user = this._userLocalService.fetchUser(fileVersion.getUserId());
        if (user == null || !user.isActive()) {
            user = this._userLocalService.fetchUser(userId);
        }
        DLGroupServiceSettings dlGroupServiceSettings = DLGroupServiceSettings.getInstance(fileVersion.getGroupId());
        if (emailType == 1 && !dlGroupServiceSettings.isEmailFileEntryReviewEnabled()) {
            return;
        }
        if (emailType == 0 && !dlGroupServiceSettings.isEmailFileEntryExpiredEnabled()) {
            return;
        }
        DLFileEntry fileEntry = fileVersion.getFileEntry();
        DLFolder folder = null;
        long folderId = fileEntry.getFolderId();
        if (folderId != 0L) {
            folder = fileEntry.getFolder();
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        String fromName = dlGroupServiceSettings.getEmailFromName();
        String fromAddress = dlGroupServiceSettings.getEmailFromAddress();
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        subscriptionSender.setClassName(DLFileEntryConstants.getClassName());
        subscriptionSender.setClassPK(fileVersion.getFileEntryId());
        subscriptionSender.setCompanyId(fileVersion.getCompanyId());
        if (folder != null) {
            subscriptionSender.setContextAttribute("[$FOLDER_NAME$]", (Object)folder.getName(), true);
        } else {
            subscriptionSender.setLocalizedContextAttribute("[$FOLDER_NAME$]", new EscapableLocalizableFunction(locale -> LanguageUtil.get((Locale)locale, (String)"home")));
        }
        String entryTitle = fileVersion.getTitle();
        subscriptionSender.setContextAttributes(new Object[]{"[$DOCUMENT_STATUS_BY_USER_NAME$]", fileVersion.getStatusByUserName(), "[$DOCUMENT_TITLE$]", entryTitle, "[$DOCUMENT_URL$]", entryURL});
        subscriptionSender.setContextCreatorUserPrefix("DOCUMENT");
        subscriptionSender.setCreatorUserId(fileVersion.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(entryURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        int notificationType = 0;
        if (emailType == 1) {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryReviewSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryReviewBody();
            notificationType = 2;
        } else if (emailType == 0) {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryExpiredSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryExpiredBody();
            notificationType = 3;
        } else if (serviceContext.isCommandUpdate()) {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryUpdatedSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryUpdatedBody();
            notificationType = 1;
        } else {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryAddedSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryAddedBody();
        }
        subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getDLFileEntryType(fileEntry.getFileEntryTypeId());
        subscriptionSender.setLocalizedContextAttribute("[$DOCUMENT_TYPE$]", new EscapableLocalizableFunction(arg_0 -> ((DLFileEntryType)dlFileEntryType).getName(arg_0)));
        subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        subscriptionSender.setMailId("file_entry", new Object[]{fileVersion.getFileEntryId()});
        subscriptionSender.setNotificationType(notificationType);
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(fileVersion.getGroupId());
        subscriptionSender.setSendToCurrentUser(true);
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    private void _notifySubscribers(long userId, int emailType, String entryURL, DLFileVersion fileVersion, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)entryURL)) {
            return;
        }
        User user = this._userLocalService.fetchUser(fileVersion.getUserId());
        if (user == null) {
            return;
        }
        DLGroupServiceSettings dlGroupServiceSettings = DLGroupServiceSettings.getInstance(fileVersion.getGroupId());
        if (Objects.equals(emailType, 1) && !dlGroupServiceSettings.isEmailFileEntryReviewEnabled()) {
            return;
        }
        if (Objects.equals(emailType, 0) && !dlGroupServiceSettings.isEmailFileEntryExpiredEnabled()) {
            return;
        }
        String entryTitle = fileVersion.getTitle();
        String fromName = dlGroupServiceSettings.getEmailFromName();
        String fromAddress = dlGroupServiceSettings.getEmailFromAddress();
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        int notificationType = 0;
        if (Objects.equals(emailType, 1)) {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryReviewSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryReviewBody();
            notificationType = 2;
        } else if (Objects.equals(emailType, 0)) {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryExpiredSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryExpiredBody();
            notificationType = 3;
        } else if (serviceContext.isCommandUpdate()) {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryUpdatedSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryUpdatedBody();
            notificationType = 1;
        } else {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryAddedSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryAddedBody();
        }
        DLFileEntry fileEntry = fileVersion.getFileEntry();
        DLFolder folder = null;
        long folderId = fileEntry.getFolderId();
        if (folderId != 0L) {
            folder = fileEntry.getFolder();
        }
        GroupSubscriptionCheckSubscriptionSender subscriptionSender = new GroupSubscriptionCheckSubscriptionSender("com.liferay.document.library");
        subscriptionSender.setClassName(DLFileEntryConstants.getClassName());
        subscriptionSender.setClassPK(fileVersion.getFileEntryId());
        subscriptionSender.setCompanyId(fileVersion.getCompanyId());
        if (folder != null) {
            subscriptionSender.setContextAttribute("[$FOLDER_NAME$]", (Object)folder.getName(), true);
        } else {
            subscriptionSender.setLocalizedContextAttribute("[$FOLDER_NAME$]", new EscapableLocalizableFunction(locale -> LanguageUtil.get((Locale)locale, (String)"home")));
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$DOCUMENT_STATUS_BY_USER_NAME$]", fileVersion.getStatusByUserName(), "[$DOCUMENT_TITLE$]", entryTitle, "[$DOCUMENT_URL$]", entryURL});
        subscriptionSender.setContextCreatorUserPrefix("DOCUMENT");
        subscriptionSender.setCreatorUserId(fileVersion.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(entryURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getDLFileEntryType(fileEntry.getFileEntryTypeId());
        subscriptionSender.setLocalizedContextAttribute("[$DOCUMENT_TYPE$]", new EscapableLocalizableFunction(arg_0 -> ((DLFileEntryType)dlFileEntryType).getName(arg_0)));
        subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        subscriptionSender.setMailId("file_entry", new Object[]{fileVersion.getFileEntryId()});
        subscriptionSender.setNotificationType(notificationType);
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(fileVersion.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addPersistedSubscribers(DLFolder.class.getName(), fileVersion.getGroupId());
        if (folder != null) {
            subscriptionSender.addPersistedSubscribers(DLFolder.class.getName(), folder.getFolderId());
            for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                subscriptionSender.addPersistedSubscribers(DLFolder.class.getName(), ancestorFolderId.longValue());
            }
        }
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), fileVersion.getGroupId());
        } else {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId());
        }
        subscriptionSender.addPersistedSubscribers(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        subscriptionSender.setScopeGroupId(fileVersion.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.flushNotificationsAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _overwritePreviousFileVersion(User user, DLFileEntry dlFileEntry, DLFileVersion latestDLFileVersion, DLFileVersion lastDLFileVersion, ServiceContext serviceContext) throws PortalException {
        dlFileEntry.setModifiedDate(latestDLFileVersion.getModifiedDate());
        dlFileEntry.setFileName(latestDLFileVersion.getFileName());
        dlFileEntry.setExtension(latestDLFileVersion.getExtension());
        dlFileEntry.setMimeType(latestDLFileVersion.getMimeType());
        dlFileEntry.setTitle(latestDLFileVersion.getTitle());
        dlFileEntry.setDescription(latestDLFileVersion.getDescription());
        dlFileEntry.setExtraSettings(latestDLFileVersion.getExtraSettings());
        dlFileEntry.setFileEntryTypeId(latestDLFileVersion.getFileEntryTypeId());
        dlFileEntry.setSize(latestDLFileVersion.getSize());
        dlFileEntry.setExpirationDate(lastDLFileVersion.getExpirationDate());
        dlFileEntry.setReviewDate(lastDLFileVersion.getReviewDate());
        dlFileEntry = (DLFileEntry)this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        lastDLFileVersion.setUserId(latestDLFileVersion.getUserId());
        lastDLFileVersion.setUserName(latestDLFileVersion.getUserName());
        lastDLFileVersion.setModifiedDate(latestDLFileVersion.getModifiedDate());
        lastDLFileVersion.setFileName(latestDLFileVersion.getFileName());
        lastDLFileVersion.setExtension(latestDLFileVersion.getExtension());
        lastDLFileVersion.setMimeType(latestDLFileVersion.getMimeType());
        lastDLFileVersion.setTitle(latestDLFileVersion.getTitle());
        lastDLFileVersion.setDescription(latestDLFileVersion.getDescription());
        lastDLFileVersion.setChangeLog(latestDLFileVersion.getChangeLog());
        lastDLFileVersion.setExtraSettings(latestDLFileVersion.getExtraSettings());
        lastDLFileVersion.setFileEntryTypeId(latestDLFileVersion.getFileEntryTypeId());
        lastDLFileVersion.setSize(latestDLFileVersion.getSize());
        lastDLFileVersion.setExpirationDate(latestDLFileVersion.getExpirationDate());
        lastDLFileVersion.setReviewDate(latestDLFileVersion.getReviewDate());
        ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)lastDLFileVersion.getExpandoBridge(), (ExpandoBridge)latestDLFileVersion.getExpandoBridge());
        lastDLFileVersion = (DLFileVersion)this._dlFileVersionPersistence.update((BaseModel)lastDLFileVersion);
        Serializable validateDDMFormValues = serviceContext.getAttribute("validateDDMFormValues");
        try {
            serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
            this.copyFileEntryMetadata(dlFileEntry.getCompanyId(), dlFileEntry.getFileEntryTypeId(), dlFileEntry.getFileEntryId(), latestDLFileVersion.getFileVersionId(), lastDLFileVersion.getFileVersionId(), serviceContext);
        }
        finally {
            serviceContext.setAttribute("validateDDMFormValues", validateDDMFormValues);
        }
        AssetEntry latestDLFileVersionAssetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), latestDLFileVersion.getPrimaryKey());
        if (latestDLFileVersionAssetEntry != null) {
            this._assetEntryLocalService.updateEntry(lastDLFileVersion.getUserId(), lastDLFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), lastDLFileVersion.getPrimaryKey(), latestDLFileVersionAssetEntry.getCategoryIds(), latestDLFileVersionAssetEntry.getTagNames());
        }
        DLStoreUtil.deleteFile((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)lastDLFileVersion.getVersion());
        DLStoreUtil.copyFileVersion((long)user.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)"PWC", (String)lastDLFileVersion.getVersion());
        this.removeFileVersion(dlFileEntry, latestDLFileVersion);
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.fetchByG_ERC(groupId, externalReferenceCode);
        if (dlFileEntry != null) {
            throw new DuplicateFileEntryExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate file entry external reference code ", externalReferenceCode, " in group ", groupId}));
        }
    }

    private void _validateFolder(long groupId, long folderId, String title) throws PortalException {
        DLFolder parentDLFolder;
        if (folderId != 0L && groupId != (parentDLFolder = this._dlFolderPersistence.findByPrimaryKey(folderId)).getGroupId()) {
            throw new NoSuchFolderException();
        }
        DLFolder dlFolder = this._dlFolderPersistence.fetchByG_P_N(groupId, folderId, title);
        if (dlFolder != null) {
            throw new DuplicateFolderNameException("A folder already exists with name " + title);
        }
    }
}

