/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryTable;
import com.liferay.document.library.kernel.model.DLFileVersionTable;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryFinder;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.LimitStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.expression.TableStar;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.view.count.ViewCountManagerUtil;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.persistence.impl.DLFileEntryFinderBaseImpl;
import com.liferay.portlet.documentlibrary.service.persistence.impl.DLFolderFinderImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DLFileEntryFinderImpl
extends DLFileEntryFinderBaseImpl
implements DLFileEntryFinder {
    public static final String COUNT_BY_EXTRA_SETTINGS = DLFileEntryFinder.class.getName() + ".countByExtraSettings";
    public static final String COUNT_BY_G_M_R = DLFileEntryFinder.class.getName() + ".countByG_M_R";
    public static final String COUNT_BY_G_F_S = DLFileEntryFinder.class.getName() + ".countByG_F_S";
    public static final String FIND_BY_COMPANY_ID = DLFileEntryFinder.class.getName() + ".findByCompanyId";
    public static final String FIND_BY_DDM_STRUCTURE_IDS = DLFileEntryFinder.class.getName() + ".findByDDMStructureIds";
    public static final String FIND_BY_NO_ASSETS = DLFileEntryFinder.class.getName() + ".findByNoAssets";
    public static final String FIND_BY_EXTRA_SETTINGS = DLFileEntryFinder.class.getName() + ".findByExtraSettings";
    public static final String FIND_BY_ORPHANED_FILE_ENTRIES = DLFileEntryFinder.class.getName() + ".findByOrphanedFileEntries";
    public static final String FIND_BY_C_T = DLFileEntryFinder.class.getName() + ".findByC_T";

    public int countByExtraSettings() {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_EXTRA_SETTINGS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_F(groupId, folderIds, queryDefinition, false);
    }

    public int countByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public int countByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    public int countByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    public int filterCountByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_F(groupId, folderIds, queryDefinition, true);
    }

    public int filterCountByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, true);
    }

    public int filterCountByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public int filterCountByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public List<DLFileEntry> findByCompanyId(long companyId, QueryDefinition<DLFileEntry> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_COMPANY_ID, queryDefinition, (String)"DLFileVersion");
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(queryDefinition.getStatus());
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByDDMStructureIds(long groupId, long[] ddmStructureIds, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            if (ddmStructureIds == null || ddmStructureIds.length <= 0) {
                List<DLFileEntry> list = Collections.emptyList();
                return list;
            }
            String sql = CustomSQLUtil.get((String)FIND_BY_DDM_STRUCTURE_IDS);
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(DLFileEntry.groupId = ?) AND");
            }
            sql = StringUtil.replace((String)sql, (String)"[$DDM_STRUCTURE_ID$]", (String)this.getDDMStructureIds(ddmStructureIds));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            queryPos.add(ddmStructureIds);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByDDMStructureIds(long[] ddmStructureIds, int start, int end) {
        return this.findByDDMStructureIds(0L, ddmStructureIds, start, end);
    }

    public List<DLFileEntry> findByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)DLFileEntryConstants.getClassName()));
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByExtraSettings(int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_EXTRA_SETTINGS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("fileEntryId", Type.LONG);
            List fileEntryIds = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<DLFileEntry> dlFileEntries = new ArrayList<DLFileEntry>(fileEntryIds.size());
            Object object = fileEntryIds.iterator();
            while (object.hasNext()) {
                long fileEntryId = (Long)object.next();
                dlFileEntries.add(this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId));
            }
            object = Collections.unmodifiableList(dlFileEntries);
            return object;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByOrphanedFileEntries() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORPHANED_FILE_ENTRIES);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByC_T(long classNameId, String treePath) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_T);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(CustomSQLUtil.keywords((String)treePath, (WildcardMode)WildcardMode.TRAILING)[0]);
            queryPos.add(classNameId);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_F(long groupId, long userId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_R_F(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    protected int doCountByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            List<Long> repositoryIds = Collections.emptyList();
            String sql = this.getFileEntriesSQL(COUNT_BY_G_F_S, groupId, repositoryIds, folderIds, null, queryDefinition, inlineSQLHelper);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(queryDefinition.getStatus());
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        FromStep fromStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.count((Expression)DLFileEntryTable.INSTANCE.fileEntryId).as("COUNT_VALUE")});
        JoinStep joinStep = this._getJoinStep(fromStep, folderIds, groupId, inlineSQLHelper, mimeTypes, queryDefinition, repositoryIds, userId);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)joinStep);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<DLFileEntry> doFindByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        FromStep fromStep = DSLQueryFactoryUtil.select((Table)DLFileEntryTable.INSTANCE);
        Table viewCountEntryTable = ViewCountManagerUtil.getViewCountEntryTable();
        Column viewCountColumn = viewCountEntryTable.getColumn("viewCount");
        OrderByComparator orderByComparator = queryDefinition.getOrderByComparator();
        if (this._isOrderByReadCount((OrderByComparator<DLFileEntry>)orderByComparator)) {
            fromStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{new TableStar((Table)DLFileEntryTable.INSTANCE), DSLFunctionFactoryUtil.caseWhenThen((Predicate)viewCountColumn.isNull(), (Expression)DSLFunctionFactoryUtil.castText((Expression)new Scalar((Object)0))).elseEnd(DSLFunctionFactoryUtil.castText((Expression)new Scalar((Object)viewCountColumn.toString()))).as("viewCount")});
        }
        JoinStep joinStep = this._getJoinStep(fromStep, folderIds, groupId, inlineSQLHelper, mimeTypes, queryDefinition, repositoryIds, userId);
        LimitStep dslQuery = null;
        if (orderByComparator == null) {
            dslQuery = joinStep.orderBy(new OrderByExpression[]{DLFileEntryTable.INSTANCE.fileEntryId.ascending()});
        } else if (this._isOrderByReadCount((OrderByComparator<DLFileEntry>)orderByComparator)) {
            OrderByExpression orderByExpression = viewCountColumn.descending();
            if (orderByComparator.isAscending()) {
                orderByExpression = viewCountColumn.ascending();
            }
            dslQuery = joinStep.leftJoinOn(viewCountEntryTable, viewCountEntryTable.getColumn("classNameId", Long.class).eq((Object)ClassNameLocalServiceUtil.getClassNameId(DLFileEntry.class)).and((Expression)viewCountEntryTable.getColumn("classPK", Long.class).eq((Expression)DLFileEntryTable.INSTANCE.fileEntryId)).and((Expression)viewCountEntryTable.getColumn("companyId", Long.class).eq((Expression)DLFileEntryTable.INSTANCE.companyId))).orderBy(new OrderByExpression[]{orderByExpression});
        } else {
            dslQuery = joinStep.orderBy((Table)DLFileEntryTable.INSTANCE, (OrderByInfo)orderByComparator);
        }
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)dslQuery);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getDDMStructureIds(long[] ddmStructureIds) {
        StringBundler sb = new StringBundler(ddmStructureIds.length * 2 - 1 + 2);
        sb.append("(");
        for (int i = 0; i < ddmStructureIds.length; ++i) {
            sb.append("DDMStructureLink.structureId = ?");
            if (i + 1 == ddmStructureIds.length) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getFileEntriesSQL(String id, long groupId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        String tableName = "DLFileVersion";
        String sql = CustomSQLUtil.get((String)id, queryDefinition, (String)tableName);
        if (queryDefinition.getStatus() == -1) {
            sql = StringUtil.removeSubstring((String)sql, (String)"[$JOIN$]");
            tableName = "DLFileEntry";
        } else {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)CustomSQLUtil.get((String)DLFolderFinderImpl.JOIN_FE_BY_DL_FILE_VERSION));
        }
        if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled()) {
            sql = queryDefinition.getStatus() == -1 ? InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileEntry.fileEntryId", (long)groupId) : InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileVersion.fileEntryId", (long)groupId);
        }
        if (ListUtil.isNotEmpty(repositoryIds) || ListUtil.isNotEmpty(folderIds) || ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            StringBundler sb = new StringBundler(12);
            if (ListUtil.isNotEmpty(repositoryIds)) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getRepositoryIds(repositoryIds, tableName));
                sb.append(")");
            }
            if (ListUtil.isNotEmpty(folderIds)) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getFolderIds(folderIds, tableName));
                sb.append(")");
            }
            if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getMimeTypes(mimeTypes, tableName));
                sb.append(")");
            }
            return StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)sb.toString());
        }
        return StringUtil.removeSubstring((String)sql, (String)"[$FOLDER_ID$]");
    }

    protected String getFolderIds(List<Long> folderIds, String tableName) {
        if (folderIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(folderIds.size() * 3 + 1);
        sb.append("(");
        for (int i = 0; i < folderIds.size(); ++i) {
            sb.append(tableName);
            sb.append(".folderId = ");
            sb.append((Object)folderIds.get(i));
            if (i + 1 == folderIds.size()) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getMimeTypes(String[] mimeTypes, String tableName) {
        if (mimeTypes.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(mimeTypes.length * 3 - 1);
        for (int i = 0; i < mimeTypes.length; ++i) {
            sb.append(tableName);
            sb.append(".mimeType = ?");
            if (i + 1 == mimeTypes.length) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected String getRepositoryIds(List<Long> repositoryIds, String tableName) {
        if (repositoryIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(repositoryIds.size() * 3 + 1);
        sb.append("(");
        for (int i = 0; i < repositoryIds.size(); ++i) {
            sb.append(tableName);
            sb.append(".repositoryId = ? ");
            if (i + 1 == repositoryIds.size()) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    private JoinStep _getJoinStep(FromStep fromStep, List<Long> folderIds, long groupId, boolean inlineSQLHelper, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition, List<Long> repositoryIds, long userId) {
        int i;
        JoinStep joinStep = DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{DLFileEntryTable.INSTANCE.fileEntryId}).from((Table)DLFileEntryTable.INSTANCE);
        if (userId > 0L || queryDefinition.getStatus() != -1) {
            joinStep = joinStep.innerJoinON((Table)DLFileVersionTable.INSTANCE, DLFileEntryTable.INSTANCE.fileEntryId.eq((Expression)DLFileVersionTable.INSTANCE.fileEntryId));
        }
        Predicate wherePredicate = DLFileEntryTable.INSTANCE.groupId.eq((Object)groupId);
        if (userId > 0L) {
            wherePredicate = wherePredicate.and((Expression)Predicate.withParentheses((Predicate)DLFileEntryTable.INSTANCE.userId.eq((Object)userId).or((Expression)DLFileVersionTable.INSTANCE.userId.eq((Object)userId))));
        }
        if (queryDefinition.getStatus() != -1) {
            wherePredicate = queryDefinition.isExcludeStatus() ? wherePredicate.and((Expression)DLFileVersionTable.INSTANCE.status.neq((Object)queryDefinition.getStatus())) : wherePredicate.and((Expression)DLFileVersionTable.INSTANCE.status.eq((Object)queryDefinition.getStatus()));
        }
        if (ListUtil.isNotEmpty(repositoryIds)) {
            Predicate repositoriesPredicate = DLFileEntryTable.INSTANCE.repositoryId.eq((Object)repositoryIds.get(0));
            for (i = 1; i < repositoryIds.size(); ++i) {
                repositoriesPredicate = repositoriesPredicate.or((Expression)DLFileEntryTable.INSTANCE.repositoryId.eq((Object)repositoryIds.get(i)));
            }
            wherePredicate = wherePredicate.and((Expression)Predicate.withParentheses((Predicate)repositoriesPredicate));
        }
        if (ListUtil.isNotEmpty(folderIds)) {
            Predicate foldersPredicate = DLFileEntryTable.INSTANCE.folderId.eq((Object)folderIds.get(0));
            for (i = 1; i < folderIds.size(); ++i) {
                foldersPredicate = foldersPredicate.or((Expression)DLFileEntryTable.INSTANCE.folderId.eq((Object)folderIds.get(i)));
            }
            wherePredicate = wherePredicate.and((Expression)Predicate.withParentheses((Predicate)foldersPredicate));
        }
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            Predicate mimeTypesPredicate = DLFileEntryTable.INSTANCE.mimeType.eq((Object)mimeTypes[0]);
            for (i = 1; i < mimeTypes.length; ++i) {
                mimeTypesPredicate = mimeTypesPredicate.or((Expression)DLFileEntryTable.INSTANCE.mimeType.eq((Object)mimeTypes[i]));
            }
            wherePredicate = wherePredicate.and((Expression)Predicate.withParentheses((Predicate)mimeTypesPredicate));
        }
        return fromStep.from(joinStep.where(wherePredicate.and(() -> {
            if (inlineSQLHelper) {
                if (queryDefinition.getStatus() == -1) {
                    return InlineSQLHelperUtil.getPermissionWherePredicate(DLFileEntry.class, (Column)DLFileEntryTable.INSTANCE.fileEntryId, (long[])new long[]{groupId});
                }
                return InlineSQLHelperUtil.getPermissionWherePredicate(DLFileEntry.class, (Column)DLFileVersionTable.INSTANCE.fileEntryId, (long[])new long[]{groupId});
            }
            return null;
        })).as("tempDLFileEntryTable")).innerJoinON((Table)DLFileEntryTable.INSTANCE, ((DLFileEntryTable)DLFileEntryTable.INSTANCE.as((String)"tempDLFileEntryTable")).fileEntryId.eq((Expression)DLFileEntryTable.INSTANCE.fileEntryId));
    }

    private boolean _isOrderByReadCount(OrderByComparator<DLFileEntry> orderByComparator) {
        return orderByComparator != null && (StringUtil.containsIgnoreCase((String)orderByComparator.getOrderBy(), (String)"readCount", (String)",") || StringUtil.containsIgnoreCase((String)orderByComparator.getOrderBy(), (String)"readCount ASC", (String)",") || StringUtil.containsIgnoreCase((String)orderByComparator.getOrderBy(), (String)"readCount DESC", (String)","));
    }
}

