/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.postgresql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.PGConnection;
import org.postgresql.PGStatement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class PostgreSQLJDBCUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getLargeObject(ResultSet resultSet, String name) throws SQLException {
        long id = resultSet.getLong(name);
        if (id == 0L) {
            return null;
        }
        Statement statement = resultSet.getStatement();
        Connection connection = statement.getConnection();
        boolean autoCommit = connection.getAutoCommit();
        if (autoCommit) {
            connection.setAutoCommit(false);
        }
        try {
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            LargeObjectManager largeObjectManager = pgConnection.getLargeObjectAPI();
            LargeObject largeObject = largeObjectManager.open(id, 262144);
            byte[] bytes = new byte[largeObject.size()];
            largeObject.read(bytes, 0, largeObject.size());
            largeObject.close();
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (autoCommit) {
                connection.setAutoCommit(true);
            }
        }
    }

    public static boolean isPGStatement(Statement statement) throws SQLException {
        return statement.isWrapperFor(PGStatement.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLargeObject(PreparedStatement preparedStatement, int index, byte[] bytes) throws SQLException {
        Connection connection = preparedStatement.getConnection();
        boolean autoCommit = connection.getAutoCommit();
        if (autoCommit) {
            connection.setAutoCommit(false);
        }
        try {
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            LargeObjectManager largeObjectManager = pgConnection.getLargeObjectAPI();
            long id = largeObjectManager.createLO(393216);
            LargeObject largeObject = largeObjectManager.open(id, 131072);
            largeObject.write(bytes);
            largeObject.close();
            preparedStatement.setLong(index, id);
        }
        finally {
            if (autoCommit) {
                connection.setAutoCommit(true);
            }
        }
    }
}

