/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.agent.selectors;

import com.liferay.petra.process.ProcessCallable;
import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.agent.selectors.FabricAgentSelector;
import com.liferay.portal.fabric.status.AdvancedOperatingSystemMXBean;
import com.liferay.portal.fabric.status.FabricStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class MinSystemCPULoadFabricAgentSelector
implements FabricAgentSelector {
    private static final Comparator<FabricAgent> _COMPARATOR = new SystemCPULoadComparator();

    @Override
    public Collection<FabricAgent> select(Collection<FabricAgent> fabricAgents, ProcessCallable<?> processCallable) {
        if (fabricAgents.isEmpty()) {
            return fabricAgents;
        }
        return Collections.singleton(Collections.min(fabricAgents, _COMPARATOR));
    }

    private static class SystemCPULoadComparator
    implements Comparator<FabricAgent> {
        private SystemCPULoadComparator() {
        }

        @Override
        public int compare(FabricAgent fabricAgent1, FabricAgent fabricAgent2) {
            FabricStatus fabricStatus1 = fabricAgent1.getFabricStatus();
            AdvancedOperatingSystemMXBean advancedOperatingSystemMXBean1 = fabricStatus1.getAdvancedOperatingSystemMXBean();
            Double systemCpuLoad1 = advancedOperatingSystemMXBean1.getSystemCpuLoad();
            FabricStatus fabricStatus2 = fabricAgent2.getFabricStatus();
            AdvancedOperatingSystemMXBean advancedOperatingSystemMXBean2 = fabricStatus2.getAdvancedOperatingSystemMXBean();
            Double systemCpuLoad2 = advancedOperatingSystemMXBean2.getSystemCpuLoad();
            if (systemCpuLoad1 == null && systemCpuLoad2 == null) {
                return 0;
            }
            if (systemCpuLoad1 == null) {
                return 1;
            }
            if (systemCpuLoad2 == null) {
                return -1;
            }
            return systemCpuLoad1.compareTo(systemCpuLoad2);
        }
    }
}

