/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.PluginPackageNameAndContextComparator;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalPluginPackageRepository {
    private static final Log _log = LogFactoryUtil.getLog(LocalPluginPackageRepository.class);
    private final Map<String, PluginPackage> _pluginPackages = new HashMap<String, PluginPackage>();

    public void addPluginPackage(PluginPackage pluginPackage) {
        if (pluginPackage.getContext() == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Plugin package cannot be registered because it does not have an installation context");
            }
            return;
        }
        this._pluginPackages.remove(pluginPackage.getContext());
        this._pluginPackages.put(pluginPackage.getContext(), pluginPackage);
    }

    public PluginPackage getPluginPackage(String context) {
        return this._pluginPackages.get(context);
    }

    public List<PluginPackage> getSortedPluginPackages() {
        ArrayList<PluginPackage> pluginPackages = new ArrayList<PluginPackage>();
        pluginPackages.addAll(this._pluginPackages.values());
        return ListUtil.sort(pluginPackages, (Comparator)new PluginPackageNameAndContextComparator());
    }

    public void registerPluginPackageInstallation(PluginPackage pluginPackage) {
        PluginPackage previousPluginPackage;
        if (pluginPackage.getContext() != null && (previousPluginPackage = this._pluginPackages.get(pluginPackage.getContext())) == null) {
            this.addPluginPackage(pluginPackage);
        }
    }

    public void removePluginPackage(PluginPackage pluginPackage) throws PortalException {
        this._pluginPackages.remove(pluginPackage.getContext());
    }

    public void unregisterPluginPackageInstallation(String context) {
        this._pluginPackages.remove(context);
    }
}

