/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.session;

import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTracker;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.AuthenticatedUserUUIDStoreUtil;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManager;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.util.PropsValues;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticatedSessionManagerImpl
implements AuthenticatedSessionManager {
    private static final Log _log = LogFactoryUtil.getLog(AuthenticatedSessionManagerImpl.class);

    public long getAuthenticatedUserId(HttpServletRequest httpServletRequest, String login, String password, String authType) throws PortalException {
        User user = this._getAuthenticatedUser(httpServletRequest, login, password, authType);
        return user.getUserId();
    }

    public void login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String login, String password, boolean rememberMe, String authType) throws Exception {
        Boolean httpsInitial;
        String domain;
        String queryString = HttpUtil.getQueryString((HttpServletRequest)(httpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest)));
        if (Validator.isNotNull((String)queryString) && queryString.contains("password=")) {
            int index;
            String passwordParameterName = "password=";
            String portletId = PortalUtil.getPortletId((HttpServletRequest)httpServletRequest);
            if (portletId != null) {
                passwordParameterName = PortalUtil.getPortletNamespace((String)portletId) + passwordParameterName;
            }
            if ((index = queryString.indexOf(passwordParameterName)) == 0 || index > 0 && queryString.charAt(index - 1) == '&') {
                if (_log.isWarnEnabled()) {
                    String referer = httpServletRequest.getHeader("Referer");
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Ignoring login attempt because the password ", "parameter was found for the request with the ", "referer header: ", referer}));
                }
                return;
            }
        }
        CookieKeys.validateSupportCookie((HttpServletRequest)httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
        User user = this._getAuthenticatedUser(httpServletRequest, login, password, authType);
        if (!PropsValues.AUTH_SIMULTANEOUS_LOGINS) {
            this.signOutSimultaneousLogins(user.getUserId());
        }
        if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            httpSession = this.renewSession(httpServletRequest, httpSession);
        }
        if (Validator.isNull((String)(domain = CookieKeys.getDomain((HttpServletRequest)httpServletRequest)))) {
            domain = null;
        }
        String userIdString = String.valueOf(user.getUserId());
        httpSession.setAttribute("j_username", (Object)userIdString);
        if (PropsValues.PORTAL_JAAS_PLAIN_PASSWORD) {
            httpSession.setAttribute("j_password", (Object)password);
        } else {
            httpSession.setAttribute("j_password", (Object)user.getPassword());
        }
        httpSession.setAttribute("j_remoteuser", (Object)userIdString);
        if (PropsValues.SESSION_STORE_PASSWORD) {
            httpSession.setAttribute("USER_PASSWORD", (Object)password);
        }
        Cookie companyIdCookie = new Cookie("COMPANY_ID", String.valueOf(company.getCompanyId()));
        if (domain != null) {
            companyIdCookie.setDomain(domain);
        }
        companyIdCookie.setPath("/");
        Cookie idCookie = new Cookie("ID", Encryptor.encrypt((Key)company.getKeyObj(), (String)userIdString));
        if (domain != null) {
            idCookie.setDomain(domain);
        }
        idCookie.setPath("/");
        int loginMaxAge = PropsValues.COMPANY_SECURITY_AUTO_LOGIN_MAX_AGE;
        if (rememberMe) {
            companyIdCookie.setMaxAge(loginMaxAge);
            idCookie.setMaxAge(loginMaxAge);
        } else {
            companyIdCookie.setMaxAge(-1);
            idCookie.setMaxAge(-1);
        }
        boolean secure = httpServletRequest.isSecure();
        if (!(!secure || PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL) || (httpsInitial = (Boolean)httpSession.getAttribute("HTTPS_INITIAL")) != null && httpsInitial.booleanValue())) {
            secure = false;
        }
        CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)companyIdCookie, (boolean)secure);
        CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)idCookie, (boolean)secure);
        if (rememberMe) {
            Cookie loginCookie = new Cookie("LOGIN", login);
            if (domain != null) {
                loginCookie.setDomain(domain);
            }
            loginCookie.setMaxAge(loginMaxAge);
            loginCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)loginCookie, (boolean)secure);
            Cookie passwordCookie = new Cookie("PASSWORD", Encryptor.encrypt((Key)company.getKeyObj(), (String)password));
            if (domain != null) {
                passwordCookie.setDomain(domain);
            }
            passwordCookie.setMaxAge(loginMaxAge);
            passwordCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)passwordCookie, (boolean)secure);
            Cookie rememberMeCookie = new Cookie("REMEMBER_ME", Boolean.TRUE.toString());
            if (domain != null) {
                rememberMeCookie.setDomain(domain);
            }
            rememberMeCookie.setMaxAge(loginMaxAge);
            rememberMeCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)rememberMeCookie, (boolean)secure);
            Cookie screenNameCookie = new Cookie("SCREEN_NAME", Encryptor.encrypt((Key)company.getKeyObj(), (String)user.getScreenName()));
            if (domain != null) {
                screenNameCookie.setDomain(domain);
            }
            screenNameCookie.setMaxAge(loginMaxAge);
            screenNameCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)screenNameCookie, (boolean)secure);
        }
        if (!PropsValues.AUTH_USER_UUID_STORE_ENABLED) {
            return;
        }
        String userUUID = StringBundler.concat((Object[])new Object[]{userIdString, ".", System.nanoTime()});
        Cookie userUUIDCookie = new Cookie("USER_UUID", Encryptor.encrypt((Key)company.getKeyObj(), (String)userUUID));
        userUUIDCookie.setPath("/");
        httpSession.setAttribute("USER_UUID", (Object)userUUID);
        if (rememberMe) {
            userUUIDCookie.setMaxAge(loginMaxAge);
        } else {
            userUUIDCookie.setMaxAge(-1);
        }
        CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)userUUIDCookie, (boolean)secure);
        AuthenticatedUserUUIDStoreUtil.register((String)userUUID);
    }

    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        block4: {
            HttpSession httpSession = httpServletRequest.getSession();
            EventsProcessorUtil.process("logout.events.pre", PropsValues.LOGOUT_EVENTS_PRE, httpServletRequest, httpServletResponse);
            String domain = CookieKeys.getDomain((HttpServletRequest)httpServletRequest);
            if (Validator.isNull((String)domain)) {
                domain = null;
            }
            boolean rememberMe = GetterUtil.getBoolean((String)CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)"REMEMBER_ME", (boolean)false));
            CookieKeys.deleteCookies((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)domain, (String[])new String[]{"COMPANY_ID", "GUEST_LANGUAGE_ID", "ID", "PASSWORD", "REMEMBER_ME"});
            if (!rememberMe) {
                CookieKeys.deleteCookies((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)domain, (String[])new String[]{"LOGIN"});
            }
            try {
                httpSession.invalidate();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        EventsProcessorUtil.process("logout.events.post", PropsValues.LOGOUT_EVENTS_POST, httpServletRequest, httpServletResponse);
    }

    public HttpSession renewSession(HttpServletRequest httpServletRequest, HttpSession httpSession) throws Exception {
        Object protectedAttributeValue;
        String[] protectedAttributeNames = PropsValues.SESSION_PHISHING_PROTECTED_ATTRIBUTES;
        HashMap<String, Object> protectedAttributes = new HashMap<String, Object>();
        for (String protectedAttributeName : protectedAttributeNames) {
            protectedAttributeValue = httpSession.getAttribute(protectedAttributeName);
            if (protectedAttributeValue == null) continue;
            protectedAttributes.put(protectedAttributeName, protectedAttributeValue);
        }
        httpSession.invalidate();
        httpSession = httpServletRequest.getSession(true);
        for (String protectedAttributeName : protectedAttributeNames) {
            protectedAttributeValue = protectedAttributes.get(protectedAttributeName);
            if (protectedAttributeValue == null) continue;
            httpSession.setAttribute(protectedAttributeName, protectedAttributeValue);
        }
        return httpSession;
    }

    public void signOutSimultaneousLogins(long userId) throws Exception {
        long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)userId);
        Map<String, UserTracker> sessionUsers = LiveUsers.getSessionUsers(companyId);
        ArrayList<UserTracker> userTrackers = new ArrayList<UserTracker>(sessionUsers.values());
        for (UserTracker userTracker : userTrackers) {
            if (userId != userTracker.getUserId()) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
            if (clusterNode != null) {
                jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
            }
            jsonObject.put("command", "signOut").put("companyId", companyId).put("sessionId", userTracker.getSessionId()).put("userId", userId);
            MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
        }
    }

    private User _getAuthenticatedUser(HttpServletRequest httpServletRequest, String login, String password, String authType) throws PortalException {
        String contextPath;
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI.startsWith((contextPath = PortalUtil.getPathContext()).concat("/api/liferay"))) {
            throw new AuthException();
        }
        Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
        HashMap<String, String[]> headerMap = new HashMap<String, String[]>();
        Enumeration enumeration1 = httpServletRequest.getHeaderNames();
        while (enumeration1.hasMoreElements()) {
            String name = (String)enumeration1.nextElement();
            Enumeration enumeration2 = httpServletRequest.getHeaders(name);
            ArrayList<String> headers = new ArrayList<String>();
            while (enumeration2.hasMoreElements()) {
                String value = (String)enumeration2.nextElement();
                headers.add(value);
            }
            headerMap.put(name, headers.toArray(new String[0]));
        }
        Map parameterMap = httpServletRequest.getParameterMap();
        HashMap resultsMap = new HashMap();
        if (Validator.isNull((String)authType)) {
            authType = company.getAuthType();
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = UserLocalServiceUtil.authenticateByEmailAddress((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
        } else if (authType.equals("screenName")) {
            authResult = UserLocalServiceUtil.authenticateByScreenName((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
        } else if (authType.equals("userId")) {
            authResult = UserLocalServiceUtil.authenticateByUserId((long)company.getCompanyId(), (long)GetterUtil.getLong((String)login), (String)password, headerMap, (Map)parameterMap, resultsMap);
        }
        User user = (User)resultsMap.get("user");
        if (authResult != 1) {
            if (user != null) {
                user = UserLocalServiceUtil.fetchUser((long)user.getUserId());
            }
            if (user != null) {
                UserLocalServiceUtil.checkLockout((User)user);
            }
            throw new AuthException();
        }
        return user;
    }
}

