/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SSHAPasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    public String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = this.getSaltBytes(encryptedPassword);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] plainTextPasswordBytes = plainTextPassword.getBytes("UTF-8");
            byte[] messageDigestBytes = messageDigest.digest(ArrayUtil.append((byte[][])new byte[][]{plainTextPasswordBytes, saltBytes}));
            return Base64.encode((byte[])ArrayUtil.append((byte[][])new byte[][]{messageDigestBytes, saltBytes}));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PwdEncryptorException(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PwdEncryptorException(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
    }

    public String[] getSupportedAlgorithmTypes() {
        return new String[]{"SSHA"};
    }

    protected byte[] getSaltBytes(String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = new byte[8];
        if (Validator.isNull((String)encryptedPassword)) {
            BigEndianCodec.putLong((byte[])saltBytes, (int)0, (long)SecureRandomUtil.nextLong());
        } else {
            try {
                byte[] encryptedPasswordBytes = Base64.decode((String)encryptedPassword);
                System.arraycopy(encryptedPasswordBytes, encryptedPasswordBytes.length - 8, saltBytes, 0, saltBytes.length);
            }
            catch (Exception exception) {
                throw new PwdEncryptorException("Unable to extract salt from encrypted password " + exception.getMessage(), (Throwable)exception);
            }
        }
        return saltBytes;
    }
}

