/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_1_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;

public class UpgradePortalPreferences
extends UpgradeProcess {
    protected String convertDefaultReminderQueries(String localizedPreference, String preferences) throws Exception {
        Document document = SAXReaderUtil.read((String)preferences);
        Element rootElement = document.getRootElement();
        Iterator iterator = rootElement.elementIterator();
        while (iterator.hasNext()) {
            Element preferenceElement = (Element)iterator.next();
            String preferenceName = preferenceElement.elementText("name");
            if (!preferenceName.equals("reminderQueries")) continue;
            Element defaultReminderQueryElement = preferenceElement.createCopy();
            Element nameElement = defaultReminderQueryElement.element("name");
            defaultReminderQueryElement.remove(nameElement);
            nameElement.setText(localizedPreference);
            defaultReminderQueryElement.add(nameElement);
            rootElement.add(defaultReminderQueryElement);
            break;
        }
        return XMLUtil.formatXML((Document)document);
    }

    protected void doUpgrade() throws Exception {
        this.upgradeOrganizationReminderQueries();
    }

    protected void upgradeOrganizationReminderQueries() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select PortalPreferences.portalPreferencesId, ", "PortalPreferences.preferences, Organization_.companyId ", "from PortalPreferences inner join Organization_ on ", "PortalPreferences.ownerId = Organization_.organizationId ", "where PortalPreferences.ownerType = ", 6, " and preferences like '%reminderQueries%'"}));
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortalPreferences set preferences = ? where portalPreferencesId = ?");){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                String preferences = resultSet.getString("preferences");
                String defaultLanguageId = UpgradeProcessUtil.getDefaultLanguageId((long)companyId);
                String localizedPreference = "reminderQueries_" + defaultLanguageId;
                if (preferences.contains(localizedPreference)) continue;
                preparedStatement2.setString(1, this.convertDefaultReminderQueries(localizedPreference, preferences));
                long portalPreferencesId = resultSet.getLong("portalPreferencesId");
                preparedStatement2.setLong(2, portalPreferencesId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

