/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.process.ConsumerOutputProcessor;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.util.PropsValues;
import java.net.HttpURLConnection;
import java.net.URL;

public class BrowserLauncher
implements Runnable {
    private static final String[] _BROWSERS = new String[]{"xdg-open", "firefox", "mozilla", "konqueror", "opera"};
    private static final Log _log = LogFactoryUtil.getLog(BrowserLauncher.class);

    @Override
    public void run() {
        block6: {
            try {
                URL url = new URL(PropsValues.BROWSER_LAUNCHER_URL);
                HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
                urlc.setConnectTimeout(0);
                urlc.setReadTimeout(0);
                urlc.setRequestMethod("HEAD");
                int responseCode = urlc.getResponseCode();
                if (responseCode == 200) {
                    try {
                        this.launchBrowser();
                    }
                    catch (Exception exception) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)exception, (Throwable)exception);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
    }

    protected void launchBrowser() throws Exception {
        if (OSDetector.isApple()) {
            this.launchBrowserApple(null);
        } else if (OSDetector.isWindows()) {
            this.launchBrowserWindows(null);
        } else {
            this.launchBrowserUnix(null);
        }
    }

    protected void launchBrowserApple(Runtime runtime) throws Exception {
        ProcessUtil.execute((OutputProcessor)ConsumerOutputProcessor.INSTANCE, (String[])new String[]{"open", PropsValues.BROWSER_LAUNCHER_URL});
    }

    protected void launchBrowserUnix(Runtime runtime) throws Exception {
        StringBundler sb = new StringBundler(_BROWSERS.length * 5 - 1);
        for (int i = 0; i < _BROWSERS.length; ++i) {
            if (i != 0) {
                sb.append(" || ");
            }
            sb.append(_BROWSERS[i]);
            sb.append(" \"");
            sb.append(PropsValues.BROWSER_LAUNCHER_URL);
            sb.append("\" ");
        }
        ProcessUtil.execute((OutputProcessor)ConsumerOutputProcessor.INSTANCE, (String[])new String[]{"sh", "-c", sb.toString()});
    }

    protected void launchBrowserWindows(Runtime runtime) throws Exception {
        ProcessUtil.execute((OutputProcessor)ConsumerOutputProcessor.INSTANCE, (String[])new String[]{"cmd.exe", "/c", "start", PropsValues.BROWSER_LAUNCHER_URL});
    }
}

