/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.util.LayoutDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class LayoutListUtil {
    public static List<LayoutDescription> getLayoutDescriptions(long groupId, boolean privateLayout, String rootNodeName, Locale locale) {
        String cacheKey;
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.REQUEST, (Serializable)((Object)LayoutListUtil.class.getName()));
        List<LayoutDescription> layoutDescriptions = (List<LayoutDescription>)threadLocalCache.get(cacheKey = LayoutListUtil.buildCacheKey(groupId, privateLayout, rootNodeName, locale));
        if (layoutDescriptions == null) {
            layoutDescriptions = LayoutListUtil.doGetLayoutDescriptions(groupId, privateLayout, rootNodeName, locale);
            threadLocalCache.put(cacheKey, layoutDescriptions);
        }
        return layoutDescriptions;
    }

    protected static String buildCacheKey(long groupId, boolean privateLayout, String rootNodeName, Locale locale) {
        return StringBundler.concat((Object[])new Object[]{StringUtil.toHexString((long)groupId), "#", privateLayout, "#", rootNodeName, "#", LocaleUtil.toLanguageId((Locale)locale)});
    }

    protected static List<LayoutDescription> doGetLayoutDescriptions(long groupId, boolean privateLayout, String rootNodeName, Locale locale) {
        ArrayList<LayoutDescription> layoutDescriptions = new ArrayList<LayoutDescription>();
        ArrayList layouts = new ArrayList(LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout));
        LinkedList<ObjectValuePair> deque = new LinkedList<ObjectValuePair>();
        LayoutImpl rootLayout = new LayoutImpl();
        rootLayout.setPlid(0L);
        rootLayout.setName(rootNodeName);
        deque.push(new ObjectValuePair((Object)rootLayout, (Object)0));
        ObjectValuePair objectValuePair = null;
        while ((objectValuePair = (ObjectValuePair)deque.pollFirst()) != null) {
            Layout currentLayout = (Layout)objectValuePair.getKey();
            Integer currentDepth = (Integer)objectValuePair.getValue();
            layoutDescriptions.add(new LayoutDescription(currentLayout.getPlid(), currentLayout.getName(locale), currentDepth));
            ListIterator listIterator = layouts.listIterator(layouts.size());
            while (listIterator.hasPrevious()) {
                Layout previousLayout = (Layout)listIterator.previous();
                if (previousLayout.getParentLayoutId() != currentLayout.getLayoutId()) continue;
                listIterator.remove();
                deque.push(new ObjectValuePair((Object)previousLayout, (Object)(currentDepth + 1)));
            }
        }
        return layoutDescriptions;
    }
}

