/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.base;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryFinder;
import com.liferay.asset.kernel.service.persistence.AssetEntryPersistence;
import com.liferay.asset.kernel.service.persistence.AssetTagPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;

public abstract class AssetEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AssetEntryLocalService,
IdentifiableOSGiService {
    @BeanReference(type=AssetEntryLocalService.class)
    protected AssetEntryLocalService assetEntryLocalService;
    @BeanReference(type=AssetEntryPersistence.class)
    protected AssetEntryPersistence assetEntryPersistence;
    @BeanReference(type=AssetEntryFinder.class)
    protected AssetEntryFinder assetEntryFinder;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=AssetTagPersistence.class)
    protected AssetTagPersistence assetTagPersistence;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public AssetEntry addAssetEntry(AssetEntry assetEntry) {
        assetEntry.setNew(true);
        return (AssetEntry)this.assetEntryPersistence.update((BaseModel)assetEntry);
    }

    @Transactional(enabled=false)
    public AssetEntry createAssetEntry(long entryId) {
        return this.assetEntryPersistence.create(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AssetEntry deleteAssetEntry(long entryId) throws PortalException {
        return this.assetEntryPersistence.remove(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AssetEntry deleteAssetEntry(AssetEntry assetEntry) {
        return (AssetEntry)this.assetEntryPersistence.remove((BaseModel)assetEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.assetEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(AssetEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.assetEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.assetEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.assetEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.assetEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.assetEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public AssetEntry fetchAssetEntry(long entryId) {
        return this.assetEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public AssetEntry getAssetEntry(long entryId) throws PortalException {
        return this.assetEntryPersistence.findByPrimaryKey(entryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.assetEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AssetEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.assetEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(AssetEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.assetEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AssetEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.assetEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.assetEntryLocalService.deleteAssetEntry((AssetEntry)persistedModel);
    }

    public BasePersistence<AssetEntry> getBasePersistence() {
        return this.assetEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.assetEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<AssetEntry> getAssetEntries(int start, int end) {
        return this.assetEntryPersistence.findAll(start, end);
    }

    public int getAssetEntriesCount() {
        return this.assetEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetEntry updateAssetEntry(AssetEntry assetEntry) {
        return (AssetEntry)this.assetEntryPersistence.update((BaseModel)assetEntry);
    }

    public void addAssetTagAssetEntry(long tagId, long entryId) {
        this.assetTagPersistence.addAssetEntry(tagId, entryId);
    }

    public void addAssetTagAssetEntry(long tagId, AssetEntry assetEntry) {
        this.assetTagPersistence.addAssetEntry(tagId, assetEntry);
    }

    public void addAssetTagAssetEntries(long tagId, long[] entryIds) {
        this.assetTagPersistence.addAssetEntries(tagId, entryIds);
    }

    public void addAssetTagAssetEntries(long tagId, List<AssetEntry> assetEntries) {
        this.assetTagPersistence.addAssetEntries(tagId, assetEntries);
    }

    public void clearAssetTagAssetEntries(long tagId) {
        this.assetTagPersistence.clearAssetEntries(tagId);
    }

    public void deleteAssetTagAssetEntry(long tagId, long entryId) {
        this.assetTagPersistence.removeAssetEntry(tagId, entryId);
    }

    public void deleteAssetTagAssetEntry(long tagId, AssetEntry assetEntry) {
        this.assetTagPersistence.removeAssetEntry(tagId, assetEntry);
    }

    public void deleteAssetTagAssetEntries(long tagId, long[] entryIds) {
        this.assetTagPersistence.removeAssetEntries(tagId, entryIds);
    }

    public void deleteAssetTagAssetEntries(long tagId, List<AssetEntry> assetEntries) {
        this.assetTagPersistence.removeAssetEntries(tagId, assetEntries);
    }

    public long[] getAssetTagPrimaryKeys(long entryId) {
        return this.assetEntryPersistence.getAssetTagPrimaryKeys(entryId);
    }

    public List<AssetEntry> getAssetTagAssetEntries(long tagId) {
        return this.assetTagPersistence.getAssetEntries(tagId);
    }

    public List<AssetEntry> getAssetTagAssetEntries(long tagId, int start, int end) {
        return this.assetTagPersistence.getAssetEntries(tagId, start, end);
    }

    public List<AssetEntry> getAssetTagAssetEntries(long tagId, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.assetTagPersistence.getAssetEntries(tagId, start, end, orderByComparator);
    }

    public int getAssetTagAssetEntriesCount(long tagId) {
        return this.assetTagPersistence.getAssetEntriesSize(tagId);
    }

    public boolean hasAssetTagAssetEntry(long tagId, long entryId) {
        return this.assetTagPersistence.containsAssetEntry(tagId, entryId);
    }

    public boolean hasAssetTagAssetEntries(long tagId) {
        return this.assetTagPersistence.containsAssetEntries(tagId);
    }

    public void setAssetTagAssetEntries(long tagId, long[] entryIds) {
        this.assetTagPersistence.setAssetEntries(tagId, entryIds);
    }

    public AssetEntryLocalService getAssetEntryLocalService() {
        return this.assetEntryLocalService;
    }

    public void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this.assetEntryLocalService = assetEntryLocalService;
    }

    public AssetEntryPersistence getAssetEntryPersistence() {
        return this.assetEntryPersistence;
    }

    public void setAssetEntryPersistence(AssetEntryPersistence assetEntryPersistence) {
        this.assetEntryPersistence = assetEntryPersistence;
    }

    public AssetEntryFinder getAssetEntryFinder() {
        return this.assetEntryFinder;
    }

    public void setAssetEntryFinder(AssetEntryFinder assetEntryFinder) {
        this.assetEntryFinder = assetEntryFinder;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.asset.kernel.model.AssetEntry", (PersistedModelLocalService)this.assetEntryLocalService);
        this._setLocalServiceUtilService(this.assetEntryLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.asset.kernel.model.AssetEntry");
        this._setLocalServiceUtilService(null);
    }

    public String getOSGiServiceIdentifier() {
        return AssetEntryLocalService.class.getName();
    }

    public CTPersistence<AssetEntry> getCTPersistence() {
        return this.assetEntryPersistence;
    }

    public Class<AssetEntry> getModelClass() {
        return AssetEntry.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<AssetEntry>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.assetEntryPersistence);
    }

    protected String getModelClassName() {
        return AssetEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.assetEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(AssetEntryLocalService assetEntryLocalService) {
        try {
            Field field = AssetEntryLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, assetEntryLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

