/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.internal.CacheControlImpl;
import com.liferay.portlet.internal.PortletResponseImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.portlet.MimeResponse;
import javax.portlet.WindowState;

public abstract class MimeResponseImpl
extends PortletResponseImpl
implements MimeResponse {
    private boolean _calledFlushBuffer;
    private boolean _calledGetPortletOutputStream;
    private boolean _calledGetWriter;
    private String _contentType;

    public void flushBuffer() throws IOException {
        this.httpServletResponse.flushBuffer();
        this._calledFlushBuffer = true;
    }

    public int getBufferSize() {
        return this.httpServletResponse.getBufferSize();
    }

    public CacheControl getCacheControl() {
        Portlet portlet = this.getPortlet();
        int expirationTime = 0;
        Integer expCache = portlet.getExpCache();
        if (expCache != null) {
            expirationTime = expCache;
        }
        return new CacheControlImpl(null, expirationTime, false, false, this);
    }

    public String getCharacterEncoding() {
        return this.httpServletResponse.getCharacterEncoding();
    }

    public String getContentType() {
        return this._contentType;
    }

    public Locale getLocale() {
        return this.portletRequestImpl.getLocale();
    }

    public OutputStream getPortletOutputStream() throws IllegalStateException, IOException {
        if (this._calledGetWriter) {
            throw new IllegalStateException("Unable to obtain OutputStream because Writer is already in use");
        }
        if (this._contentType == null) {
            this.setContentType(this.portletRequestImpl.getResponseContentType());
        }
        this._calledGetPortletOutputStream = true;
        return this.httpServletResponse.getOutputStream();
    }

    public PrintWriter getWriter() throws IllegalStateException, IOException {
        if (this._calledGetPortletOutputStream) {
            throw new IllegalStateException("Unable to obtain Writer because OutputStream is already in use");
        }
        if (this._contentType == null) {
            this.setContentType(this.portletRequestImpl.getResponseContentType());
        }
        this._calledGetWriter = true;
        return this.httpServletResponse.getWriter();
    }

    public boolean isCalledFlushBuffer() {
        return this._calledFlushBuffer;
    }

    public boolean isCalledGetPortletOutputStream() {
        return this._calledGetPortletOutputStream;
    }

    public boolean isCalledGetWriter() {
        return this._calledGetWriter;
    }

    public boolean isCommitted() {
        return this.httpServletResponse.isCommitted();
    }

    public void reset() {
        if (this._calledFlushBuffer) {
            throw new IllegalStateException("Unable to reset a buffer that has been flushed");
        }
    }

    public void resetBuffer() {
        if (this._calledFlushBuffer) {
            throw new IllegalStateException("Unable to reset a buffer that has been flushed");
        }
        this.httpServletResponse.resetBuffer();
    }

    public void setBufferSize(int bufferSize) {
        this.httpServletResponse.setBufferSize(bufferSize);
    }

    public void setContentType(String contentType) {
        if (this._calledGetPortletOutputStream || this._calledGetWriter) {
            return;
        }
        if (Validator.isNull((String)contentType)) {
            throw new IllegalArgumentException("Content type is null");
        }
        String lifecycle = this.getLifecycle();
        WindowState windowState = this.portletRequestImpl.getWindowState();
        if (!(contentType.startsWith(this.portletRequestImpl.getResponseContentType()) || lifecycle.equals("RESOURCE_PHASE") || windowState.equals((Object)LiferayWindowState.EXCLUSIVE))) {
            throw new IllegalArgumentException(contentType + " is an unsupported content type");
        }
        this._contentType = contentType;
        this.httpServletResponse.setContentType(contentType);
    }
}

