/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayActionRequest;
import com.liferay.portal.kernel.portlet.LiferayActionResponse;
import com.liferay.portal.kernel.portlet.LiferayEventRequest;
import com.liferay.portal.kernel.portlet.LiferayEventResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayResourceRequest;
import com.liferay.portal.kernel.portlet.LiferayResourceResponse;
import com.liferay.portal.kernel.portlet.LiferayStateAwareResponse;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletQName;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.portlet.async.PortletAsyncScopeManager;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIconMenu;
import com.liferay.portal.kernel.portlet.toolbar.PortletToolbar;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import com.liferay.portal.kernel.servlet.TransferHeadersHelperUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.PortletConfigurationIconComparator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.theme.PortletDisplayFactory;
import com.liferay.portlet.ActionRequestFactory;
import com.liferay.portlet.ActionResponseFactory;
import com.liferay.portlet.EventRequestFactory;
import com.liferay.portlet.EventResponseFactory;
import com.liferay.portlet.InvokerPortletUtil;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.ResourceRequestFactory;
import com.liferay.portlet.ResourceResponseFactory;
import com.liferay.portlet.internal.EventImpl;
import com.liferay.portlet.internal.MutableRenderParametersImpl;
import com.liferay.portlet.internal.PortletAsyncContextImpl;
import com.liferay.util.SerializableUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletContainerImpl
implements PortletContainer {
    private static final Log _log = LogFactoryUtil.getLog(PortletContainerImpl.class);
    private PortletConfigurationIconMenu _portletConfigurationIconMenu;
    private PortletToolbar _portletToolbar;

    public void preparePortlet(HttpServletRequest httpServletRequest, Portlet portlet) throws PortletContainerException {
        try {
            this._preparePortlet(httpServletRequest, portlet);
        }
        catch (Exception exception) {
            throw new PortletContainerException((Throwable)exception);
        }
    }

    public ActionResult processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        return (ActionResult)this._preserveGroupIds(httpServletRequest, () -> {
            if (portlet != null) {
                this._processGroupId(httpServletRequest, portlet);
            }
            return this._processAction(httpServletRequest, httpServletResponse, portlet);
        });
    }

    public List<Event> processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        return (List)this._preserveGroupIds(httpServletRequest, () -> {
            String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
            if (portlet != null && portletId.equals(portlet.getPortletId())) {
                this._processGroupId(httpServletRequest, portlet);
            }
            return this._processEvent(httpServletRequest, httpServletResponse, portlet, layout, event);
        });
    }

    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout) {
        this.processPublicRenderParameters(httpServletRequest, layout, null);
    }

    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        LayoutType layoutType = layout.getLayoutType();
        if (!(layoutType instanceof LayoutTypePortlet)) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layoutType;
        List portlets = layoutTypePortlet.getPortlets();
        portlets.remove(portlet);
        this._processPublicRenderParameters(httpServletRequest, layout, portlets, false);
    }

    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        this._preserveGroupIds(httpServletRequest, () -> {
            String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
            if (portlet != null && portletId.equals(portlet.getPortletId())) {
                this._processGroupId(httpServletRequest, portlet);
            }
            this._render(httpServletRequest, httpServletResponse, portlet, false);
            return null;
        });
    }

    public void renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        this._preserveGroupIds(httpServletRequest, () -> {
            String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
            if (portlet != null && portletId.equals(portlet.getPortletId())) {
                this._processGroupId(httpServletRequest, portlet);
            }
            this._render(httpServletRequest, httpServletResponse, portlet, true);
            return null;
        });
    }

    public void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        this._preserveGroupIds(httpServletRequest, () -> {
            if (portlet != null) {
                this._processGroupId(httpServletRequest, portlet);
            }
            this._serveResource(httpServletRequest, httpServletResponse, portlet);
            return null;
        });
    }

    public void setPortletConfigurationIconMenu(PortletConfigurationIconMenu portletConfigurationIconMenu) {
        this._portletConfigurationIconMenu = portletConfigurationIconMenu;
    }

    public void setPortletToolbar(PortletToolbar portletToolbar) {
        this._portletToolbar = portletToolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getScopeGroupId(HttpServletRequest httpServletRequest, Layout layout, String portletId) throws PortalException {
        long scopeGroupId = 0L;
        Layout requestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        try {
            httpServletRequest.setAttribute("LAYOUT", (Object)layout);
            scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)httpServletRequest, (String)portletId);
        }
        finally {
            httpServletRequest.setAttribute("LAYOUT", (Object)requestLayout);
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = PortalUtil.getScopeGroupId((Layout)layout, (String)portletId);
        }
        return scopeGroupId;
    }

    protected Event serializeEvent(Event event, ClassLoader portletClassLoader) {
        Serializable value = event.getValue();
        if (value == null) {
            return event;
        }
        Class<?> valueClass = value.getClass();
        String valueClassName = valueClass.getName();
        try {
            Class<?> loadedValueClass = portletClassLoader.loadClass(valueClassName);
            if (loadedValueClass.equals(valueClass)) {
                return event;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        byte[] serializedValue = SerializableUtil.serialize((Object)value);
        value = (Serializable)SerializableUtil.deserialize((byte[])serializedValue, (ClassLoader)portletClassLoader);
        return new EventImpl(event.getName(), event.getQName(), value);
    }

    private boolean _isPublishedContentPage(Layout layout) {
        return !layout.isDraftLayout() && layout.isTypeContent();
    }

    private void _preparePortlet(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        User user = PortalUtil.getUser((HttpServletRequest)httpServletRequest);
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (user != null) {
            InvokerPortletUtil.clearResponse(httpServletRequest.getSession(), layout.getPrimaryKey(), portlet.getPortletId(), LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest));
        }
        this._processPublicRenderParameters(httpServletRequest, layout, Arrays.asList(portlet), themeDisplay.isLifecycleAction());
        if (themeDisplay.isHubAction() || themeDisplay.isHubPartialAction() || themeDisplay.isLifecycleAction() || themeDisplay.isLifecycleRender() || themeDisplay.isLifecycleResource()) {
            WindowState windowState = WindowStateFactory.getWindowState((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_state"));
            if (layout.isTypeControlPanel() && (windowState == null || windowState.equals((Object)WindowState.NORMAL) || Validator.isNull((String)windowState.toString()))) {
                windowState = WindowState.MAXIMIZED;
            }
            PortletMode portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_mode"));
            PortalUtil.updateWindowState((String)portlet.getPortletId(), (User)user, (Layout)layout, (WindowState)windowState, (HttpServletRequest)httpServletRequest);
            PortalUtil.updatePortletMode((String)portlet.getPortletId(), (User)user, (Layout)layout, (PortletMode)portletMode, (HttpServletRequest)httpServletRequest);
        }
    }

    private <T> T _preserveGroupIds(HttpServletRequest httpServletRequest, UnsafeSupplier<T, Exception> unsafeSupplier) throws PortletContainerException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long previousScopeGroupId = 0L;
        long previousSiteGroupId = 0L;
        if (themeDisplay != null) {
            previousScopeGroupId = themeDisplay.getScopeGroupId();
            previousSiteGroupId = themeDisplay.getSiteGroupId();
        }
        try {
            Object object = unsafeSupplier.get();
            return (T)object;
        }
        catch (Exception exception) {
            throw new PortletContainerException((Throwable)exception);
        }
        finally {
            if (themeDisplay != null) {
                if (GroupLocalServiceUtil.fetchGroup((long)previousScopeGroupId) != null) {
                    themeDisplay.setScopeGroupId(previousScopeGroupId);
                }
                if (GroupLocalServiceUtil.fetchGroup((long)previousSiteGroupId) != null) {
                    themeDisplay.setSiteGroupId(previousSiteGroupId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResult _processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        portletDisplay.setId(portlet.getPortletId());
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        WindowState windowState = WindowStateFactory.getWindowState((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_state"));
        if (layout.isTypeControlPanel() && (windowState == null || windowState.equals((Object)WindowState.NORMAL) || Validator.isNull((String)windowState.toString()))) {
            windowState = WindowState.MAXIMIZED;
        }
        PortletMode portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_mode"));
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)httpServletRequest, (String)portlet.getPortletId());
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
        ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        if (_log.isDebugEnabled()) {
            String contentType = httpServletRequest.getHeader("Content-Type");
            _log.debug((Object)("Content type " + contentType));
        }
        try {
            LiferayActionRequest liferayActionRequest = ActionRequestFactory.create(httpServletRequest, portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
            LiferayActionResponse liferayActionResponse = ActionResponseFactory.create((ActionRequest)liferayActionRequest, httpServletResponse, PortalUtil.getUser((HttpServletRequest)httpServletRequest), layout);
            liferayActionRequest.defineObjects(portletConfig, (PortletResponse)liferayActionResponse);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)liferayActionRequest);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            invokerPortlet.processAction((ActionRequest)liferayActionRequest, (ActionResponse)liferayActionResponse);
            liferayActionResponse.transferHeaders(httpServletResponse);
            RenderParametersPool.clear(httpServletRequest, layout.getPlid(), portlet.getPortletId());
            PortletApp portletApp = portlet.getPortletApp();
            if (portletApp.getSpecMajorVersion() < 3) {
                RenderParametersPool.put(httpServletRequest, layout.getPlid(), portlet.getPortletId(), liferayActionResponse.getRenderParameterMap());
            } else {
                Layout requestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
                this._setAllRenderParameters(httpServletRequest, (LiferayStateAwareResponse)liferayActionResponse, portlet, requestLayout);
            }
            List events = liferayActionResponse.getEvents();
            String redirectLocation = liferayActionResponse.getRedirectLocation();
            if (Validator.isNull((String)redirectLocation) && portlet.isActionURLRedirect()) {
                LiferayPortletURL portletURL = null;
                if (portletApp.getSpecMajorVersion() < 3) {
                    portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayActionRequest, (Portlet)portlet, (Layout)layout, (String)"RENDER_PHASE");
                    Map renderParameters = liferayActionResponse.getRenderParameterMap();
                    for (Map.Entry entry : renderParameters.entrySet()) {
                        portletURL.setParameter((String)entry.getKey(), (String[])entry.getValue());
                    }
                } else {
                    portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayActionRequest, (Portlet)portlet, (long)layout.getPlid(), (String)"RENDER_PHASE", (MimeResponse.Copy)MimeResponse.Copy.ALL);
                }
                redirectLocation = portletURL.toString();
            }
            ActionResult actionResult = new ActionResult(events, redirectLocation);
            return actionResult;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> _processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Layout layout, Event event) throws Exception {
        ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        WindowState windowState = null;
        windowState = layoutTypePortlet.hasStateMaxPortletId(portlet.getPortletId()) ? WindowState.MAXIMIZED : (layoutTypePortlet.hasStateMinPortletId(portlet.getPortletId()) ? WindowState.MINIMIZED : WindowState.NORMAL);
        PortletMode portletMode = null;
        portletMode = layoutTypePortlet.hasModeAboutPortletId(portlet.getPortletId()) ? LiferayPortletMode.ABOUT : (layoutTypePortlet.hasModeConfigPortletId(portlet.getPortletId()) ? LiferayPortletMode.CONFIG : (layoutTypePortlet.hasModeEditPortletId(portlet.getPortletId()) ? PortletMode.EDIT : (layoutTypePortlet.hasModeEditDefaultsPortletId(portlet.getPortletId()) ? LiferayPortletMode.EDIT_DEFAULTS : (layoutTypePortlet.hasModeEditGuestPortletId(portlet.getPortletId()) ? LiferayPortletMode.EDIT_GUEST : (layoutTypePortlet.hasModeHelpPortletId(portlet.getPortletId()) ? PortletMode.HELP : (layoutTypePortlet.hasModePreviewPortletId(portlet.getPortletId()) ? LiferayPortletMode.PREVIEW : (layoutTypePortlet.hasModePrintPortletId(portlet.getPortletId()) ? LiferayPortletMode.PRINT : PortletMode.VIEW)))))));
        long scopeGroupId = this.getScopeGroupId(httpServletRequest, layout, portlet.getPortletId());
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((long)scopeGroupId, (Layout)layout, (String)portlet.getPortletId(), null);
        LiferayEventRequest liferayEventRequest = EventRequestFactory.create(httpServletRequest, portlet, invokerPortlet, portletConfig.getPortletContext(), windowState, portletMode, portletPreferences, layout.getPlid());
        liferayEventRequest.setEvent(this.serializeEvent(event, invokerPortlet.getPortletClassLoader()));
        Layout requestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        LiferayEventResponse liferayEventResponse = EventResponseFactory.create((EventRequest)liferayEventRequest, httpServletResponse, PortalUtil.getUser((HttpServletRequest)httpServletRequest), requestLayout);
        liferayEventRequest.defineObjects(portletConfig, (PortletResponse)liferayEventResponse);
        try {
            invokerPortlet.processEvent((EventRequest)liferayEventRequest, (EventResponse)liferayEventResponse);
            liferayEventResponse.transferHeaders(httpServletResponse);
            if (liferayEventResponse.isCalledSetRenderParameter()) {
                PortletApp portletApp = portlet.getPortletApp();
                if (portletApp.getSpecMajorVersion() < 3) {
                    RenderParametersPool.put(httpServletRequest, requestLayout.getPlid(), portlet.getPortletId(), new HashMap<String, String[]>(liferayEventResponse.getRenderParameterMap()));
                } else {
                    this._setAllRenderParameters(httpServletRequest, (LiferayStateAwareResponse)liferayEventResponse, portlet, requestLayout);
                }
            }
            List list = liferayEventResponse.getEvents();
            return list;
        }
        finally {
            liferayEventRequest.cleanUp();
        }
    }

    private void _processGroupId(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)httpServletRequest, (String)portlet.getPortletId());
        themeDisplay.setScopeGroupId(scopeGroupId);
        long siteGroupId = 0L;
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        siteGroupId = layout.isTypeControlPanel() ? PortalUtil.getSiteGroupId((long)scopeGroupId) : PortalUtil.getSiteGroupId((long)layout.getGroupId());
        themeDisplay.setSiteGroupId(siteGroupId);
    }

    private void _processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout, List<Portlet> portlets, boolean lifecycleAction) {
        PortletQName portletQName = PortletQNameUtil.getPortletQName();
        Map<String, String[]> publicRenderParameters = null;
        Map parameters = httpServletRequest.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            QName qName = portletQName.getQName(name);
            if (qName == null) continue;
            for (Portlet portlet : portlets) {
                PublicRenderParameter publicRenderParameter = portlet.getPublicRenderParameter(qName.getNamespaceURI(), qName.getLocalPart());
                if (publicRenderParameter == null) continue;
                if (publicRenderParameters == null) {
                    publicRenderParameters = PublicRenderParametersPool.get(httpServletRequest, layout.getPlid());
                }
                String publicRenderParameterName = portletQName.getPublicRenderParameterName(qName);
                if (name.startsWith("p_r_p_")) {
                    Object[] oldValues;
                    Object[] values = (String[])entry.getValue();
                    if (lifecycleAction && (oldValues = publicRenderParameters.get(publicRenderParameterName)) != null && oldValues.length != 0) {
                        values = (String[])ArrayUtil.append((Object[])values, (Object[])oldValues);
                    }
                    publicRenderParameters.put(publicRenderParameterName, (String[])values);
                    continue;
                }
                publicRenderParameters.remove(publicRenderParameterName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, boolean headerPhase) throws Exception {
        PortletResponse portletResponse;
        if (portlet != null && portlet.isInstanceable() && !portlet.isAddDefaultResource() && !Validator.isPassword((String)portlet.getInstanceId())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Portlet ", portlet.getPortletId(), " is instanceable but does not have a valid instance ", "id"}));
            }
            portlet = null;
        }
        if (portlet == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletPreferencesFactoryUtil.checkControlPanelPortletPreferences((ThemeDisplay)themeDisplay, (Portlet)portlet);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._portletConfigurationIconMenu.setComparator(PortletConfigurationIconComparator.INSTANCE);
        portletDisplay.setPortletConfigurationIconMenu(this._portletConfigurationIconMenu);
        portletDisplay.setPortletToolbar(this._portletToolbar);
        PortletDisplay portletDisplayClone = PortletDisplayFactory.create();
        portletDisplay.copyTo(portletDisplayClone);
        PortletConfig portletConfig = (PortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (!(portletRequest instanceof RenderRequest)) {
            portletRequest = null;
        }
        if (!((portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response")) instanceof RenderResponse)) {
            portletResponse = null;
        }
        String lifecycle = (String)httpServletRequest.getAttribute("javax.portlet.lifecycle_phase");
        httpServletRequest.setAttribute("RENDER_PORTLET", (Object)portlet);
        String path = (String)httpServletRequest.getAttribute("RENDER_PATH");
        if (path == null) {
            path = "/html/portal/render_portlet.jsp";
        }
        if (headerPhase) {
            path = "/html/portal/header_portlet.jsp";
        }
        RequestDispatcher requestDispatcher = TransferHeadersHelperUtil.getTransferHeadersRequestDispatcher((RequestDispatcher)DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletRequest)httpServletRequest, (String)path));
        BufferCacheServletResponse bufferCacheServletResponse = null;
        boolean writeOutput = false;
        if (httpServletResponse instanceof BufferCacheServletResponse) {
            bufferCacheServletResponse = (BufferCacheServletResponse)httpServletResponse;
        } else {
            writeOutput = true;
            bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        }
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)bufferCacheServletResponse);
            Boolean portletConfiguratorVisibility = (Boolean)httpServletRequest.getAttribute("PORTLET_CONFIGURATOR_VISIBILITY");
            if (portletConfiguratorVisibility != null) {
                httpServletRequest.removeAttribute("PORTLET_CONFIGURATOR_VISIBILITY");
                Layout layout = themeDisplay.getLayout();
                if (this._isPublishedContentPage(layout) || !layout.isTypeControlPanel() && !LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE") && !PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)portlet.getPortletId(), (String)"CONFIGURATION")) {
                    bufferCacheServletResponse.setCharBuffer(null);
                    return;
                }
            }
            if (writeOutput) {
                PrintWriter writer = httpServletResponse.getWriter();
                ((Writer)writer).write(bufferCacheServletResponse.getString());
            }
        }
        finally {
            portletDisplay.copyFrom(portletDisplayClone);
            portletDisplayClone.recycle();
            if (portletConfig != null) {
                httpServletRequest.setAttribute("javax.portlet.config", (Object)portletConfig);
            }
            if (portletRequest != null) {
                httpServletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
            }
            if (portletResponse != null) {
                httpServletRequest.setAttribute("javax.portlet.response", (Object)portletResponse);
            }
            if (lifecycle != null) {
                httpServletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            }
            httpServletRequest.removeAttribute("RENDER_PORTLET");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws Exception {
        WindowState requestWindowState;
        WindowState windowState = (WindowState)httpServletRequest.getAttribute("WINDOW_STATE");
        PortletApp portletApp = portlet.getPortletApp();
        int portletSpecMajorVersion = portletApp.getSpecMajorVersion();
        if (portletSpecMajorVersion >= 3 && WindowState.UNDEFINED.equals((Object)(requestWindowState = WindowStateFactory.getWindowState((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_state"), (int)3)))) {
            windowState = requestWindowState;
        }
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)httpServletRequest, (String)portlet.getPortletId());
        ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        String portletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId());
        portletDisplay.setId(portlet.getPortletId());
        portletDisplay.setInstanceId(portlet.getInstanceId());
        portletDisplay.setNamespace(PortalUtil.getPortletNamespace((String)portlet.getPortletId()));
        portletDisplay.setPortletName(portletConfig.getPortletName());
        portletDisplay.setResourcePK(portletPrimaryKey);
        portletDisplay.setRootPortletId(portlet.getRootPortletId());
        WebDAVStorage webDAVStorage = portlet.getWebDAVStorageInstance();
        if (webDAVStorage != null) {
            portletDisplay.setWebDAVEnabled(true);
        } else {
            portletDisplay.setWebDAVEnabled(false);
        }
        LiferayResourceRequest liferayResourceRequest = null;
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest instanceof LiferayResourceRequest) {
            liferayResourceRequest = (LiferayResourceRequest)portletRequest;
        }
        LiferayResourceResponse liferayResourceResponse = null;
        if (liferayResourceRequest == null) {
            PortletMode portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_mode"), (int)portletSpecMajorVersion);
            PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
            liferayResourceRequest = ResourceRequestFactory.create(httpServletRequest, portlet, invokerPortlet, portletConfig.getPortletContext(), windowState, portletMode, portletPreferences, layout.getPlid());
            liferayResourceResponse = ResourceResponseFactory.create((ResourceRequest)liferayResourceRequest, httpServletResponse);
        } else {
            liferayResourceResponse = (LiferayResourceResponse)httpServletRequest.getAttribute("javax.portlet.response");
        }
        liferayResourceRequest.defineObjects(portletConfig, (PortletResponse)liferayResourceResponse);
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)liferayResourceRequest);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            invokerPortlet.serveResource((ResourceRequest)liferayResourceRequest, (ResourceResponse)liferayResourceResponse);
            liferayResourceResponse.transferHeaders(httpServletResponse);
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
            if (liferayResourceRequest.isAsyncStarted() && liferayResourceRequest.isAsyncSupported()) {
                PortletAsyncContextImpl portletAsyncContextImpl = (PortletAsyncContextImpl)liferayResourceRequest.getPortletAsyncContext();
                if (themeDisplay.isAsync()) {
                    PortletAsyncScopeManager portletAsyncScopeManager = portletAsyncContextImpl.getPortletAsyncScopeManager();
                    portletAsyncScopeManager.deactivateScopeContexts(true);
                }
                portletAsyncContextImpl.setReturnedToContainer();
            }
        }
    }

    private void _setAllRenderParameters(HttpServletRequest httpServletRequest, LiferayStateAwareResponse liferayStateAwareResponse, Portlet portlet, Layout requestLayout) {
        MutableRenderParametersImpl mutableRenderParametersImpl = (MutableRenderParametersImpl)liferayStateAwareResponse.getRenderParameters();
        Map<String, String[]> mutableRenderParameterMap = mutableRenderParametersImpl.getParameterMap();
        HashMap<String, QName> supportedPublicRenderParameterMap = new HashMap<String, QName>();
        for (PublicRenderParameter supportedPublicRenderParameter : portlet.getPublicRenderParameters()) {
            supportedPublicRenderParameterMap.put(supportedPublicRenderParameter.getIdentifier(), supportedPublicRenderParameter.getQName());
        }
        Map<String, String[]> publicRenderParameterMap = PublicRenderParametersPool.get(httpServletRequest, requestLayout.getPlid());
        HashMap<String, String[]> privateRenderParameterMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : mutableRenderParameterMap.entrySet()) {
            String key = entry.getKey();
            QName qName = (QName)supportedPublicRenderParameterMap.get(key);
            if (qName != null) {
                publicRenderParameterMap.put(PortletQNameUtil.getPublicRenderParameterName((QName)qName), entry.getValue());
                continue;
            }
            privateRenderParameterMap.put(key, entry.getValue());
        }
        if (!privateRenderParameterMap.isEmpty()) {
            RenderParametersPool.put(httpServletRequest, requestLayout.getPlid(), portlet.getPortletId(), privateRenderParameterMap);
        }
    }
}

