/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLSyncEventLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.CommentCapability;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.capabilities.RelatedModelCapability;
import com.liferay.portal.kernel.repository.capabilities.SyncCapability;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.model.FileContentReference;
import com.liferay.portal.kernel.repository.model.ModelValidator;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.repository.util.ModelValidatorUtil;
import com.liferay.portal.repository.capabilities.LiferayBulkOperationCapability;
import com.liferay.portal.repository.capabilities.LiferayCommentCapability;
import com.liferay.portal.repository.capabilities.LiferayProcessorCapability;
import com.liferay.portal.repository.capabilities.LiferayRelatedModelCapability;
import com.liferay.portal.repository.capabilities.LiferaySyncCapability;
import com.liferay.portal.repository.capabilities.LiferayThumbnailCapability;
import com.liferay.portal.repository.capabilities.LiferayTrashCapability;
import com.liferay.portal.repository.capabilities.LiferayWorkflowCapability;
import com.liferay.portal.repository.capabilities.util.DLAppServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFileEntryServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFileVersionServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFolderServiceAdapter;
import com.liferay.portal.repository.capabilities.util.GroupServiceAdapter;
import com.liferay.portal.repository.capabilities.util.RepositoryEntryChecker;
import com.liferay.portal.repository.capabilities.util.RepositoryEntryConverter;
import com.liferay.portal.repository.capabilities.util.RepositoryServiceAdapter;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.ModelValidatorLocalRepositoryWrapper;
import com.liferay.portal.repository.liferayrepository.ModelValidatorRepositoryWrapper;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil;
import com.liferay.trash.kernel.service.TrashVersionLocalServiceUtil;

public class LiferayRepositoryDefiner
extends BaseRepositoryDefiner {
    public static final String CLASS_NAME = LiferayRepository.class.getName();
    private final CommentCapability _commentCapability = new LiferayCommentCapability();
    private final ProcessorCapability _processorCapability = new LiferayProcessorCapability();
    private RepositoryFactory _repositoryFactory;

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean isExternalRepository() {
        return false;
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        DocumentRepository documentRepository = (DocumentRepository)capabilityRegistry.getTarget();
        DLFileEntryServiceAdapter dlFileEntryServiceAdapter = DLFileEntryServiceAdapter.create(documentRepository);
        DLFolderServiceAdapter dlFolderServiceAdapter = DLFolderServiceAdapter.create(documentRepository);
        LiferayBulkOperationCapability bulkOperationCapability = new LiferayBulkOperationCapability(documentRepository, dlFileEntryServiceAdapter, dlFolderServiceAdapter);
        capabilityRegistry.addExportedCapability(BulkOperationCapability.class, (Capability)bulkOperationCapability);
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            capabilityRegistry.addExportedCapability(CommentCapability.class, (Capability)this._commentCapability);
        }
        RepositoryEntryConverter repositoryEntryConverter = new RepositoryEntryConverter();
        RepositoryEntryChecker repositoryEntryChecker = new RepositoryEntryChecker(documentRepository);
        capabilityRegistry.addExportedCapability(RelatedModelCapability.class, (Capability)new LiferayRelatedModelCapability(repositoryEntryConverter, repositoryEntryChecker));
        capabilityRegistry.addExportedCapability(ThumbnailCapability.class, (Capability)new LiferayThumbnailCapability(repositoryEntryConverter, repositoryEntryChecker));
        LiferayTrashCapability trashCapability = new LiferayTrashCapability(DLAppHelperLocalServiceUtil.getService(), DLAppServiceAdapter.create(documentRepository), dlFileEntryServiceAdapter, dlFolderServiceAdapter, RepositoryServiceAdapter.create(documentRepository), TrashEntryLocalServiceUtil.getService(), TrashVersionLocalServiceUtil.getService());
        capabilityRegistry.addExportedCapability(TrashCapability.class, (Capability)trashCapability);
        capabilityRegistry.addExportedCapability(WorkflowCapability.class, (Capability)new LiferayWorkflowCapability(dlFileEntryServiceAdapter, DLFileVersionServiceAdapter.create(documentRepository)));
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, (Capability)this._processorCapability);
        capabilityRegistry.addSupportedCapability(SyncCapability.class, (Capability)new LiferaySyncCapability(GroupServiceAdapter.create(documentRepository), DLSyncEventLocalServiceUtil.getService()));
    }

    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory(this._repositoryFactory);
    }

    public void setRepositoryFactory(RepositoryFactory repositoryFactory) {
        this._repositoryFactory = new LiferayRepositoryFactoryWrapper(repositoryFactory);
    }

    private static class LiferayRepositoryFactoryWrapper
    implements RepositoryFactory {
        private final RepositoryFactory _repositoryFactory;

        public LiferayRepositoryFactoryWrapper(RepositoryFactory repositoryFactory) {
            this._repositoryFactory = repositoryFactory;
        }

        public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
            LocalRepository localRepository = this._repositoryFactory.createLocalRepository(repositoryId);
            ModelValidator modelValidator = ModelValidatorUtil.getDefaultDLFileEntryModelValidator();
            return new ModelValidatorLocalRepositoryWrapper(localRepository, (ModelValidator<FileContentReference>)modelValidator);
        }

        public Repository createRepository(long repositoryId) throws PortalException {
            Repository repository = this._repositoryFactory.createRepository(repositoryId);
            ModelValidator modelValidator = ModelValidatorUtil.getDefaultDLFileEntryModelValidator();
            return new ModelValidatorRepositoryWrapper(repository, (ModelValidator<FileContentReference>)modelValidator);
        }
    }
}

