/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositePasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    private static final Log _log = LogFactoryUtil.getLog(CompositePasswordEncryptor.class);
    private PasswordEncryptor _defaultAlgorithmPasswordEncryptor;
    private PasswordEncryptor _defaultPasswordEncryptor;
    private final Map<String, PasswordEncryptor> _passwordEncryptors = new HashMap<String, PasswordEncryptor>();

    public void afterPropertiesSet() {
        if (this._defaultAlgorithmPasswordEncryptor == null) {
            this._defaultAlgorithmPasswordEncryptor = this._select(this.getDefaultPasswordAlgorithmType());
        }
    }

    @Override
    public String encrypt(String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        if (Validator.isNull((String)plainTextPassword)) {
            throw new PwdEncryptorException("Unable to encrypt blank password");
        }
        return this._defaultAlgorithmPasswordEncryptor.encrypt(this.getDefaultPasswordAlgorithmType(), plainTextPassword, encryptedPassword);
    }

    public String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        if (Validator.isNull((String)plainTextPassword)) {
            throw new PwdEncryptorException("Unable to encrypt blank password");
        }
        PasswordEncryptor passwordEncryptor = this._select(algorithm);
        return passwordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword);
    }

    public String[] getSupportedAlgorithmTypes() {
        throw new UnsupportedOperationException();
    }

    public void setDefaultPasswordEncryptor(PasswordEncryptor defaultPasswordEncryptor) {
        this._defaultPasswordEncryptor = defaultPasswordEncryptor;
    }

    public void setPasswordEncryptors(List<PasswordEncryptor> passwordEncryptors) {
        for (PasswordEncryptor passwordEncryptor : passwordEncryptors) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Registering " + passwordEncryptor));
            }
            Object[] supportedAlgorithmTypes = passwordEncryptor.getSupportedAlgorithmTypes();
            if (_log.isDebugEnabled()) {
                Class<?> clazz = passwordEncryptor.getClass();
                _log.debug((Object)("Registering " + StringUtil.merge((Object[])supportedAlgorithmTypes) + " for " + clazz.getName()));
            }
            for (Object supportedAlgorithmType : supportedAlgorithmTypes) {
                this._passwordEncryptors.put((String)supportedAlgorithmType, passwordEncryptor);
            }
        }
    }

    private PasswordEncryptor _select(String algorithm) {
        if (Validator.isNull((String)algorithm)) {
            throw new IllegalArgumentException("Invalid algorithm");
        }
        PasswordEncryptor passwordEncryptor = null;
        passwordEncryptor = algorithm.startsWith("BCRYPT") ? this._passwordEncryptors.get("BCRYPT") : (algorithm.startsWith("PBKDF2") ? this._passwordEncryptors.get("PBKDF2") : this._passwordEncryptors.get(algorithm));
        if (passwordEncryptor == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No password encryptor found for " + algorithm));
            }
            passwordEncryptor = this._defaultPasswordEncryptor;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Found " + ClassUtil.getClassName((Object)passwordEncryptor) + " to encrypt password using " + algorithm));
        }
        return passwordEncryptor;
    }
}

