/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.autologin;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AutoLoginFilter
extends BasePortalFilter {
    private static final String _PATH_CHAT_LATEST = "/-/chat/latest";
    private static final Log _log = LogFactoryUtil.getLog(AutoLoginFilter.class);
    private static final Set<AutoLogin> _autoLogins = new CopyOnWriteArraySet<AutoLogin>();
    private static final ServiceTracker<?, AutoLogin> _serviceTracker;

    protected String getLoginRemoteUser(HttpServletRequest request, HttpServletResponse response, HttpSession session, String[] credentials) throws Exception {
        if (credentials == null || credentials.length != 3) {
            return null;
        }
        String jUsername = credentials[0];
        String jPassword = credentials[1];
        boolean encPassword = GetterUtil.getBoolean((String)credentials[2]);
        if (Validator.isNull((String)jUsername) || Validator.isNull((String)jPassword)) {
            return null;
        }
        long userId = GetterUtil.getLong((String)jUsername);
        if (userId <= 0L) {
            return null;
        }
        User user = UserLocalServiceUtil.fetchUserById((long)userId);
        if (user == null || user.isLockout()) {
            return null;
        }
        if (!PropsValues.AUTH_SIMULTANEOUS_LOGINS) {
            AuthenticatedSessionManagerUtil.signOutSimultaneousLogins((long)userId);
        }
        if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            session = AuthenticatedSessionManagerUtil.renewSession((HttpServletRequest)request, (HttpSession)session);
        }
        session.setAttribute("j_username", (Object)jUsername);
        if (encPassword) {
            session.setAttribute("j_password", (Object)jPassword);
        } else {
            session.setAttribute("j_password", (Object)PasswordEncryptorUtil.encrypt((String)jPassword, (String)user.getPassword()));
            if (PropsValues.SESSION_STORE_PASSWORD) {
                session.setAttribute("USER_PASSWORD", (Object)jPassword);
            }
        }
        session.setAttribute("j_remoteuser", (Object)jUsername);
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            String mainPath = PortalUtil.getPathMain();
            String redirect = mainPath.concat("/portal/protected");
            if (PropsValues.AUTH_FORWARD_BY_LAST_PATH) {
                redirect = redirect.concat("?redirect=");
                String autoLoginRedirect = (String)request.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                if (Validator.isNull((String)autoLoginRedirect)) {
                    autoLoginRedirect = PortalUtil.getCurrentCompleteURL((HttpServletRequest)request);
                }
                redirect = redirect.concat(URLCodec.encodeURL((String)autoLoginRedirect));
            }
            response.sendRedirect(redirect);
        }
        return jUsername;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        HttpSession session = request.getSession();
        String host = PortalUtil.getHost((HttpServletRequest)request);
        if (PortalInstances.isAutoLoginIgnoreHost(host)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore host " + host));
            }
            this.processFilter(AutoLoginFilter.class.getName(), request, response, filterChain);
            return;
        }
        String contextPath = PortalUtil.getPathContext();
        String path = StringUtil.toLowerCase((String)request.getRequestURI());
        if (!contextPath.equals("/") && path.contains(contextPath)) {
            path = path.substring(contextPath.length());
        }
        if (PortalInstances.isAutoLoginIgnorePath(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore path " + path));
            }
            this.processFilter(AutoLoginFilter.class.getName(), request, response, filterChain);
            return;
        }
        String remoteUser = request.getRemoteUser();
        String jUserName = (String)session.getAttribute("j_username");
        if (!PropsValues.AUTH_LOGIN_DISABLED && remoteUser == null && jUserName == null) {
            for (AutoLogin autoLogin : _autoLogins) {
                try {
                    String[] credentials = autoLogin.login(request, response);
                    String redirect = (String)request.getAttribute("AUTO_LOGIN_REDIRECT");
                    if (Validator.isNotNull((String)redirect)) {
                        response.sendRedirect(redirect);
                        return;
                    }
                    String loginRemoteUser = this.getLoginRemoteUser(request, response, session, credentials);
                    if (loginRemoteUser == null) continue;
                    request = new ProtectedServletRequest(request, loginRemoteUser);
                    if (PropsValues.PORTAL_JAAS_ENABLE) {
                        return;
                    }
                    redirect = !PropsValues.AUTH_FORWARD_BY_LAST_PATH ? "/c" : (String)request.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                    if (!Validator.isNotNull((String)redirect)) continue;
                    response.sendRedirect(redirect);
                    return;
                }
                catch (Exception e) {
                    StringBundler sb = new StringBundler(6);
                    sb.append("Current URL ");
                    String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                    sb.append(currentURL);
                    sb.append(" generates exception: ");
                    sb.append(e.getMessage());
                    if (_log.isInfoEnabled()) {
                        sb.append(" stack: ");
                        sb.append(StackTraceUtil.getStackTrace((Throwable)e));
                    }
                    if (currentURL.endsWith(_PATH_CHAT_LATEST)) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)sb.toString());
                        continue;
                    }
                    _log.error((Object)sb.toString());
                }
            }
        }
        this.processFilter(AutoLoginFilter.class.getName(), request, response, filterChain);
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(AutoLogin.class, (ServiceTrackerCustomizer)new AutoLoginServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class AutoLoginServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AutoLogin, AutoLogin> {
        private AutoLoginServiceTrackerCustomizer() {
        }

        public AutoLogin addingService(ServiceReference<AutoLogin> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AutoLogin autoLogin = (AutoLogin)registry.getService(serviceReference);
            if (autoLogin == null) {
                return null;
            }
            _autoLogins.add(autoLogin);
            return autoLogin;
        }

        public void modifiedService(ServiceReference<AutoLogin> serviceReference, AutoLogin autoLogin) {
        }

        public void removedService(ServiceReference<AutoLogin> serviceReference, AutoLogin autoLogin) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _autoLogins.remove(autoLogin);
        }
    }
}

