/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class DynamicCSSUtil {
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final Log _log = LogFactoryUtil.getLog(DynamicCSSUtil.class);
    private static final Pattern _pluginThemePattern = Pattern.compile("\\/([^\\/]+)-theme\\/", 2);
    private static final Pattern _portalThemePattern = Pattern.compile("themes\\/([^\\/]+)\\/css", 2);

    public static String replaceToken(ServletContext servletContext, HttpServletRequest request, String content) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = DynamicCSSUtil._getTheme(request);
        if (theme == null) {
            return content;
        }
        return DynamicCSSUtil.replaceToken(servletContext, request, themeDisplay, theme, content);
    }

    public static String replaceToken(ServletContext servletContext, HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme, String parsedContent) throws Exception {
        String portalContextPath = PortalUtil.getPathContext();
        String baseURL = servletContext.getContextPath();
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        parsedContent = StringUtil.replace((String)parsedContent, (String[])new String[]{"@base_url@", "@portal_ctx@", "@theme_image_path@"}, (String[])new String[]{baseURL, portalContextPath, DynamicCSSUtil._getThemeImagesPath(request, themeDisplay, theme)});
        return parsedContent;
    }

    protected static String propagateQueryString(String content, String queryString) {
        StringBuilder sb = new StringBuilder(content.length());
        int pos = 0;
        while (true) {
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            sb.append(content.substring(pos, importX));
            sb.append(_CSS_IMPORT_BEGIN);
            String url = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            char firstChar = url.charAt(0);
            if (firstChar == '\'') {
                sb.append('\'');
            } else if (firstChar == '\"') {
                sb.append('\"');
            }
            url = StringUtil.unquote((String)url);
            sb.append(url);
            if (url.indexOf(63) != -1) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append(queryString);
            if (firstChar == '\'') {
                sb.append('\'');
            } else if (firstChar == '\"') {
                sb.append('\"');
            }
            sb.append(_CSS_IMPORT_END);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    private static Theme _getTheme(HttpServletRequest request) throws Exception {
        String requestURI;
        Matcher portalThemeMatcher;
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String themeId = ParamUtil.getString((HttpServletRequest)request, (String)"themeId");
        if (Validator.isNotNull((String)themeId)) {
            try {
                Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId);
                return theme;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if ((portalThemeMatcher = _portalThemePattern.matcher(requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8"))).find()) {
            String themePathId = portalThemeMatcher.group(1);
            themePathId = StringUtil.replace((String)themePathId, (char)'_', (String)"");
            themeId = PortalUtil.getJsSafePortletId((String)themePathId);
        } else {
            Matcher pluginThemeMatcher = _pluginThemePattern.matcher(requestURI);
            if (pluginThemeMatcher.find()) {
                String themePathId = pluginThemeMatcher.group(1);
                themePathId = StringUtil.replace((String)themePathId, (char)'_', (String)"");
                StringBundler sb = new StringBundler(4);
                sb.append(themePathId);
                sb.append("_WAR_");
                sb.append(themePathId);
                sb.append("theme");
                themePathId = sb.toString();
                themeId = PortalUtil.getJsSafePortletId((String)themePathId);
            }
        }
        if (Validator.isNull((String)themeId)) {
            return null;
        }
        try {
            Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId);
            return theme;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private static String _getThemeImagesPath(HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme) throws Exception {
        String themeImagesPath = null;
        if (themeDisplay != null) {
            themeImagesPath = themeDisplay.getPathThemeImages();
        } else {
            String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)request);
            String themeStaticResourcePath = theme.getStaticResourcePath();
            themeImagesPath = cdnHost + themeStaticResourcePath + theme.getImagesPath();
        }
        return themeImagesPath;
    }
}

