/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.memory.DeleteFileFinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class LiferayFileItem
extends DiskFileItem
implements FileItem {
    public static final long THRESHOLD_SIZE = GetterUtil.getLong((String)PropsUtil.get(LiferayFileItem.class.getName() + ".threshold.size"));
    private static final Log _log = LogFactoryUtil.getLog(LiferayFileItem.class);
    private static int _counter;
    private String _encodedString;
    private String _fileName;
    private final File _repository;
    private final int _sizeThreshold;

    public LiferayFileItem(String fieldName, String contentType, boolean formField, String fileName, int sizeThreshold, File repository) {
        super(fieldName, contentType, formField, fileName, sizeThreshold, repository);
        this._fileName = fileName;
        this._sizeThreshold = sizeThreshold;
        this._repository = repository;
    }

    public String getContentType() {
        try {
            return MimeTypesUtil.getContentType((InputStream)this.getInputStream(), (String)this.getFileName());
        }
        catch (IOException ioe) {
            return "application/octet-stream";
        }
    }

    public String getEncodedString() {
        return this._encodedString;
    }

    public String getFileName() {
        if (this._fileName == null) {
            return null;
        }
        int pos = this._fileName.lastIndexOf("/");
        if (pos == -1) {
            pos = this._fileName.lastIndexOf("\\");
        }
        if (pos == -1) {
            return this._fileName;
        }
        return this._fileName.substring(pos + 1);
    }

    public String getFileNameExtension() {
        return FileUtil.getExtension((String)this._fileName);
    }

    public String getFullFileName() {
        return this._fileName;
    }

    public long getItemSize() {
        String fileName;
        String fieldName;
        long size = this.getSize();
        String contentType = this.getContentType();
        if (contentType != null) {
            byte[] bytes = contentType.getBytes();
            size += (long)bytes.length;
        }
        if ((fieldName = this.getFieldName()) != null) {
            byte[] bytes = fieldName.getBytes();
            size += (long)bytes.length;
        }
        if ((fileName = this.getFileName()) != null) {
            byte[] bytes = fileName.getBytes();
            size += (long)bytes.length;
        }
        return size;
    }

    public int getSizeThreshold() {
        return this._sizeThreshold;
    }

    public File getStoreLocation() {
        if (!ServerDetector.isWebLogic()) {
            return super.getStoreLocation();
        }
        try {
            DeferredFileOutputStream dfos = (DeferredFileOutputStream)this.getOutputStream();
            return dfos.getFile();
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            return null;
        }
    }

    public String getString() {
        if (this.getSize() > THRESHOLD_SIZE) {
            return "";
        }
        if (this._encodedString == null) {
            return super.getString();
        }
        return this._encodedString;
    }

    public void setString(String encode) {
        try {
            this._encodedString = this.getString(encode);
        }
        catch (UnsupportedEncodingException uee) {
            _log.error((Object)uee, (Throwable)uee);
        }
    }

    protected File getTempFile() {
        String tempFileName = "upload_" + LiferayFileItem._getUniqueId();
        String extension = this.getFileNameExtension();
        if (extension != null) {
            tempFileName = tempFileName + "." + extension;
        }
        File tempFile = new File(this._repository, tempFileName);
        FinalizeManager.register((Object)tempFile, (FinalizeAction)new DeleteFileFinalizeAction(tempFile.getAbsolutePath()), (FinalizeManager.ReferenceFactory)FinalizeManager.PHANTOM_REFERENCE_FACTORY);
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _getUniqueId() {
        int current = 0;
        Class<LiferayFileItem> clazz = LiferayFileItem.class;
        synchronized (LiferayFileItem.class) {
            current = _counter++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String id = String.valueOf(current);
            if (current < 100000000) {
                id = ("00000000" + id).substring(id.length());
            }
            return id;
        }
    }
}

