/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletConfigFactory;
import com.liferay.portal.kernel.portlet.PortletContextFactory;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portlet.PortletConfigImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

@DoPrivileged
public class PortletConfigFactoryImpl
implements PortletConfigFactory {
    private final Map<String, Map<String, PortletConfig>> _pool = new ConcurrentHashMap<String, Map<String, PortletConfig>>();
    private PortletContextFactory _portletContextFactory;

    public PortletConfig create(Portlet portlet, ServletContext servletContext) {
        Object portletConfig;
        Map<String, PortletConfig> portletConfigs = this._pool.get(portlet.getRootPortletId());
        if (portletConfigs == null) {
            portletConfigs = new ConcurrentHashMap<String, PortletConfig>();
            this._pool.put(portlet.getRootPortletId(), portletConfigs);
        }
        if ((portletConfig = portletConfigs.get(portlet.getPortletId())) == null) {
            PortletContext portletContext = this._portletContextFactory.create(portlet, servletContext);
            portletConfig = new PortletConfigImpl(portlet, portletContext);
            portletConfigs.put(portlet.getPortletId(), (PortletConfig)portletConfig);
        }
        return DoPrivilegedUtil.wrap(portletConfig);
    }

    public void destroy(Portlet portlet) {
        this._pool.remove(portlet.getRootPortletId());
    }

    public PortletConfig get(Portlet portlet) {
        return this.get(portlet.getPortletId());
    }

    public PortletConfig get(String portletId) {
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        Map<String, PortletConfig> portletConfigs = this._pool.get(rootPortletId);
        if (portletConfigs == null) {
            return null;
        }
        return portletConfigs.get(portletId);
    }

    public void setPortletContextFactory(PortletContextFactory portletContextFactory) {
        this._portletContextFactory = portletContextFactory;
    }

    public PortletConfig update(Portlet portlet) {
        Map<String, PortletConfig> portletConfigs = this._pool.get(portlet.getRootPortletId());
        if (portletConfigs == null) {
            return null;
        }
        Object portletConfig = portletConfigs.get(portlet.getPortletId());
        PortletContext portletContext = portletConfig.getPortletContext();
        portletConfig = new PortletConfigImpl(portlet, portletContext);
        portletConfigs.put(portlet.getPortletId(), (PortletConfig)portletConfig);
        return DoPrivilegedUtil.wrap(portletConfig);
    }
}

