/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.io.SerializableObjectWrapper;
import com.liferay.portal.kernel.portlet.LiferayPortletSession;
import com.liferay.portal.kernel.servlet.HttpSessionWrapper;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletSessionAttributeMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;

public class PortletSessionImpl
implements LiferayPortletSession {
    protected final PortletContext portletContext;
    protected final String scopePrefix;
    protected HttpSession session;

    public PortletSessionImpl(HttpSession session, PortletContext portletContext, String portletName, long plid) {
        this.session = this._wrapHttpSession(session);
        this.portletContext = portletContext;
        StringBundler sb = new StringBundler(5);
        sb.append("javax.portlet.p.");
        sb.append(portletName);
        sb.append("_LAYOUT_");
        sb.append(plid);
        sb.append("?");
        this.scopePrefix = sb.toString();
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        return this.session.getAttribute(name);
    }

    public Map<String, Object> getAttributeMap() {
        return this.getAttributeMap(2);
    }

    public Map<String, Object> getAttributeMap(int scope) {
        if (scope == 2) {
            return new PortletSessionAttributeMap(this.session, this.scopePrefix);
        }
        return new PortletSessionAttributeMap(this.session);
    }

    public Enumeration<String> getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration<String> getAttributeNames(int scope) {
        if (scope != 2) {
            return this.session.getAttributeNames();
        }
        ArrayList<String> attributeNames = new ArrayList<String>();
        Enumeration enu = this.session.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(this.scopePrefix)) continue;
            name = name.substring(this.scopePrefix.length());
            attributeNames.add(name);
        }
        return Collections.enumeration(attributeNames);
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public HttpSession getHttpSession() {
        return this.session;
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        this.session.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        this.session.setAttribute(name, value);
    }

    public void setHttpSession(HttpSession session) {
        this.session = this._wrapHttpSession(session);
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    private HttpSession _wrapHttpSession(HttpSession session) {
        if (PropsValues.PORTLET_SESSION_REPLICATE_ENABLED && !(session instanceof SerializableHttpSessionWrapper)) {
            return new SerializableHttpSessionWrapper(session);
        }
        return session;
    }

    private static class SerializableHttpSessionWrapper
    extends HttpSessionWrapper {
        public Object getAttribute(String name) {
            return SerializableObjectWrapper.unwrap((Object)super.getAttribute(name));
        }

        public void setAttribute(String name, Object value) {
            if (!(value instanceof Serializable)) {
                super.setAttribute(name, value);
                return;
            }
            Class<?> clazz = value.getClass();
            if (!PortalClassLoaderUtil.isPortalClassLoader((ClassLoader)clazz.getClassLoader())) {
                value = new SerializableObjectWrapper((Serializable)value);
            }
            super.setAttribute(name, value);
        }

        private SerializableHttpSessionWrapper(HttpSession session) {
            super(session);
        }
    }
}

