/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.permission;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import java.util.Map;
import java.util.Objects;

@OSGiBeanProperties(property={"model.class.name=com.liferay.blogs.kernel.model.BlogsEntry"})
public class BlogsEntryPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) throws PortalException {
        if (!BlogsEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, BlogsEntry.class.getName(), entry.getEntryId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        if (!BlogsEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, BlogsEntry.class.getName(), entryId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) {
        PermissionCacheKey permissionCacheKey;
        Map permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(permissionCacheKey = new PermissionCacheKey(entry.getEntryId(), actionId));
        if (contains == null) {
            contains = BlogsEntryPermission._contains(permissionChecker, entry, actionId);
            permissionChecksMap.put(permissionCacheKey, contains);
        }
        return contains;
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        PermissionCacheKey permissionCacheKey;
        Map permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(permissionCacheKey = new PermissionCacheKey(entryId, actionId));
        if (contains == null) {
            BlogsEntryCacheKey blogsEntryCacheKey = new BlogsEntryCacheKey(entryId);
            BlogsEntry entry = (BlogsEntry)permissionChecksMap.get(blogsEntryCacheKey);
            if (entry == null) {
                entry = BlogsEntryLocalServiceUtil.getEntry((long)entryId);
                permissionChecksMap.put(blogsEntryCacheKey, entry);
            }
            contains = BlogsEntryPermission._contains(permissionChecker, entry, actionId);
            permissionChecksMap.put(permissionCacheKey, contains);
        }
        return contains;
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        BlogsEntryPermission.check(permissionChecker, primaryKey, actionId);
    }

    private static boolean _contains(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)entry.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (entry.isDraft() || entry.isScheduled()) {
            if (actionId.equals("VIEW") && !BlogsEntryPermission.contains(permissionChecker, entry, "UPDATE")) {
                return false;
            }
        } else if (entry.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)entry.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), actionId);
    }

    private static class PermissionCacheKey {
        private final String _actionId;
        private final long _entryId;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PermissionCacheKey)) {
                return false;
            }
            PermissionCacheKey permissionCacheKey = (PermissionCacheKey)obj;
            return this._entryId == permissionCacheKey._entryId && Objects.equals(this._actionId, permissionCacheKey._actionId);
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (long)this._entryId);
            return HashUtil.hash((int)hash, (Object)this._actionId);
        }

        private PermissionCacheKey(long entryId, String actionId) {
            this._entryId = entryId;
            this._actionId = actionId;
        }
    }

    private static class BlogsEntryCacheKey {
        private final long _entryId;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BlogsEntryCacheKey)) {
                return false;
            }
            BlogsEntryCacheKey blogsEntryCacheKey = (BlogsEntryCacheKey)obj;
            return this._entryId == blogsEntryCacheKey._entryId;
        }

        public int hashCode() {
            return (int)this._entryId;
        }

        private BlogsEntryCacheKey(long entryId) {
            this._entryId = entryId;
        }
    }
}

