/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.spring.context.PortletContextLoaderListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.web.context.ContextLoaderListener;

public class SpringHotDeployListener
extends BaseHotDeployListener {
    private static final Map<String, ContextLoaderListener> _contextLoaderListeners = new HashMap<String, ContextLoaderListener>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error initializing Spring for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error uninitializing Spring for ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        PortletContextLoaderListener contextLoaderListener = new PortletContextLoaderListener();
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader());
            contextLoaderListener.contextInitialized(new ServletContextEvent(servletContext));
        }
        finally {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)contextClassLoader);
        }
        _contextLoaderListeners.put(servletContextName, contextLoaderListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        ContextLoaderListener contextLoaderListener = _contextLoaderListeners.remove(servletContextName);
        if (contextLoaderListener == null) {
            return;
        }
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader());
            contextLoaderListener.contextDestroyed(new ServletContextEvent(servletContext));
        }
        finally {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)contextClassLoader);
        }
    }
}

