/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.repository;

import com.liferay.portal.fabric.netty.fileserver.FileHelperUtil;
import com.liferay.portal.fabric.netty.fileserver.FileRequest;
import com.liferay.portal.fabric.netty.fileserver.FileResponse;
import com.liferay.portal.fabric.netty.util.NettyUtil;
import com.liferay.portal.fabric.repository.Repository;
import com.liferay.portal.fabric.repository.RepositoryHelperUtil;
import com.liferay.portal.kernel.concurrent.AsyncBroker;
import com.liferay.portal.kernel.concurrent.BaseFutureListener;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFutureConverter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyRepository
implements Repository<Channel> {
    protected final AsyncBroker<Path, FileResponse> asyncBroker = new AsyncBroker();
    protected final long getFileTimeout;
    protected final Map<Path, Path> pathMap = new ConcurrentHashMap<Path, Path>();
    protected final Path repositoryPath;
    private static final Log _log = LogFactoryUtil.getLog(NettyRepository.class);

    public NettyRepository(Path repositoryPath, long getFileTimeout) {
        if (repositoryPath == null) {
            throw new NullPointerException("Repository path is null");
        }
        if (!Files.isDirectory(repositoryPath, new LinkOption[0])) {
            throw new IllegalArgumentException(repositoryPath + " is not a directory");
        }
        this.repositoryPath = repositoryPath;
        this.getFileTimeout = getFileTimeout;
    }

    @Override
    public void dispose(boolean delete) {
        Set<Map.Entry<Path, Path>> entrySet = this.pathMap.entrySet();
        Iterator<Map.Entry<Path, Path>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Path, Path> entry = iterator.next();
            iterator.remove();
            FileHelperUtil.delete(true, entry.getValue());
        }
        if (delete) {
            FileHelperUtil.delete(true, this.repositoryPath);
        }
    }

    @Override
    public AsyncBroker<Path, FileResponse> getAsyncBroker() {
        return this.asyncBroker;
    }

    @Override
    public NoticeableFuture<Path> getFile(Channel channel, Path remoteFilePath, Path localFilePath, boolean deleteAfterFetch) {
        if (localFilePath == null) {
            return this.getFile(channel, remoteFilePath, RepositoryHelperUtil.getRepositoryFilePath(this.repositoryPath, remoteFilePath), deleteAfterFetch, true);
        }
        return this.getFile(channel, remoteFilePath, localFilePath, deleteAfterFetch, false);
    }

    @Override
    public NoticeableFuture<Map<Path, Path>> getFiles(Channel channel, Map<Path, Path> pathMap, boolean deleteAfterFetch) {
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        if (pathMap.isEmpty()) {
            defaultNoticeableFuture.set(pathMap);
            return defaultNoticeableFuture;
        }
        final ConcurrentHashMap resultPathMap = new ConcurrentHashMap();
        final AtomicInteger counter = new AtomicInteger(pathMap.size());
        for (Map.Entry<Path, Path> entry : pathMap.entrySet()) {
            final Path remoteFilePath = entry.getKey();
            NoticeableFuture<Path> noticeableFuture = this.getFile(channel, remoteFilePath, entry.getValue(), deleteAfterFetch);
            noticeableFuture.addFutureListener((FutureListener)new BaseFutureListener<Path>(){

                public void completeWithCancel(Future<Path> future) {
                    defaultNoticeableFuture.cancel(true);
                }

                public void completeWithException(Future<Path> future, Throwable throwable) {
                    defaultNoticeableFuture.setException(throwable);
                }

                public void completeWithResult(Future<Path> future, Path localFilePath) {
                    if (localFilePath != null) {
                        resultPathMap.put(remoteFilePath, localFilePath);
                    }
                    if (counter.decrementAndGet() <= 0) {
                        defaultNoticeableFuture.set((Object)resultPathMap);
                    }
                }
            });
        }
        return defaultNoticeableFuture;
    }

    @Override
    public Path getRepositoryPath() {
        return this.repositoryPath;
    }

    protected static long getLastModifiedTime(Path path) {
        if (path == null) {
            return Long.MIN_VALUE;
        }
        try {
            FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            return fileTime.toMillis();
        }
        catch (IOException ioe) {
            return Long.MIN_VALUE;
        }
    }

    protected NoticeableFuture<Path> getFile(Channel channel, final Path remoteFilePath, final Path localFilePath, boolean deleteAfterFetch, final boolean populateCache) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Fetching remote file " + remoteFilePath));
        }
        final Path cachedLocalFilePath = this.pathMap.get(remoteFilePath);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        NoticeableFuture noticeableFuture = this.asyncBroker.post((Object)remoteFilePath, defaultNoticeableFuture);
        if (noticeableFuture == null) {
            noticeableFuture = defaultNoticeableFuture;
            NettyUtil.scheduleCancellation(channel, defaultNoticeableFuture, this.getFileTimeout);
            ChannelFuture channelFuture = channel.writeAndFlush((Object)new FileRequest(remoteFilePath, NettyRepository.getLastModifiedTime(cachedLocalFilePath), deleteAfterFetch));
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    if (channelFuture.isSuccess()) {
                        return;
                    }
                    if (channelFuture.isCancelled()) {
                        defaultNoticeableFuture.cancel(true);
                        return;
                    }
                    IOException throwable = new IOException("Unable to fetch remote file " + remoteFilePath, channelFuture.cause());
                    if (!NettyRepository.this.asyncBroker.takeWithException((Object)remoteFilePath, (Throwable)throwable)) {
                        _log.error((Object)("Unable to place exception because no future exists with ID " + remoteFilePath), (Throwable)throwable);
                    }
                }
            });
        }
        return new NoticeableFutureConverter<Path, FileResponse>(noticeableFuture){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Path convert(FileResponse fileResponse) throws IOException {
                if (fileResponse.isFileNotFound()) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Remote file " + remoteFilePath + " is not found"));
                    }
                    return null;
                }
                if (fileResponse.isFileNotModified()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Remote file " + remoteFilePath + " is not modified, use cached local file " + cachedLocalFilePath));
                    }
                    return cachedLocalFilePath;
                }
                Path targetLocalFilePath = localFilePath;
                FileResponse fileResponse2 = fileResponse;
                synchronized (fileResponse2) {
                    Path tempLocalFilePath;
                    Path recheckCacheLocalFilePath = NettyRepository.this.pathMap.get(remoteFilePath);
                    if (recheckCacheLocalFilePath != null) {
                        targetLocalFilePath = recheckCacheLocalFilePath;
                    }
                    if ((tempLocalFilePath = fileResponse.getLocalFile()).startsWith(NettyRepository.this.repositoryPath)) {
                        Files.copy(fileResponse.getLocalFile(), targetLocalFilePath, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.move(fileResponse.getLocalFile(), targetLocalFilePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (populateCache) {
                        NettyRepository.this.pathMap.put(remoteFilePath, targetLocalFilePath);
                    }
                    fileResponse.setLocalFile(targetLocalFilePath);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Fetched remote file " + remoteFilePath + " to " + targetLocalFilePath));
                }
                return targetLocalFilePath;
            }
        };
    }
}

