/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class JSONArrayImpl
implements JSONArray {
    private static final String _NULL_JSON = "[]";
    private static final Log _log = LogFactoryUtil.getLog(JSONArrayImpl.class);
    private org.json.JSONArray _jsonArray;

    public JSONArrayImpl() {
        this._jsonArray = new org.json.JSONArray();
    }

    public JSONArrayImpl(org.json.JSONArray jsonArray) {
        this._jsonArray = jsonArray;
    }

    public JSONArrayImpl(String json) throws JSONException {
        try {
            if (Validator.isNull((String)json)) {
                json = _NULL_JSON;
            }
            this._jsonArray = new org.json.JSONArray(json);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }

    public Object get(int index) {
        return this._jsonArray.opt(index);
    }

    public boolean getBoolean(int index) {
        return this._jsonArray.optBoolean(index);
    }

    public double getDouble(int index) {
        return this._jsonArray.optDouble(index);
    }

    public int getInt(int index) {
        return this._jsonArray.optInt(index);
    }

    public org.json.JSONArray getJSONArray() {
        return this._jsonArray;
    }

    public JSONArray getJSONArray(int index) {
        org.json.JSONArray jsonArray = this._jsonArray.optJSONArray(index);
        if (jsonArray == null) {
            return null;
        }
        return new JSONArrayImpl(jsonArray);
    }

    public JSONObject getJSONObject(int index) {
        org.json.JSONObject jsonObj = this._jsonArray.optJSONObject(index);
        if (jsonObj == null) {
            return null;
        }
        return new JSONObjectImpl(jsonObj);
    }

    public long getLong(int index) {
        return this._jsonArray.optLong(index);
    }

    public String getString(int index) {
        return this._jsonArray.optString(index);
    }

    public boolean isNull(int index) {
        return this._jsonArray.isNull(index);
    }

    public Iterator<Object> iterator() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.length(); ++i) {
            list.add(this.get(i));
        }
        return list.iterator();
    }

    public String join(String separator) throws JSONException {
        try {
            return this._jsonArray.join(separator);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }

    public int length() {
        return this._jsonArray.length();
    }

    public JSONArray put(boolean value) {
        this._jsonArray.put(value);
        return this;
    }

    public JSONArray put(double value) {
        block2: {
            try {
                this._jsonArray.put(value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONArray put(int value) {
        this._jsonArray.put(value);
        return this;
    }

    public JSONArray put(JSONArray value) {
        this._jsonArray.put((Object)((JSONArrayImpl)value).getJSONArray());
        return this;
    }

    public JSONArray put(JSONObject value) {
        this._jsonArray.put((Object)((JSONObjectImpl)value).getJSONObject());
        return this;
    }

    public JSONArray put(long value) {
        this._jsonArray.put((Object)String.valueOf(value));
        return this;
    }

    public JSONArray put(Object value) {
        this._jsonArray.put(value);
        return this;
    }

    public JSONArray put(String value) {
        this._jsonArray.put((Object)value);
        return this;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        try {
            this._jsonArray = new org.json.JSONArray(objectInput.readUTF());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String toJSONString() {
        return this.toString();
    }

    public String toString() {
        return this._jsonArray.toString();
    }

    public String toString(int indentFactor) throws JSONException {
        try {
            return this._jsonArray.toString(indentFactor);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            return this._jsonArray.write(writer);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.toString());
    }
}

