/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice.action;

import com.liferay.portal.json.data.FileData;
import com.liferay.portal.json.transformer.BeanAnalyzerTransformer;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.javadoc.JavadocMethod;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jodd.util.ReflectUtil;

public class JSONWebServiceDiscoverAction
implements JSONWebServiceAction {
    private final String _basePath;
    private final String _baseURL;
    private final String _contextName;
    private final JSONWebServiceNaming _jsonWebServiceNaming;
    private final List<Class<?>> _types = new ArrayList();

    public JSONWebServiceDiscoverAction(HttpServletRequest request) {
        this._basePath = request.getServletPath();
        this._baseURL = String.valueOf(request.getRequestURL());
        ServletContext servletContext = request.getServletContext();
        this._contextName = GetterUtil.getString((String)ParamUtil.getString((HttpServletRequest)request, (String)"contextName", (String)servletContext.getServletContextName()));
        this._jsonWebServiceNaming = JSONWebServiceActionsManagerUtil.getJSONWebServiceNaming();
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return null;
    }

    public Object invoke() throws Exception {
        LinkedHashMap<String, Object> resultsMap = new LinkedHashMap<String, Object>();
        resultsMap.put("contextName", this._contextName);
        resultsMap.put("basePath", this._basePath);
        resultsMap.put("baseURL", this._baseURL);
        resultsMap.put("services", this._buildJsonWebServiceActionMappingMaps());
        resultsMap.put("types", this._buildTypes());
        resultsMap.put("version", ReleaseInfo.getVersion());
        return new DiscoveryContent(resultsMap);
    }

    private List<Map<String, Object>> _buildJsonWebServiceActionMappingMaps() {
        List jsonWebServiceActionMappings = JSONWebServiceActionsManagerUtil.getJSONWebServiceActionMappings((String)this._contextName);
        ArrayList<Map<String, Object>> jsonWebServiceActionMappingMaps = new ArrayList<Map<String, Object>>(jsonWebServiceActionMappings.size());
        for (JSONWebServiceActionMapping jsonWebServiceActionMapping : jsonWebServiceActionMappings) {
            String returnComment;
            String methodComment;
            JavadocMethod javadocMethod;
            String path = jsonWebServiceActionMapping.getPath();
            LinkedHashMap<String, Object> jsonWebServiceActionMappingMap = new LinkedHashMap<String, Object>();
            if (jsonWebServiceActionMapping.isDeprecated()) {
                jsonWebServiceActionMappingMap.put("deprecated", Boolean.TRUE);
            }
            if ((javadocMethod = JavadocManagerUtil.lookupJavadocMethod((Method)jsonWebServiceActionMapping.getRealActionMethod())) != null && (methodComment = javadocMethod.getComment()) != null) {
                jsonWebServiceActionMappingMap.put("description", javadocMethod.getComment());
            }
            jsonWebServiceActionMappingMap.put("method", jsonWebServiceActionMapping.getMethod());
            jsonWebServiceActionMappingMap.put("name", this._getName(jsonWebServiceActionMapping));
            MethodParameter[] methodParameters = jsonWebServiceActionMapping.getMethodParameters();
            ArrayList parametersList = new ArrayList(methodParameters.length);
            for (int i = 0; i < methodParameters.length; ++i) {
                String parameterComment;
                MethodParameter methodParameter = methodParameters[i];
                Class[] genericTypes = methodParameter.getGenericTypes();
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                if (javadocMethod != null && !Validator.isBlank((String)(parameterComment = javadocMethod.getParameterComment(i)))) {
                    parameterMap.put("description", parameterComment);
                }
                parameterMap.put("name", methodParameter.getName());
                parameterMap.put("type", this._formatType(methodParameter.getType(), genericTypes, false));
                parametersList.add(parameterMap);
            }
            jsonWebServiceActionMappingMap.put("parameters", parametersList);
            jsonWebServiceActionMappingMap.put("path", path);
            LinkedHashMap<String, String> returnsMap = new LinkedHashMap<String, String>();
            if (javadocMethod != null && !Validator.isBlank((String)(returnComment = javadocMethod.getReturnComment()))) {
                returnsMap.put("description", returnComment);
            }
            Method actionMethod = jsonWebServiceActionMapping.getActionMethod();
            returnsMap.put("type", this._formatType(actionMethod.getReturnType(), this._getGenericReturnTypes(jsonWebServiceActionMapping), true));
            jsonWebServiceActionMappingMap.put("returns", returnsMap);
            jsonWebServiceActionMappingMaps.add(jsonWebServiceActionMappingMap);
        }
        return jsonWebServiceActionMappingMaps;
    }

    private List<Map<String, String>> _buildPropertiesList(Class<?> type) {
        try {
            BeanAnalyzerTransformer beanAnalyzerTransformer = new BeanAnalyzerTransformer(type){

                @Override
                protected String getTypeName(Class<?> type) {
                    return JSONWebServiceDiscoverAction.this._formatType(type, null, false);
                }
            };
            return beanAnalyzerTransformer.collect();
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Map<String, Object>> _buildTypes() {
        ArrayList<Map<String, Object>> types = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this._types.size(); ++i) {
            List<Map<String, String>> propertiesList;
            Class<?> type = this._types.get(i);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            types.add(map);
            Class<?> modelType = type;
            if (type.isInterface()) {
                try {
                    Class<?> clazz = this.getClass();
                    ClassLoader classLoader = clazz.getClassLoader();
                    String modelImplClassName = this._jsonWebServiceNaming.convertModelClassToImplClassName(type);
                    modelType = classLoader.loadClass(modelImplClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            if (modelType.isInterface() || Modifier.isAbstract(modelType.getModifiers())) {
                map.put("interface", Boolean.TRUE);
            }
            if ((propertiesList = this._buildPropertiesList(modelType)) != null) {
                map.put("properties", propertiesList);
            }
            map.put("type", type.getName());
        }
        return types;
    }

    private String _formatType(Class<?> type, Class<?>[] genericTypes, boolean returnType) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return this._formatType(componentType, genericTypes, returnType) + "[]";
        }
        if (type.isPrimitive()) {
            return type.getSimpleName();
        }
        if (type.equals(Boolean.class)) {
            return "boolean";
        }
        if (type.equals(Class.class)) {
            if (!returnType) {
                return "string";
            }
        } else {
            if (type.equals(Date.class)) {
                return "long";
            }
            if (type.equals(File.class)) {
                if (!returnType) {
                    return "file";
                }
                type = FileData.class;
            } else {
                if (type.equals(Locale.class) || type.equals(String.class) || type.equals(TimeZone.class)) {
                    return "string";
                }
                if (type.equals(Object.class) || type.equals(Serializable.class)) {
                    return "map";
                }
                if (ReflectUtil.isTypeOf(type, Number.class)) {
                    String typeName = null;
                    typeName = type == Character.class ? "char" : (type == Integer.class ? "int" : StringUtil.toLowerCase((String)type.getSimpleName()));
                    return typeName;
                }
            }
        }
        String typeName = type.getName();
        if (type == Collection.class || ReflectUtil.isTypeOf(type, List.class)) {
            typeName = "list";
        } else if (ReflectUtil.isTypeOf(type, Map.class)) {
            typeName = "map";
        } else if (!this._types.contains(type)) {
            this._types.add(type);
        }
        if (genericTypes == null) {
            return typeName;
        }
        StringBundler sb = new StringBundler(genericTypes.length * 2 + 1);
        sb.append("<");
        for (int i = 0; i < genericTypes.length; ++i) {
            Class<?> genericType = genericTypes[i];
            if (i != 0) {
                sb.append(",");
            }
            if (genericType == null) {
                sb.append("*");
                continue;
            }
            sb.append(this._formatType(genericType, null, returnType));
        }
        sb.append(">");
        return typeName + sb.toString();
    }

    private Class<?>[] _getGenericReturnTypes(JSONWebServiceActionMapping jsonWebServiceActionMapping) {
        Method realActionMethod = jsonWebServiceActionMapping.getRealActionMethod();
        Type genericReturnType = realActionMethod.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
        Type[] genericTypes = parameterizedType.getActualTypeArguments();
        Class[] genericReturnTypes = new Class[genericTypes.length];
        for (int i = 0; i < genericTypes.length; ++i) {
            Type genericType = genericTypes[i];
            genericReturnTypes[i] = ReflectUtil.getRawType((Type)genericType, (Class)jsonWebServiceActionMapping.getActionClass());
        }
        return genericReturnTypes;
    }

    private String _getName(JSONWebServiceActionMapping jsonWebServiceActionMapping) {
        Class clazz = jsonWebServiceActionMapping.getActionClass();
        String className = this._jsonWebServiceNaming.convertServiceClassToSimpleName(clazz);
        Method method = jsonWebServiceActionMapping.getRealActionMethod();
        return className.concat("#").concat(method.getName());
    }

    public static class DiscoveryContent
    implements JSONSerializable {
        private final Map<String, Object> _resultsMap;

        public DiscoveryContent(Map<String, Object> resultsMap) {
            this._resultsMap = resultsMap;
        }

        public String toJSONString() {
            JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
            jsonSerializer.include(new String[]{"types"});
            return jsonSerializer.serializeDeep(this._resultsMap);
        }
    }
}

