/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.util.StringPlus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class MVCPortletAuthTokenWhitelist
extends BaseAuthTokenWhitelist {
    private final Set<String> _portletCSRFWhitelist = new ConcurrentHashSet();
    private final Set<String> _portletInvocationWhitelistAction = new ConcurrentHashSet();
    private final Set<String> _portletInvocationWhitelistRender = new ConcurrentHashSet();
    private final Set<String> _portletInvocationWhitelistResource = new ConcurrentHashSet();

    public MVCPortletAuthTokenWhitelist() {
        this.trackWhitelistServices("auth.token.ignore.mvc.action", MVCActionCommand.class, this._portletCSRFWhitelist);
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.mvc.action", MVCActionCommand.class, this._portletInvocationWhitelistAction);
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.mvc.action", MVCRenderCommand.class, this._portletInvocationWhitelistRender);
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.mvc.action", MVCResourceCommand.class, this._portletInvocationWhitelistResource);
    }

    public boolean isPortletCSRFWhitelisted(HttpServletRequest request, Portlet portlet) {
        String portletId = portlet.getPortletId();
        String[] mvcActionCommandNames = this.getMVCActionCommandNames(request, portletId);
        return this._containsAll(portletId, this._portletCSRFWhitelist, mvcActionCommandNames);
    }

    public boolean isPortletInvocationWhitelisted(HttpServletRequest request, Portlet portlet) {
        String portletId = portlet.getPortletId();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isLifecycleAction()) {
            String[] mvcActionCommandNames = this.getMVCActionCommandNames(request, portletId);
            return this._containsAll(portletId, this._portletInvocationWhitelistAction, mvcActionCommandNames);
        }
        if (themeDisplay.isLifecycleRender()) {
            String namespace = PortalUtil.getPortletNamespace((String)portletId);
            String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)(namespace + "mvcRenderCommandName"));
            return this._contains(portletId, this._portletInvocationWhitelistRender, mvcRenderCommandName);
        }
        if (themeDisplay.isLifecycleResource()) {
            String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
            if (!portletId.equals(ppid)) {
                return false;
            }
            String mvcResourceCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_resource_id");
            return this._contains(portletId, this._portletInvocationWhitelistResource, mvcResourceCommandName);
        }
        return false;
    }

    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String[] mvcActionCommandNames = this.getMVCActionCommandNames(liferayPortletURL);
        return this._containsAll(liferayPortletURL.getPortletId(), this._portletCSRFWhitelist, mvcActionCommandNames);
    }

    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        String portletId = liferayPortletURL.getPortletId();
        String lifecycle = liferayPortletURL.getLifecycle();
        if (lifecycle.equals("ACTION_PHASE")) {
            String[] mvcActionCommandNames = this.getMVCActionCommandNames(liferayPortletURL);
            return this._containsAll(portletId, this._portletInvocationWhitelistAction, mvcActionCommandNames);
        }
        if (lifecycle.equals("RENDER_PHASE")) {
            String mvcRenderCommandName = liferayPortletURL.getParameter("mvcRenderCommandName");
            return this._contains(portletId, this._portletInvocationWhitelistRender, mvcRenderCommandName);
        }
        if (lifecycle.equals("RESOURCE_PHASE")) {
            String mvcResourceCommandName = liferayPortletURL.getResourceID();
            return this._contains(portletId, this._portletInvocationWhitelistResource, mvcResourceCommandName);
        }
        return false;
    }

    protected String[] getMVCActionCommandNames(HttpServletRequest request, String portletId) {
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        Object[] actionNames = ParamUtil.getParameterValues((HttpServletRequest)request, (String)(namespace + "javax.portlet.action"));
        String actions = StringUtil.merge((Object[])actionNames);
        return StringUtil.split((String)actions);
    }

    protected String[] getMVCActionCommandNames(LiferayPortletURL liferayPortletURL) {
        Map parameterMap = liferayPortletURL.getParameterMap();
        Object[] actionNames = (String[])parameterMap.get("javax.portlet.action");
        String actions = StringUtil.merge((Object[])actionNames);
        return StringUtil.split((String)actions);
    }

    protected String getWhitelistValue(String portletName, String whitelistAction) {
        return portletName + "#" + whitelistAction;
    }

    protected void trackWhitelistServices(String whitelistName, Class<?> serviceClass, Set<String> whiteList) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceTracker serviceTracker = registry.trackServices(registry.getFilter("(&(&(" + whitelistName + "=*)(javax.portlet.name=*))" + "(objectClass=" + serviceClass.getName() + "))"), (ServiceTrackerCustomizer)new TokenWhitelistTrackerCustomizer(whiteList));
        serviceTracker.open();
        this.serviceTrackers.add(serviceTracker);
    }

    private boolean _contains(String portletId, Set<String> whitelist, String item) {
        if (Validator.isBlank((String)item)) {
            return false;
        }
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        return whitelist.contains(this.getWhitelistValue(rootPortletId, item));
    }

    private boolean _containsAll(String portletId, Set<String> whitelist, String[] items) {
        if (items.length == 0) {
            return false;
        }
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        for (String action : items) {
            if (whitelist.contains(this.getWhitelistValue(rootPortletId, action))) continue;
            return false;
        }
        return true;
    }

    private class TokenWhitelistTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final Set<String> _whitelist;

        public TokenWhitelistTrackerCustomizer(Set<String> whitelist) {
            this._whitelist = whitelist;
        }

        public Object addingService(ServiceReference<Object> serviceReference) {
            ArrayList<String> whitelistValues = new ArrayList<String>();
            List whitelistActions = StringPlus.asList((Object)serviceReference.getProperty("mvc.command.name"));
            List portletNames = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.name"));
            for (String portletName : portletNames) {
                for (String whitelistAction : whitelistActions) {
                    whitelistValues.add(MVCPortletAuthTokenWhitelist.this.getWhitelistValue(portletName, whitelistAction));
                }
            }
            this._whitelist.addAll(whitelistValues);
            return whitelistValues;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
            this.removedService(serviceReference, object);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            Collection whitelistValues = (Collection)object;
            this._whitelist.removeAll(whitelistValues);
        }
    }
}

