/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.AccountNameException;
import com.liferay.portal.kernel.exception.CompanyMxException;
import com.liferay.portal.kernel.exception.CompanyVirtualHostException;
import com.liferay.portal.kernel.exception.CompanyWebIdException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredCompanyException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.instance.lifecycle.PortalInstanceLifecycleManager;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PortalPreferences;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.AssetEntriesFacet;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.ScopeFacet;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcher;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcherManager;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcherManagerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.service.base.CompanyLocalServiceBaseImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class CompanyLocalServiceImpl
extends CompanyLocalServiceBaseImpl {
    private static final String _DEFAULT_VIRTUAL_HOST = "localhost";
    private static final Log _log = LogFactoryUtil.getLog(CompanyLocalServiceImpl.class);
    @BeanReference(type=CompanyProviderWrapper.class)
    private CompanyProviderWrapper _companyProviderWrapper;
    private final Set<Company> _pendingCompanies = new HashSet<Company>();
    private final ServiceTracker<PortalInstanceLifecycleManager, PortalInstanceLifecycleManager> _serviceTracker;

    public CompanyLocalServiceImpl() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(PortalInstanceLifecycleManager.class, (ServiceTrackerCustomizer)new PortalInstanceLifecycleManagerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public Company addCompany(String webId, String virtualHostname, String mx, boolean system, int maxUsers, boolean active) throws PortalException {
        virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
        if (Validator.isNull((String)webId) || webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID) || this.companyPersistence.fetchByWebId(webId) != null) {
            throw new CompanyWebIdException();
        }
        this.validateVirtualHost(webId, virtualHostname);
        this.validateMx(mx);
        Company company = this.checkCompany(webId, mx);
        company = this.companyPersistence.fetchByPrimaryKey(company.getCompanyId());
        company.setMx(mx);
        company.setSystem(system);
        company.setMaxUsers(maxUsers);
        company.setActive(active);
        this.companyPersistence.update((BaseModel)company);
        company = this.updateVirtualHostname(company.getCompanyId(), virtualHostname);
        return company;
    }

    public Company checkCompany(String webId) throws PortalException {
        String mx = webId;
        return this.companyLocalService.checkCompany(webId, mx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(isolation=Isolation.PORTAL, rollbackFor={PortalException.class, SystemException.class})
    public Company checkCompany(String webId, String mx) throws PortalException {
        Date now = new Date();
        Company company = this.companyPersistence.fetchByWebId(webId);
        if (company == null) {
            long companyId = this.counterLocalService.increment();
            company = this.companyPersistence.create(companyId);
            try {
                company.setKey(Encryptor.serializeKey((Key)Encryptor.generateKey()));
            }
            catch (EncryptorException ee) {
                throw new SystemException((Throwable)ee);
            }
            company.setWebId(webId);
            company.setMx(mx);
            company.setActive(true);
            company = (Company)this.companyPersistence.update((BaseModel)company);
            String name = webId;
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                name = PropsValues.COMPANY_DEFAULT_NAME;
            }
            String legalName = null;
            String legalId = null;
            String legalType = null;
            String sicCode = null;
            String tickerSymbol = null;
            String industry = null;
            String type = null;
            String size = null;
            this.updateAccount(company, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                company = this.updateVirtualHostname(companyId, _DEFAULT_VIRTUAL_HOST);
            }
            if (webId.equals("liferay.net")) {
                company = this.companyPersistence.findByWebId(webId);
                this.updateVirtualHostname(companyId, "demo.liferay.net");
                this.updateSecurity(companyId, "emailAddress", true, true, true, true, false, true);
                PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
                try {
                    preferences.setValue("admin.email.from.name", "Liferay Demo");
                    preferences.setValue("admin.email.from.address", "test@liferay.net");
                    preferences.store();
                }
                catch (IOException ioe) {
                    throw new SystemException((Throwable)ioe);
                }
                catch (PortletException pe) {
                    throw new SystemException((Throwable)pe);
                }
            }
        }
        this.preregisterCompany(company.getCompanyId());
        CompanyProvider currentCompanyProvider = this._companyProviderWrapper.getCompanyProvider();
        Locale localeThreadLocalDefaultLocale = LocaleThreadLocal.getDefaultLocale();
        try {
            Locale companyDefaultLocale = LocaleUtil.fromLanguageId((String)PropsValues.COMPANY_DEFAULT_LOCALE);
            LocaleThreadLocal.setDefaultLocale((Locale)companyDefaultLocale);
            long companyId = company.getCompanyId();
            this._companyProviderWrapper.setCompanyProvider((CompanyProvider)new CustomCompanyProvider(companyId));
            this.checkCompanyKey(companyId);
            User defaultUser = this.userPersistence.fetchByC_DU(companyId, true);
            if (defaultUser != null) {
                if (!defaultUser.isAgreedToTermsOfUse()) {
                    defaultUser.setAgreedToTermsOfUse(true);
                    this.userPersistence.update((BaseModel)defaultUser);
                }
            } else {
                long userId = this.counterLocalService.increment();
                defaultUser = this.userPersistence.create(userId);
                defaultUser.setCompanyId(companyId);
                defaultUser.setDefaultUser(true);
                defaultUser.setContactId(this.counterLocalService.increment());
                defaultUser.setPassword("password");
                defaultUser.setScreenName(String.valueOf(defaultUser.getUserId()));
                defaultUser.setEmailAddress("default@" + company.getMx());
                defaultUser.setLanguageId(LocaleUtil.toLanguageId((Locale)companyDefaultLocale));
                if (Validator.isNotNull((String)PropsValues.COMPANY_DEFAULT_TIME_ZONE)) {
                    defaultUser.setTimeZoneId(PropsValues.COMPANY_DEFAULT_TIME_ZONE);
                } else {
                    TimeZone timeZone = TimeZoneUtil.getDefault();
                    defaultUser.setTimeZoneId(timeZone.getID());
                }
                String greeting = LanguageUtil.format((Locale)defaultUser.getLocale(), (String)"welcome", null, (boolean)false);
                defaultUser.setGreeting(greeting + "!");
                defaultUser.setLoginDate(now);
                defaultUser.setFailedLoginAttempts(0);
                defaultUser.setAgreedToTermsOfUse(true);
                defaultUser.setStatus(0);
                this.userPersistence.update((BaseModel)defaultUser);
                Contact defaultContact = this.contactPersistence.create(defaultUser.getContactId());
                defaultContact.setCompanyId(defaultUser.getCompanyId());
                defaultContact.setUserId(defaultUser.getUserId());
                defaultContact.setUserName("");
                defaultContact.setClassName(User.class.getName());
                defaultContact.setClassPK(defaultUser.getUserId());
                defaultContact.setAccountId(company.getAccountId());
                defaultContact.setParentContactId(0L);
                defaultContact.setEmailAddress(defaultUser.getEmailAddress());
                defaultContact.setFirstName("");
                defaultContact.setMiddleName("");
                defaultContact.setLastName("");
                defaultContact.setMale(true);
                defaultContact.setBirthday(now);
                this.contactPersistence.update((BaseModel)defaultContact);
            }
            this.roleLocalService.checkSystemRoles(companyId);
            this.groupLocalService.checkSystemGroups(companyId);
            this.groupLocalService.checkCompanyGroup(companyId);
            this.passwordPolicyLocalService.checkDefaultPasswordPolicy(companyId);
            Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
            this.roleLocalService.setUserRoles(defaultUser.getUserId(), new long[]{guestRole.getRoleId()});
            if (this.userPersistence.countByCompanyId(companyId) == 1) {
                String emailAddress = PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + mx;
                this.userLocalService.addDefaultAdminUser(companyId, PropsValues.DEFAULT_ADMIN_SCREEN_NAME, emailAddress, defaultUser.getLocale(), PropsValues.DEFAULT_ADMIN_FIRST_NAME, PropsValues.DEFAULT_ADMIN_MIDDLE_NAME, PropsValues.DEFAULT_ADMIN_LAST_NAME);
            }
            this.portletLocalService.checkPortlets(companyId);
            final Company finalCompany = company;
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CompanyLocalServiceImpl.this.registerCompany(finalCompany);
                    return null;
                }
            });
        }
        finally {
            this._companyProviderWrapper.setCompanyProvider(currentCompanyProvider);
            LocaleThreadLocal.setDefaultLocale((Locale)localeThreadLocalDefaultLocale);
        }
        return company;
    }

    public void checkCompanyKey(long companyId) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.getKeyObj() != null) {
            return;
        }
        try {
            company.setKey(Encryptor.serializeKey((Key)Encryptor.generateKey()));
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        this.companyPersistence.update((BaseModel)company);
    }

    @Override
    public Company deleteCompany(Company company) throws PortalException {
        return this.deleteCompany(company.getCompanyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Company deleteCompany(long companyId) throws PortalException {
        if (companyId == PortalInstances.getDefaultCompanyId()) {
            throw new RequiredCompanyException();
        }
        Long currentCompanyId = CompanyThreadLocal.getCompanyId();
        boolean deleteInProcess = CompanyThreadLocal.isDeleteInProcess();
        try {
            CompanyThreadLocal.setCompanyId((Long)companyId);
            CompanyThreadLocal.setDeleteInProcess((boolean)true);
            Company company = this.doDeleteCompany(companyId);
            return company;
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)currentCompanyId);
            CompanyThreadLocal.setDeleteInProcess((boolean)deleteInProcess);
        }
    }

    public Company deleteLogo(long companyId) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        PortalUtil.updateImageId((BaseModel)company, (boolean)false, null, (String)"logoId", (long)0L, (int)0, (int)0);
        return company;
    }

    public Company fetchCompanyById(long companyId) {
        return this.companyPersistence.fetchByPrimaryKey(companyId);
    }

    public Company fetchCompanyByVirtualHost(String virtualHostname) {
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim()));
        if (virtualHost == null || virtualHost.getLayoutSetId() != 0L) {
            return null;
        }
        return this.companyPersistence.fetchByPrimaryKey(virtualHost.getCompanyId());
    }

    public List<Company> getCompanies() {
        return this.companyPersistence.findAll();
    }

    public List<Company> getCompanies(boolean system) {
        return this.companyPersistence.findBySystem(system);
    }

    public List<Company> getCompanies(boolean system, int start, int end) {
        return this.companyPersistence.findBySystem(system, start, end);
    }

    public int getCompaniesCount(boolean system) {
        return this.companyPersistence.countBySystem(system);
    }

    public Company getCompanyById(long companyId) throws PortalException {
        return this.companyPersistence.findByPrimaryKey(companyId);
    }

    public Company getCompanyByLogoId(long logoId) throws PortalException {
        return this.companyPersistence.findByLogoId(logoId);
    }

    public Company getCompanyByMx(String mx) throws PortalException {
        return this.companyPersistence.findByMx(mx);
    }

    public Company getCompanyByVirtualHost(String virtualHostname) throws PortalException {
        try {
            virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
            VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname);
            if (virtualHost.getLayoutSetId() != 0L) {
                throw new CompanyVirtualHostException("Virtual host is associated with layout set " + virtualHost.getLayoutSetId());
            }
            return this.companyPersistence.findByPrimaryKey(virtualHost.getCompanyId());
        }
        catch (NoSuchVirtualHostException nsvhe) {
            throw new CompanyVirtualHostException((Throwable)nsvhe);
        }
    }

    public Company getCompanyByWebId(String webId) throws PortalException {
        return this.companyPersistence.findByWebId(webId);
    }

    public long getCompanyIdByUserId(long userId) throws Exception {
        long companyId;
        block5: {
            long[] companyIds = PortalInstances.getCompanyIds();
            companyId = 0L;
            if (companyIds.length == 1) {
                companyId = companyIds[0];
            } else if (companyIds.length > 1) {
                try {
                    User user = this.userPersistence.findByPrimaryKey(userId);
                    companyId = user.getCompanyId();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to get the company id for user " + userId), (Throwable)e);
                }
            }
        }
        return companyId;
    }

    public void removePreferences(long companyId, String[] keys) {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            for (String key : keys) {
                preferences.reset(key);
            }
            preferences.store();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long userId, String keywords, int start, int end) {
        return this.search(companyId, userId, null, 0L, null, keywords, start, end);
    }

    public Hits search(long companyId, long userId, String portletId, long groupId, String type, String keywords, int start, int end) {
        FacetedSearcherManager facetedSearcherManager = FacetedSearcherManagerUtil.getFacetedSearcherManager();
        FacetedSearcher facetedSearcher = facetedSearcherManager.createFacetedSearcher();
        SearchContext searchContext = this.createSearchContext(companyId, userId, portletId, groupId, keywords, start, end);
        this.addAssetEntriesFacet(searchContext);
        this.addScopeFacet(searchContext);
        try {
            return facetedSearcher.search(searchContext);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, int maxUsers, boolean active) throws PortalException {
        virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
        if (!active && companyId == PortalInstances.getDefaultCompanyId()) {
            active = true;
        }
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validateVirtualHost(company.getWebId(), virtualHostname);
        if (PropsValues.MAIL_MX_UPDATE) {
            this.validateMx(mx);
            company.setMx(mx);
        }
        company.setMaxUsers(maxUsers);
        company.setActive(active);
        this.companyPersistence.update((BaseModel)company);
        company = this.updateVirtualHostname(companyId, virtualHostname);
        return company;
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, String homeURL, boolean logo, byte[] logoBytes, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException {
        virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validateVirtualHost(company.getWebId(), virtualHostname);
        if (PropsValues.MAIL_MX_UPDATE) {
            this.validateMx(mx);
        }
        this.validateName(companyId, name);
        if (PropsValues.MAIL_MX_UPDATE) {
            company.setMx(mx);
        }
        company.setHomeURL(homeURL);
        PortalUtil.updateImageId((BaseModel)company, (boolean)logo, (byte[])logoBytes, (String)"logoId", (long)0L, (int)0, (int)0);
        this.companyPersistence.update((BaseModel)company);
        this.updateAccount(company, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
        company = this.updateVirtualHostname(companyId, virtualHostname);
        return company;
    }

    @Deprecated
    public Company updateCompany(long companyId, String virtualHostname, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException {
        return this.updateCompany(companyId, virtualHostname, mx, homeURL, true, null, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
    }

    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException {
        User user = this.userLocalService.getDefaultUser(companyId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        this.userPersistence.update((BaseModel)user);
    }

    public Company updateLogo(long companyId, byte[] bytes) throws PortalException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), bytes);
        return company;
    }

    public Company updateLogo(long companyId, File file) throws PortalException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), file);
        return company;
    }

    public Company updateLogo(long companyId, InputStream is) throws PortalException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), is);
        return company;
    }

    public void updatePreferences(long companyId, UnicodeProperties properties) throws PortalException {
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String oldLanguageIds;
            String newLanguageIds = properties.getProperty("locales");
            if (Validator.isNotNull((String)newLanguageIds) && !Objects.equals(oldLanguageIds = portletPreferences.getValue("locales", ""), newLanguageIds)) {
                this.validateLanguageIds(newLanguageIds);
                LanguageUtil.resetAvailableLocales((long)companyId);
                Date now = new Date();
                for (LayoutSetPrototype layoutSetPrototype : this.layoutSetPrototypeLocalService.getLayoutSetPrototypes(companyId)) {
                    layoutSetPrototype.setModifiedDate(now);
                    this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototype);
                }
            }
            ArrayList<String> resetKeys = new ArrayList<String>();
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.equals("TEMP_OBFUSCATION_VALUE")) continue;
                String propsUtilValue = PropsUtil.get(key);
                if (!value.equals(propsUtilValue)) {
                    portletPreferences.setValue(key, value);
                    continue;
                }
                String portletPreferencesValue = portletPreferences.getValue(key, null);
                if (portletPreferencesValue == null) continue;
                resetKeys.add(key);
            }
            for (String key : resetKeys) {
                portletPreferences.reset(key);
            }
            portletPreferences.store();
        }
        catch (LocaleException le) {
            throw le;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        this._clearCompanyCache(companyId);
    }

    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            preferences.setValue("company.security.auth.type", authType);
            preferences.setValue("company.security.auto.login", String.valueOf(autoLogin));
            preferences.setValue("company.security.send.password", String.valueOf(sendPassword));
            preferences.setValue("company.security.strangers", String.valueOf(strangers));
            preferences.setValue("company.security.strangers.with.mx", String.valueOf(strangersWithMx));
            preferences.setValue("company.security.strangers.verify", String.valueOf(strangersVerify));
            preferences.setValue("company.security.site.logo", String.valueOf(siteLogo));
            preferences.store();
        }
        catch (IOException | PortletException e) {
            throw new SystemException(e);
        }
        this._clearCompanyCache(companyId);
    }

    protected void addAssetEntriesFacet(SearchContext searchContext) {
        AssetEntriesFacet assetEntriesFacet = new AssetEntriesFacet(searchContext);
        assetEntriesFacet.setStatic(true);
        searchContext.addFacet((Facet)assetEntriesFacet);
    }

    protected void addScopeFacet(SearchContext searchContext) {
        ScopeFacet scopeFacet = new ScopeFacet(searchContext);
        scopeFacet.setStatic(true);
        searchContext.addFacet((Facet)scopeFacet);
    }

    protected Company checkLogo(long companyId) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId <= 0L) {
            logoId = this.counterLocalService.increment();
            company.setLogoId(logoId);
            company = (Company)this.companyPersistence.update((BaseModel)company);
        }
        return company;
    }

    protected SearchContext createSearchContext(long companyId, long userId, String portletId, long groupId, String keywords, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setEntryClassNames(SearchEngineHelperUtil.getEntryClassNames());
        if (groupId > 0L) {
            searchContext.setGroupIds(new long[]{groupId});
        }
        searchContext.setKeywords(keywords);
        if (Validator.isNotNull((String)portletId)) {
            searchContext.setPortletIds(new String[]{portletId});
        }
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return searchContext;
    }

    protected Company doDeleteCompany(final long companyId) throws PortalException {
        String[] systemGroups;
        final Company company = this.companyPersistence.remove(companyId);
        this.accountLocalService.deleteAccount(company.getAccountId());
        DeleteOrganizationActionableDynamicQuery deleteOrganizationActionableDynamicQuery = new DeleteOrganizationActionableDynamicQuery();
        deleteOrganizationActionableDynamicQuery.setCompanyId(companyId);
        deleteOrganizationActionableDynamicQuery.performActions();
        DeleteGroupActionableDynamicQuery deleteGroupActionableDynamicQuery = new DeleteGroupActionableDynamicQuery();
        deleteGroupActionableDynamicQuery.setCompanyId(companyId);
        deleteGroupActionableDynamicQuery.performActions();
        for (String groupName : systemGroups = PortalUtil.getSystemGroups()) {
            Group group = this.groupLocalService.getGroup(companyId, groupName);
            deleteGroupActionableDynamicQuery.deleteGroup(group);
        }
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        deleteGroupActionableDynamicQuery.deleteGroup(companyGroup);
        ActionableDynamicQuery layoutPrototypeActionableDynamicQuery = this.layoutPrototypeLocalService.getActionableDynamicQuery();
        layoutPrototypeActionableDynamicQuery.setCompanyId(companyId);
        layoutPrototypeActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LayoutPrototype>(){

            public void performAction(LayoutPrototype layoutPrototype) throws PortalException {
                CompanyLocalServiceImpl.this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototype);
            }
        });
        layoutPrototypeActionableDynamicQuery.performActions();
        ActionableDynamicQuery layoutSetPrototypeActionableDynamicQuery = this.layoutSetPrototypeLocalService.getActionableDynamicQuery();
        layoutSetPrototypeActionableDynamicQuery.setCompanyId(companyId);
        layoutSetPrototypeActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LayoutSetPrototype>(){

            public void performAction(LayoutSetPrototype layoutSetPrototype) throws PortalException {
                CompanyLocalServiceImpl.this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototype);
            }
        });
        layoutSetPrototypeActionableDynamicQuery.performActions();
        ActionableDynamicQuery roleActionableDynamicQuery = this.roleLocalService.getActionableDynamicQuery();
        roleActionableDynamicQuery.setCompanyId(companyId);
        roleActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Role>(){

            public void performAction(Role role) throws PortalException {
                CompanyLocalServiceImpl.this.roleLocalService.deleteRole(role);
            }
        });
        roleActionableDynamicQuery.performActions();
        DeleteUserGroupActionableDynamicQuery deleteUserGroupActionableDynamicQuery = new DeleteUserGroupActionableDynamicQuery(company.getCompanyId());
        deleteUserGroupActionableDynamicQuery.performActions();
        this.passwordPolicyLocalService.deleteNondefaultPasswordPolicies(companyId);
        PasswordPolicy defaultPasswordPolicy = this.passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
        if (defaultPasswordPolicy != null) {
            this.passwordPolicyLocalService.deletePasswordPolicy(defaultPasswordPolicy);
        }
        PortalPreferences portalPreferences = this.portalPreferencesPersistence.findByO_O(companyId, 1);
        this.portalPreferencesLocalService.deletePortalPreferences(portalPreferences);
        List portlets = this.portletPersistence.findByCompanyId(companyId);
        for (Portlet portlet : portlets) {
            this.portletLocalService.deletePortlet(portlet.getId());
        }
        this.portletLocalService.removeCompanyPortletsPool(companyId);
        ActionableDynamicQuery userActionableDynamicQuery = this.userLocalService.getActionableDynamicQuery();
        userActionableDynamicQuery.setCompanyId(companyId);
        userActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<User>(){

            public void performAction(User user) throws PortalException {
                if (!user.isDefaultUser()) {
                    CompanyLocalServiceImpl.this.userLocalService.deleteUser(user.getUserId());
                }
            }
        });
        userActionableDynamicQuery.performActions();
        User defaultUser = this.userLocalService.getDefaultUser(companyId);
        this.userLocalService.deleteUser(defaultUser);
        VirtualHost companyVirtualHost = this.virtualHostLocalService.fetchVirtualHost(companyId, 0L);
        this.virtualHostLocalService.deleteVirtualHost(companyVirtualHost);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PortalInstances.removeCompany(companyId);
                CompanyLocalServiceImpl.this.unregisterCompany(company);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
        return company;
    }

    protected void preregisterCompany(long companyId) {
        PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)this._serviceTracker.getService();
        if (portalInstanceLifecycleManager != null) {
            portalInstanceLifecycleManager.preregisterCompany(companyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompany(Company company) {
        PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)this._serviceTracker.getService();
        if (portalInstanceLifecycleManager != null) {
            portalInstanceLifecycleManager.registerCompany(company);
        } else {
            Set<Company> set = this._pendingCompanies;
            synchronized (set) {
                this._pendingCompanies.add(company);
            }
        }
    }

    protected void unregisterCompany(Company company) {
        PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)this._serviceTracker.getService();
        if (portalInstanceLifecycleManager != null) {
            portalInstanceLifecycleManager.unregisterCompany(company);
        }
    }

    protected void updateAccount(Company company, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) {
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            long accountId = this.counterLocalService.increment();
            account = this.accountPersistence.create(accountId);
            account.setCompanyId(company.getCompanyId());
            account.setUserId(0L);
            account.setUserName("");
            company.setAccountId(accountId);
            this.companyPersistence.update((BaseModel)company);
        }
        account.setName(name);
        account.setLegalName(legalName);
        account.setLegalId(legalId);
        account.setLegalType(legalType);
        account.setSicCode(sicCode);
        account.setTickerSymbol(tickerSymbol);
        account.setIndustry(industry);
        account.setType(type);
        account.setSize(size);
        this.accountPersistence.update((BaseModel)account);
    }

    protected Company updateVirtualHostname(long companyId, String virtualHostname) throws CompanyVirtualHostException {
        if (Validator.isNotNull((String)virtualHostname)) {
            VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname);
            if (virtualHost == null) {
                this.virtualHostLocalService.updateVirtualHost(companyId, 0L, virtualHostname);
            } else if (virtualHost.getCompanyId() != companyId || virtualHost.getLayoutSetId() != 0L) {
                throw new CompanyVirtualHostException();
            }
        } else {
            VirtualHost virtualHost = this.virtualHostPersistence.fetchByC_L(companyId, 0L);
            if (virtualHost != null) {
                this.virtualHostPersistence.remove((BaseModel)virtualHost);
            }
        }
        return this.companyPersistence.fetchByPrimaryKey(companyId);
    }

    protected void validateLanguageIds(String languageIds) throws PortalException {
        String[] languageIdsArray;
        for (String languageId : languageIdsArray = StringUtil.split((String)languageIds, (String)",")) {
            if (ArrayUtil.contains((Object[])PropsValues.LOCALES, (Object)languageId)) continue;
            LocaleException le = new LocaleException(1);
            le.setSourceAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])PropsValues.LOCALES)));
            le.setTargetAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])languageIdsArray)));
            throw le;
        }
    }

    protected void validateMx(String mx) throws PortalException {
        if (Validator.isNull((String)mx) || !Validator.isDomain((String)mx)) {
            throw new CompanyMxException();
        }
    }

    protected void validateName(long companyId, String name) throws PortalException {
        Group group = this.groupLocalService.fetchGroup(companyId, name);
        if (group != null || Validator.isNull((String)name)) {
            throw new AccountNameException();
        }
    }

    protected void validateVirtualHost(String webId, String virtualHostname) throws PortalException {
        if (Validator.isNull((String)virtualHostname)) {
            throw new CompanyVirtualHostException();
        }
        if (virtualHostname.equals(_DEFAULT_VIRTUAL_HOST) && !webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new CompanyVirtualHostException();
        }
        if (!Validator.isDomain((String)virtualHostname)) {
            throw new CompanyVirtualHostException();
        }
        try {
            VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname);
            long companyId = virtualHost.getCompanyId();
            Company virtualHostnameCompany = this.companyPersistence.findByPrimaryKey(companyId);
            if (!webId.equals(virtualHostnameCompany.getWebId())) {
                throw new CompanyVirtualHostException();
            }
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {
            // empty catch block
        }
    }

    private void _clearCompanyCache(long companyId) {
        final Company company = this.companyPersistence.fetchByPrimaryKey(companyId);
        if (company != null) {
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    EntityCacheUtil.removeResult((boolean)company.isEntityCacheEnabled(), company.getClass(), (Serializable)company.getPrimaryKeyObj());
                    return null;
                }
            });
            this.companyPersistence.clearCache((BaseModel)company);
        }
    }

    private class PortalInstanceLifecycleManagerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalInstanceLifecycleManager, PortalInstanceLifecycleManager> {
        private PortalInstanceLifecycleManagerServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PortalInstanceLifecycleManager addingService(ServiceReference<PortalInstanceLifecycleManager> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortalInstanceLifecycleManager portalInstanceLifecycleManager = (PortalInstanceLifecycleManager)registry.getService(serviceReference);
            Set set = CompanyLocalServiceImpl.this._pendingCompanies;
            synchronized (set) {
                for (Company company : CompanyLocalServiceImpl.this._pendingCompanies) {
                    portalInstanceLifecycleManager.registerCompany(company);
                }
                CompanyLocalServiceImpl.this._pendingCompanies.clear();
            }
            return portalInstanceLifecycleManager;
        }

        public void modifiedService(ServiceReference<PortalInstanceLifecycleManager> serviceReference, PortalInstanceLifecycleManager portalInstanceLifecycleManager) {
            this.removedService(serviceReference, portalInstanceLifecycleManager);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<PortalInstanceLifecycleManager> serviceReference, PortalInstanceLifecycleManager portalInstanceLifecycleManager) {
        }
    }

    private static class CustomCompanyProvider
    implements CompanyProvider {
        private final long _companyId;

        public CustomCompanyProvider(long companyId) {
            this._companyId = companyId;
        }

        public long getCompanyId() {
            return this._companyId;
        }

        public String getCompanyIdName() {
            return "companyId";
        }
    }

    protected class DeleteUserGroupActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;

        protected DeleteUserGroupActionableDynamicQuery(long companyId) {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.userGroupLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setCompanyId(companyId);
            this._actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<UserGroup>(){

                public void performAction(UserGroup userGroup) throws PortalException {
                    CompanyLocalServiceImpl.this.userGroupLocalService.deleteUserGroup(userGroup);
                }
            });
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }
    }

    protected class DeleteOrganizationActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;
        private long _parentOrganizationId = 0L;

        public void setParentOrganizationId(long parentOrganizationId) {
            this._parentOrganizationId = parentOrganizationId;
        }

        protected DeleteOrganizationActionableDynamicQuery() {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.organizationLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                public void addCriteria(DynamicQuery dynamicQuery) {
                    Property property = PropertyFactoryUtil.forName((String)"parentOrganizationId");
                    dynamicQuery.add(property.eq((Object)DeleteOrganizationActionableDynamicQuery.this._parentOrganizationId));
                }
            });
            this._actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Organization>(){

                public void performAction(Organization organization) throws PortalException {
                    DeleteOrganizationActionableDynamicQuery.this.deleteOrganization(organization);
                }
            });
        }

        protected void deleteOrganization(Organization organization) throws PortalException {
            DeleteOrganizationActionableDynamicQuery deleteOrganizationActionableDynamicQuery = new DeleteOrganizationActionableDynamicQuery();
            deleteOrganizationActionableDynamicQuery.setCompanyId(organization.getCompanyId());
            deleteOrganizationActionableDynamicQuery.setParentOrganizationId(organization.getOrganizationId());
            deleteOrganizationActionableDynamicQuery.performActions();
            CompanyLocalServiceImpl.this.organizationLocalService.deleteOrganization(organization);
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }

        protected void setCompanyId(long companyId) {
            this._actionableDynamicQuery.setCompanyId(companyId);
        }
    }

    protected class DeleteGroupActionableDynamicQuery {
        private ActionableDynamicQuery _actionableDynamicQuery;
        private long _parentGroupId = 0L;

        protected DeleteGroupActionableDynamicQuery() {
            this._actionableDynamicQuery = CompanyLocalServiceImpl.this.groupLocalService.getActionableDynamicQuery();
            this._actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                public void addCriteria(DynamicQuery dynamicQuery) {
                    Property parentGroupIdProperty = PropertyFactoryUtil.forName((String)"parentGroupId");
                    dynamicQuery.add(parentGroupIdProperty.eq((Object)DeleteGroupActionableDynamicQuery.this._parentGroupId));
                    Property siteProperty = PropertyFactoryUtil.forName((String)"site");
                    dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
                }
            });
            this._actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Group>(){

                public void performAction(Group group) throws PortalException {
                    if (!PortalUtil.isSystemGroup((String)group.getGroupKey()) && !group.isCompany()) {
                        DeleteGroupActionableDynamicQuery.this.deleteGroup(group);
                    }
                }
            });
        }

        protected void deleteGroup(Group group) throws PortalException {
            DeleteGroupActionableDynamicQuery deleteGroupActionableDynamicQuery = new DeleteGroupActionableDynamicQuery();
            deleteGroupActionableDynamicQuery.setCompanyId(group.getCompanyId());
            deleteGroupActionableDynamicQuery.setParentGroupId(group.getGroupId());
            deleteGroupActionableDynamicQuery.performActions();
            CompanyLocalServiceImpl.this.groupLocalService.deleteGroup(group);
            LiveUsers.deleteGroup(group.getCompanyId(), group.getGroupId());
        }

        protected void performActions() throws PortalException {
            this._actionableDynamicQuery.performActions();
        }

        protected void setCompanyId(long companyId) {
            this._actionableDynamicQuery.setCompanyId(companyId);
        }

        protected void setParentGroupId(long parentGroupId) {
            this._parentGroupId = parentGroupId;
        }
    }
}

