/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.setup;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang.time.StopWatch;

public class SetupWizardSampleDataUtil {
    private static final Object[][] _ORGANIZATION_ARRAYS = new Object[][]{{"Chicago", 19014L, 19L, "organization", "ORD"}, {"Consulting", 19005L, 19L, "organization"}, {"Dalian", 0L, 2L, "organization", "DLC"}, {"Engineering", 19005L, 19L, "organization"}, {"Frankfurt", 0L, 4L, "organization", "FRA"}, {"Hong Kong", 0L, 2L, "organization", "HKG"}, {"Kuala Lumpur", 0L, 135L, "organization", "KUL"}, {"Los Angeles", 19005L, 19L, "organization", "LAX"}, {"Madrid", 0L, 15L, "organization", "MAD"}, {"Marketing", 19005L, 19L, "organization"}, {"New York", 19033L, 19L, "organization", "NYC"}, {"Saint Paulo", 0L, 48L, "organization", "GRU"}, {"Sales", 19005L, 19L, "organization"}, {"San Francisco", 19005L, 19L, "organization", "SFO"}, {"Support", 19005L, 19L, "organization"}};
    private static final Log _log = LogFactoryUtil.getLog(SetupWizardSampleDataUtil.class);

    public static void addSampleData(long companyId) throws Exception {
        SetupWizardSampleDataUtil.addSampleData(companyId, PropsValues.COMPANY_DEFAULT_NAME, PropsValues.DEFAULT_ADMIN_FIRST_NAME, PropsValues.DEFAULT_ADMIN_LAST_NAME, PropsValues.ADMIN_EMAIL_FROM_NAME, false);
    }

    public static void addSampleData(long companyId, String companyName, String adminUserFirstName, String adminUserLastName, String adminUserEmailAddress, boolean resetPassword) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Adding sample data");
        }
        Company company = SetupWizardSampleDataUtil.updateCompany(CompanyLocalServiceUtil.getCompanyById((long)companyId), companyName, LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
        User adminUser = SetupWizardSampleDataUtil.updateAdminUser(company, LocaleUtil.getDefault(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()), adminUserEmailAddress, adminUserFirstName, adminUserLastName, resetPassword);
        User defaultUser = company.getDefaultUser();
        Account account = company.getAccount();
        Organization organization = OrganizationLocalServiceUtil.addOrganization((long)defaultUser.getUserId(), (long)0L, (String)account.getLegalName(), (boolean)true);
        GroupLocalServiceUtil.updateFriendlyURL((long)organization.getGroupId(), (String)"/main");
        Layout extranetLayout = LayoutLocalServiceUtil.addLayout((long)defaultUser.getUserId(), (long)organization.getGroupId(), (boolean)false, (long)0L, (String)(account.getLegalName() + " Extranet"), null, null, (String)"portlet", (boolean)false, (String)"/extranet", (ServiceContext)new ServiceContext());
        LayoutLocalServiceUtil.updateLayout((long)extranetLayout.getGroupId(), (boolean)false, (long)extranetLayout.getLayoutId(), (String)extranetLayout.getTypeSettings());
        Layout intranetLayout = LayoutLocalServiceUtil.addLayout((long)defaultUser.getUserId(), (long)organization.getGroupId(), (boolean)true, (long)0L, (String)(account.getLegalName() + " Intranet"), null, null, (String)"portlet", (boolean)false, (String)"/intranet", (ServiceContext)new ServiceContext());
        LayoutLocalServiceUtil.updateLayout((long)intranetLayout.getGroupId(), (boolean)true, (long)intranetLayout.getLayoutId(), (String)intranetLayout.getTypeSettings());
        OrganizationLocalServiceUtil.addUserOrganization((long)adminUser.getUserId(), (Organization)organization);
        SetupWizardSampleDataUtil.addOrganizations(companyName, defaultUser, organization);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Finished adding data in " + stopWatch.getTime() + " ms"));
        }
    }

    public static User updateAdminUser(Company company, Locale locale, String languageId, String emailAddress, String firstName, String lastName, boolean resetPassword) throws PortalException {
        ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
        String screenName = GetterUtil.getString((String)PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX, (String)"test");
        try {
            screenName = screenNameGenerator.generate(0L, 0L, emailAddress);
        }
        catch (Exception e) {
            // empty catch block
        }
        User adminUser = UserLocalServiceUtil.fetchUserByEmailAddress((long)company.getCompanyId(), (String)emailAddress);
        if (adminUser != null) {
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String fullName = fullNameGenerator.getFullName(firstName, null, lastName);
            String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)fullName, (boolean)false);
            Contact contact = adminUser.getContact();
            Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
            birthdayCal.setTime(contact.getBirthday());
            int birthdayMonth = birthdayCal.get(2);
            int birthdayDay = birthdayCal.get(5);
            int birthdayYear = birthdayCal.get(1);
            adminUser = UserLocalServiceUtil.updateUser((long)adminUser.getUserId(), (String)"", (String)"", (String)"", (boolean)false, (String)adminUser.getReminderQueryQuestion(), (String)adminUser.getReminderQueryAnswer(), (String)screenName, (String)emailAddress, (long)adminUser.getFacebookId(), (String)adminUser.getOpenId(), (boolean)false, null, (String)languageId, (String)adminUser.getTimeZoneId(), (String)greeting, (String)adminUser.getComments(), (String)firstName, (String)adminUser.getMiddleName(), (String)lastName, (long)contact.getPrefixId(), (long)contact.getSuffixId(), (boolean)contact.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)contact.getSmsSn(), (String)contact.getFacebookSn(), (String)contact.getJabberSn(), (String)contact.getSkypeSn(), (String)contact.getTwitterSn(), (String)contact.getJobTitle(), null, null, null, null, null, (ServiceContext)new ServiceContext());
        } else {
            User user;
            UserLocalServiceUtil.addDefaultAdminUser((long)company.getCompanyId(), (String)screenName, (String)emailAddress, (Locale)locale, (String)firstName, (String)"", (String)lastName);
            adminUser = UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)emailAddress);
            String defaultAdminEmailAddress = PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + PropsValues.COMPANY_DEFAULT_WEB_ID;
            if (!emailAddress.equals(defaultAdminEmailAddress) && (user = UserLocalServiceUtil.fetchUserByEmailAddress((long)company.getCompanyId(), (String)defaultAdminEmailAddress)) != null) {
                UserLocalServiceUtil.updateStatus((long)user.getUserId(), (int)5, (ServiceContext)new ServiceContext());
            }
        }
        return UserLocalServiceUtil.updatePasswordReset((long)adminUser.getUserId(), (boolean)resetPassword);
    }

    public static Company updateCompany(Company company, String companyName, String languageId) throws Exception {
        Account account = company.getAccount();
        account.setName(companyName);
        account.setLegalName(companyName + ", Inc.");
        AccountLocalServiceUtil.updateAccount((Account)account);
        User defaultUser = company.getDefaultUser();
        defaultUser.setLanguageId(languageId);
        UserLocalServiceUtil.updateUser((User)defaultUser);
        return company;
    }

    protected static void addOrganizations(String companyName, User defaultUser, Organization parentOrganization) throws Exception {
        for (Object[] organizationArray : _ORGANIZATION_ARRAYS) {
            String name = companyName + organizationArray[0];
            long regionId = (Long)organizationArray[1];
            long countryId = (Long)organizationArray[2];
            String type = (String)organizationArray[3];
            Organization organization = OrganizationLocalServiceUtil.addOrganization((long)defaultUser.getUserId(), (long)parentOrganization.getOrganizationId(), (String)name, (String)type, (long)regionId, (long)countryId, (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, (String)"", (boolean)true, null);
            GroupLocalServiceUtil.updateFriendlyURL((long)organization.getGroupId(), (String)FriendlyURLNormalizerUtil.normalize((String)("/" + organizationArray[0])));
            if (organizationArray.length <= 4) continue;
            String organizationPrefix = (String)organizationArray[4];
            long[] groupIds = new long[]{organization.getGroupId()};
            long[] organizationIds = new long[]{parentOrganization.getOrganizationId(), organization.getOrganizationId()};
            for (int i = 1; i <= 10; ++i) {
                StringBundler sb = new StringBundler(5);
                String defaultUserEmailAddress = defaultUser.getEmailAddress();
                String[] defaultUserEmailAddressParts = defaultUserEmailAddress.split("@");
                sb.append(defaultUserEmailAddressParts[0]);
                sb.append(".");
                sb.append(organizationPrefix);
                sb.append(".");
                sb.append(i);
                String screenName = sb.toString();
                String emailAddress = screenName + defaultUserEmailAddressParts[1];
                String lastName = organizationPrefix + " " + i;
                User user = UserLocalServiceUtil.addUser((long)0L, (long)defaultUser.getCompanyId(), (boolean)false, (String)"test", (String)"test", (boolean)false, (String)screenName, (String)emailAddress, (long)0L, null, (Locale)LocaleUtil.getDefault(), (String)"Test", null, (String)lastName, (long)0L, (long)0L, (boolean)true, (int)0, (int)1, (int)1970, null, (long[])groupIds, (long[])organizationIds, null, null, (boolean)false, (ServiceContext)new ServiceContext());
                user.setPasswordReset(false);
                user.setAgreedToTermsOfUse(true);
                UserLocalServiceUtil.updateUser((User)user);
            }
        }
    }
}

