/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.TemplateResourceParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public abstract class URLResourceParser
implements TemplateResourceParser {
    private static final Log _log = LogFactoryUtil.getLog(URLResourceParser.class);

    @Override
    public TemplateResource getTemplateResource(String templateId) throws TemplateException {
        templateId = URLResourceParser.normalizePath(templateId);
        try {
            URL url = this.getURL(templateId);
            if (url == null) {
                return null;
            }
            return new URLTemplateResource(templateId, url);
        }
        catch (IOException ioe) {
            throw new TemplateException((Throwable)ioe);
        }
    }

    public abstract URL getURL(String var1) throws IOException;

    @Override
    public boolean isTemplateResourceValid(String templateId, String langType) {
        if (Validator.isBlank((String)templateId)) {
            return true;
        }
        char[] chars = templateId.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '%' || c == '#' || c == '?' || c == ';') {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to load template " + templateId + " because the template name contains one or more " + "special characters: %, #, ?, or ;"));
                }
                return false;
            }
            if (c != '\\') continue;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to load template " + templateId + " because the template name contains a backslash"));
            }
            return false;
        }
        String extension = FileUtil.getExtension((String)templateId);
        return extension.equals(langType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String normalizePath(String path) {
        int index;
        ArrayList<String> elements = new ArrayList<String>();
        boolean absolutePath = false;
        int previousIndex = -1;
        while ((index = path.indexOf(47, previousIndex + 1)) != -1) {
            if (previousIndex + 1 == index) {
                if (previousIndex != -1) throw new IllegalArgumentException("Unable to parse path " + path);
                absolutePath = true;
            } else {
                String pathElement = path.substring(previousIndex + 1, index);
                if (!pathElement.equals(".")) {
                    if (pathElement.equals("..")) {
                        if (elements.isEmpty()) {
                            throw new IllegalArgumentException("Unable to parse path " + path);
                        }
                        elements.remove(elements.size() - 1);
                    } else {
                        elements.add(pathElement);
                    }
                }
            }
            previousIndex = index;
        }
        if (previousIndex == -1) {
            elements.add(path);
        } else if (previousIndex + 1 < path.length()) {
            elements.add(path.substring(previousIndex + 1));
        }
        String normalizedPath = StringUtil.merge(elements, (String)"/");
        if (!absolutePath) return normalizedPath;
        return "/".concat(normalizedPath);
    }
}

