/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.upgrade.v6_1_0.util.JournalArticleTable;
import com.liferay.portal.upgrade.v6_1_0.util.JournalStructureTable;
import com.liferay.portal.upgrade.v6_1_0.util.JournalTemplateTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeJournal
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.alter(JournalArticleTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "title", "STRING null")});
        this.alter(JournalStructureTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "STRING null"), new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "description", "STRING null")});
        this.alter(JournalTemplateTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "STRING null"), new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "description", "STRING null")});
        this.updateStructureXsd();
    }

    protected void updateStructureXsd() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update JournalStructure set xsd = replace(xsd, 'image_gallery', 'document_library') where xsd like '%image_gallery%'");
        }
        catch (Exception e) {
            try (PreparedStatement ps = this.connection.prepareStatement("select id_, xsd from JournalStructure where xsd like '%image_gallery%'");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong("id_");
                    String xsd = rs.getString("xsd");
                    xsd = StringUtil.replace((String)xsd, (String)"image_gallery", (String)"document_library");
                    this.updateStructureXsd(id, xsd);
                }
            }
        }
    }

    protected void updateStructureXsd(long id, String xsd) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update JournalStructure set xsd = ? where id_ = ?");){
            ps.setString(1, xsd);
            ps.setLong(2, id);
            ps.executeUpdate();
        }
    }
}

