/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DoPrivileged
public class FriendlyURLNormalizerImpl
implements FriendlyURLNormalizer {
    public String normalize(String friendlyURL) {
        return this.normalize(friendlyURL, false);
    }

    @Deprecated
    public String normalize(String friendlyURL, Pattern friendlyURLPattern) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = StringUtil.toLowerCase((String)friendlyURL);
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        Matcher matcher = friendlyURLPattern.matcher(friendlyURL);
        friendlyURL = matcher.replaceAll("-");
        StringBuilder sb = new StringBuilder(friendlyURL.length());
        for (int i = 0; i < friendlyURL.length(); ++i) {
            char c = friendlyURL.charAt(i);
            if (c == '-') {
                if (i != 0 && '-' == sb.charAt(sb.length() - 1)) continue;
                sb.append('-');
                continue;
            }
            sb.append(c);
        }
        if (sb.length() == friendlyURL.length()) {
            return friendlyURL;
        }
        return sb.toString();
    }

    public String normalizeWithPeriodsAndSlashes(String friendlyURL) {
        return this.normalize(friendlyURL, true);
    }

    protected String normalize(String friendlyURL, boolean periodsAndSlashes) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        StringBuilder sb = new StringBuilder(friendlyURL.length());
        boolean modified = false;
        for (int i = 0; i < friendlyURL.length(); ++i) {
            char c = friendlyURL.charAt(i);
            if ('a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_') {
                sb.append(c);
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                sb.append((char)(c + 32));
                modified = true;
                continue;
            }
            if (!(periodsAndSlashes || c != '/' && c != '.')) {
                sb.append(c);
                continue;
            }
            if (i == 0 || '-' != sb.charAt(sb.length() - 1)) {
                sb.append('-');
            }
            modified = true;
        }
        if (modified) {
            return sb.toString();
        }
        return friendlyURL;
    }
}

