/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.permission;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;

@OSGiBeanProperties(property={"model.class.name=com.liferay.blogs.kernel.model.BlogsEntry"})
public class BlogsEntryPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) throws PortalException {
        if (!BlogsEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, BlogsEntry.class.getName(), entry.getEntryId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        if (!BlogsEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, BlogsEntry.class.getName(), entryId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)entry.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (entry.isDraft() || entry.isScheduled()) {
            if (actionId.equals("VIEW") && !BlogsEntryPermission.contains(permissionChecker, entry, "UPDATE")) {
                return false;
            }
        } else if (entry.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)entry.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)entryId);
        return BlogsEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        BlogsEntryPermission.check(permissionChecker, primaryKey, actionId);
    }
}

