/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sitesadmin.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserSiteMembershipChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(UserSiteMembershipChecker.class);
    private final Group _group;

    public UserSiteMembershipChecker(RenderResponse renderResponse, Group group) {
        super((PortletResponse)renderResponse);
        this._group = group;
    }

    public boolean isChecked(Object obj) {
        User user = null;
        if (obj instanceof User) {
            user = (User)obj;
        } else if (obj instanceof Object[]) {
            user = (User)((Object[])obj)[0];
        } else {
            throw new IllegalArgumentException(obj + " is not a user");
        }
        try {
            return UserLocalServiceUtil.hasGroupUser((long)this._group.getGroupId(), (long)user.getUserId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isDisabled(Object obj) {
        User user = (User)obj;
        try {
            if (this.isChecked(user)) {
                return true;
            }
            if (!SiteMembershipPolicyUtil.isMembershipAllowed((long)user.getUserId(), (long)this._group.getGroupId())) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return super.isDisabled(obj);
    }
}

