/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.util.ConnectionWrapper;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.dao.jdbc.util.StatementWrapper;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;

public class DBPartitionUtil {
    private static final boolean _DATABASE_PARTITION_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"database.partition.enabled"));
    private static final boolean _DATABASE_PARTITION_MIGRATE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"database.partition.migrate.enabled"));
    private static final String _DATABASE_PARTITION_SCHEMA_NAME_PREFIX = GetterUtil.get((String)PropsUtil.get((String)"database.partition.schema.name.prefix"), (String)"lpartition_");
    private static final Log _log = LogFactoryUtil.getLog(DBPartitionUtil.class);
    private static final Set<String> _controlTableNames = new HashSet<String>(Arrays.asList("Company", "VirtualHost"));
    private static volatile long _defaultCompanyId;
    private static String _defaultSchemaName;

    public static boolean addDBPartition(long companyId) throws PortalException {
        if (!_DATABASE_PARTITION_ENABLED || companyId == _defaultCompanyId) {
            return false;
        }
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(DBPartitionUtil._getCreateSchemaSQL(companyId));){
            preparedStatement.executeUpdate();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            DBInspector dbInspector = new DBInspector(connection);
            try (ResultSet resultSet = databaseMetaData.getTables(dbInspector.getCatalog(), dbInspector.getSchema(), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (DBPartitionUtil._isControlTable(dbInspector, tableName)) {
                        statement.executeUpdate(DBPartitionUtil._getCreateViewSQL(companyId, tableName));
                        continue;
                    }
                    statement.executeUpdate(DBPartitionUtil._getCreateTableSQL(companyId, tableName));
                }
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        return true;
    }

    public static void forEachCompanyId(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        if (!_DATABASE_PARTITION_ENABLED) {
            unsafeConsumer.accept(null);
            return;
        }
        if (CompanyThreadLocal.isLocked()) {
            unsafeConsumer.accept((Object)CompanyThreadLocal.getCompanyId());
            return;
        }
        for (long companyId : PortalInstances.getCompanyIdsBySQL()) {
            try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);){
                unsafeConsumer.accept((Object)companyId);
            }
        }
    }

    public static boolean isPartitionEnabled() {
        return _DATABASE_PARTITION_ENABLED;
    }

    public static boolean removeDBPartition(long companyId) throws PortalException {
        if (!_DATABASE_PARTITION_ENABLED || companyId == _defaultCompanyId) {
            return false;
        }
        if (_DATABASE_PARTITION_MIGRATE_ENABLED) {
            return DBPartitionUtil._migrateDBPartition(companyId);
        }
        return DBPartitionUtil._dropDBPartition(companyId);
    }

    public static void setDefaultCompanyId(Connection connection) throws SQLException {
        if (_DATABASE_PARTITION_ENABLED) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = '" + PropsValues.COMPANY_DEFAULT_WEB_ID + "'");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    _defaultCompanyId = resultSet.getLong(1);
                }
            }
        }
    }

    public static void setDefaultCompanyId(long companyId) {
        if (_DATABASE_PARTITION_ENABLED) {
            _defaultCompanyId = companyId;
        }
    }

    public static DataSource wrapDataSource(DataSource dataSource) throws SQLException {
        if (!_DATABASE_PARTITION_ENABLED) {
            return dataSource;
        }
        DB db = DBManagerUtil.getDB((DBType)DBManagerUtil.getDBType((Object)DialectDetector.getDialect(dataSource)), (DataSource)dataSource);
        if (db.getDBType() != DBType.MYSQL) {
            throw new Error("Database partition requires MySQL");
        }
        try (Connection connection = dataSource.getConnection();){
            _defaultSchemaName = connection.getCatalog();
        }
        return new DataSourceWrapper(dataSource){

            @Override
            public Connection getConnection() throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }

            @Override
            public Connection getConnection(String userName, String password) throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }
        };
    }

    private static void _copyData(String tableName, String fromSchemaName, String toSchemaName, Statement statement, String whereClause) throws Exception {
        statement.executeUpdate(StringBundler.concat((String[])new String[]{"insert ", toSchemaName, ".", tableName, " select * from ", fromSchemaName, ".", tableName, whereClause}));
    }

    private static boolean _dropDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        DBInspector dbInspector = new DBInspector(connection);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_defaultSchemaName, dbInspector.getSchema(), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!DBPartitionUtil._isControlTable(dbInspector, tableName) || !dbInspector.hasColumn(tableName, "companyId")) continue;
                    statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"delete from ", _defaultSchemaName, ".", tableName, " where companyId = ", companyId}));
                }
                statement.executeUpdate("drop schema " + DBPartitionUtil._getSchemaName(companyId));
            }
        }
        catch (Exception exception) {
            throw new PortalException("Unable to drop database partition", (Throwable)exception);
        }
        return true;
    }

    private static Connection _getConnectionWrapper(final Connection connection) {
        return new ConnectionWrapper(connection){

            @Override
            public Statement createStatement() throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return DBPartitionUtil._wrapStatement(super.createStatement());
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency));
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            @Override
            public String getCatalog() throws SQLException {
                return DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId());
            }

            @Override
            public PreparedStatement prepareStatement(String sql) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return super.prepareStatement(sql);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return super.prepareStatement(sql, autoGeneratedKeys);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return super.prepareStatement(sql, columnIndexes);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                connection.setCatalog(DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId()));
                return super.prepareStatement(sql, columnNames);
            }
        };
    }

    private static String _getCreateSchemaSQL(long companyId) {
        return StringBundler.concat((String[])new String[]{"create schema if not exists ", DBPartitionUtil._getSchemaName(companyId), " character set ", DBPartitionUtil._getSessionCharsetEncoding()});
    }

    private static String _getCreateTableSQL(long companyId, String tableName) {
        return StringBundler.concat((String[])new String[]{"create table if not exists ", DBPartitionUtil._getSchemaName(companyId), ".", tableName, " like ", _defaultSchemaName, ".", tableName});
    }

    private static String _getCreateViewSQL(long companyId, String viewName) {
        return StringBundler.concat((String[])new String[]{"create or replace view ", DBPartitionUtil._getSchemaName(companyId), ".", viewName, " as select * from ", _defaultSchemaName, ".", viewName});
    }

    private static String _getDropTableSQL(long companyId, String tableName) {
        return StringBundler.concat((String[])new String[]{"drop table if exists ", DBPartitionUtil._getSchemaName(companyId), ".", tableName});
    }

    private static String _getDropViewSQL(long companyId, String viewName) {
        return StringBundler.concat((String[])new String[]{"drop view if exists ", DBPartitionUtil._getSchemaName(companyId), ".", viewName});
    }

    private static String _getSchemaName(long companyId) {
        if (companyId == 0L || companyId == _defaultCompanyId) {
            return _defaultSchemaName;
        }
        return _DATABASE_PARTITION_SCHEMA_NAME_PREFIX + companyId;
    }

    /*
     * Exception decompiling
     */
    private static String _getSessionCharsetEncoding() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean _isControlTable(DBInspector dbInspector, String tableName) throws Exception {
        return _controlTableNames.contains(tableName) || tableName.startsWith("QUARTZ_") || !dbInspector.hasColumn(tableName, "companyId");
    }

    private static boolean _isSkip(Connection connection, String tableName) throws SQLException {
        try {
            DBInspector dbInspector = new DBInspector(connection);
            if (DBPartitionUtil._isControlTable(dbInspector, tableName) && CompanyThreadLocal.getCompanyId() != _defaultCompanyId) {
                return true;
            }
        }
        catch (Exception exception) {
            throw new SQLException("Unable to check if the table " + tableName + " is a control table", exception);
        }
        return false;
    }

    private static boolean _migrateDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        DBInspector dbInspector = new DBInspector(connection);
        ArrayList<String> controlTableNames = new ArrayList<String>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_defaultSchemaName, dbInspector.getSchema(), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!DBPartitionUtil._isControlTable(dbInspector, tableName)) continue;
                    controlTableNames.add(tableName);
                    DBPartitionUtil._migrateTable(companyId, tableName, statement, dbInspector);
                }
            }
        }
        catch (Exception exception1) {
            if (ListUtil.isEmpty(controlTableNames)) {
                throw new PortalException((Throwable)exception1);
            }
            try {
                for (String tableName : controlTableNames) {
                    Statement statement = connection.createStatement();
                    Throwable throwable = null;
                    try {
                        DBPartitionUtil._restoreTable(companyId, tableName, statement, dbInspector);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
            }
            catch (Exception exception2) {
                throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to rollback the removal of database ", "partition. Recover a backup of the database schema ", DBPartitionUtil._getSchemaName(companyId), "."}), (Throwable)exception2);
            }
            throw new PortalException("Removal of database partition removal was rolled back", (Throwable)exception1);
        }
        return true;
    }

    private static void _migrateTable(long companyId, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        statement.executeUpdate(DBPartitionUtil._getDropViewSQL(companyId, tableName));
        statement.executeUpdate(DBPartitionUtil._getCreateTableSQL(companyId, tableName));
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, tableName, _defaultSchemaName, DBPartitionUtil._getSchemaName(companyId), statement);
        } else {
            DBPartitionUtil._copyData(tableName, _defaultSchemaName, DBPartitionUtil._getSchemaName(companyId), statement, "");
        }
    }

    private static void _moveCompanyData(long companyId, String tableName, String fromSchemaName, String toSchemaName, Statement statement) throws Exception {
        String whereClause = " where companyId = " + companyId;
        DBPartitionUtil._copyData(tableName, fromSchemaName, toSchemaName, statement, whereClause);
        statement.executeUpdate(StringBundler.concat((String[])new String[]{"delete from ", fromSchemaName, ".", tableName, whereClause}));
    }

    private static void _restoreTable(long companyId, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, tableName, DBPartitionUtil._getSchemaName(companyId), _defaultSchemaName, statement);
        }
        statement.executeUpdate(DBPartitionUtil._getDropTableSQL(companyId, tableName));
        statement.executeUpdate(DBPartitionUtil._getCreateViewSQL(companyId, tableName));
    }

    private static Statement _wrapStatement(final Statement statement) {
        return new StatementWrapper(statement){

            @Override
            public int executeUpdate(String sql) throws SQLException {
                Connection connection = statement.getConnection();
                String lowerCaseSQL = StringUtil.toLowerCase((String)sql);
                String[] query = sql.split(" ");
                if (StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table") && DBPartitionUtil._isSkip(connection, query[2]) || (StringUtil.startsWith((String)lowerCaseSQL, (String)"create index") || StringUtil.startsWith((String)lowerCaseSQL, (String)"drop index")) && DBPartitionUtil._isSkip(connection, query[4]) || StringUtil.startsWith((String)lowerCaseSQL, (String)"create unique index") && DBPartitionUtil._isSkip(connection, query[5])) {
                    return 0;
                }
                int returnValue = super.executeUpdate(sql);
                if (!StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table")) {
                    return returnValue;
                }
                try {
                    long[] companyIds;
                    DBInspector dbInspector = new DBInspector(connection);
                    String tableName = query[2];
                    if (!DBPartitionUtil._isControlTable(dbInspector, tableName)) {
                        return returnValue;
                    }
                    for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                        if (companyId == _defaultCompanyId) continue;
                        super.execute(DBPartitionUtil._getCreateViewSQL(companyId, tableName));
                    }
                    return returnValue;
                }
                catch (Exception exception) {
                    throw new SQLException(exception);
                }
            }
        };
    }
}

