/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Jdk14LogFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ThirdPartyThreadLocalRegistry;
import java.sql.Connection;
import java.sql.Statement;

public class GlobalShutdownAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(GlobalShutdownAction.class);
    private static volatile PortalExecutorManager _portalExecutorManager = (PortalExecutorManager)ServiceProxyFactory.newServiceTrackedInstance(PortalExecutorManager.class, GlobalShutdownAction.class, (String)"_portalExecutorManager", (boolean)true);

    public void run(String[] ids) {
        this.shutdownLevel1();
        this.shutdownLevel2();
        this.shutdownLevel3();
        this.shutdownLevel4();
        this.shutdownLevel5();
        this.shutdownLevel6();
        this.shutdownLevel7();
    }

    protected ThreadGroup getThreadGroup() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup threadGroup = currentThread.getThreadGroup();
        for (int i = 0; i < 10 && threadGroup.getParent() != null; ++i) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    protected Thread[] getThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount() * 2];
        threadGroup.enumerate(threads);
        return threads;
    }

    protected void shutdownLevel1() {
        AuthPublicPathRegistry.unregister(PropsValues.AUTH_PUBLIC_PATHS);
        DocumentConversionUtil.disconnect();
    }

    protected void shutdownLevel2() {
        AutoDeployUtil.unregisterDir((String)"defaultAutoDeployDir");
        HotDeployUtil.unregisterListeners();
    }

    protected void shutdownLevel3() {
        MessageBusUtil.shutdown((boolean)true);
    }

    protected void shutdownLevel4() {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.HYPERSONIC) {
            try (Connection connection = DataAccess.getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeUpdate("SHUTDOWN");
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
    }

    protected void shutdownLevel5() {
        _portalExecutorManager.shutdown(true);
    }

    protected void shutdownLevel6() {
        block2: {
            try {
                LogFactoryUtil.setLogFactory((LogFactory)new Jdk14LogFactoryImpl());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        ThirdPartyThreadLocalRegistry.resetThreadLocals();
        CentralizedThreadLocal.clearShortLivedThreadLocals();
    }

    protected void shutdownLevel7() {
        if (GetterUtil.getBoolean((String)PropsUtil.get("shutdown.programmatically.exit"))) {
            Thread[] threads;
            Thread currentThread = Thread.currentThread();
            ThreadGroup threadGroup = this.getThreadGroup();
            for (Thread thread : threads = this.getThreads(threadGroup)) {
                if (thread == null || thread == currentThread) continue;
                try {
                    thread.interrupt();
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)exception, (Throwable)exception);
                }
            }
            threadGroup.destroy();
        }
    }
}

