/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.petra.portlet.url.builder.PortletURLBuilder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.LayoutPermissionException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.login.AuthLoginGroupSettingsUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.theme.ThemeDisplayFactory;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeAccessPolicyTracker;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

public class ServicePreAction
extends Action {
    protected File privateLARFile;
    protected File publicLARFile;
    private static final String _PATH_MAIN = PortalUtil.getPathMain();
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final String _PATH_PORTAL_LOGIN = "/portal/login";
    private static final String _PATH_PORTAL_LOGOUT = "/portal/logout";
    private static final String _PATH_PROXY;
    private static final Log _log;
    private static final Map<String, String> _portalDomains;

    public ServicePreAction() {
        this._initImportLARFiles();
    }

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.servicePre(httpServletRequest, httpServletResponse, true);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Running takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void servicePre(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean initPermissionChecker) throws Exception {
        ThemeDisplay themeDisplay = this._initThemeDisplay(httpServletRequest, httpServletResponse, initPermissionChecker);
        if (themeDisplay == null) {
            return;
        }
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        if (PropsValues.LAYOUT_AJAX_RENDER_ENABLE) {
            boolean portletAjaxRender = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"p_p_ajax", (boolean)true);
            httpServletRequest.setAttribute("PORTLET_AJAX_RENDER", (Object)portletAjaxRender);
        }
    }

    private void _addDefaultLayoutsByLAR(long userId, long groupId, boolean privateLayout, File larFile) throws Exception {
        User user = UserLocalServiceUtil.getUser((long)userId);
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((User)user, (long)groupId, (boolean)privateLayout, null, (Map)HashMapBuilder.put((Object)"PERMISSIONS", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_ARCHIVED_SETUPS_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_CONFIGURATION", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_CONFIGURATION_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_DATA", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_DATA_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_DATA_CONTROL_DEFAULT", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_SETUP_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_USER_PREFERENCES_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"THEME_REFERENCE", (Object)new String[]{Boolean.TRUE.toString()}).build());
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)user.getUserId(), (int)6, (Map)importLayoutSettingsMap);
        ExportImportLocalServiceUtil.importLayouts((ExportImportConfiguration)exportImportConfiguration, (File)larFile);
    }

    private void _addDefaultUserPrivateLayoutByProperties(long userId, long groupId) throws Exception {
        String friendlyURL = this._getFriendlyURL(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_FRIENDLY_URL);
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)true, (long)0L, (String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)new ServiceContext());
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.user.private.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    private void _addDefaultUserPrivateLayouts(User user) throws Exception {
        Group group = user.getGroup();
        if (this.privateLARFile != null) {
            this._addDefaultLayoutsByLAR(user.getUserId(), group.getGroupId(), true, this.privateLARFile);
        } else {
            this._addDefaultUserPrivateLayoutByProperties(user.getUserId(), group.getGroupId());
        }
    }

    private void _addDefaultUserPublicLayoutByProperties(long userId, long groupId) throws Exception {
        String friendlyURL = this._getFriendlyURL(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_FRIENDLY_URL);
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)false, (long)0L, (String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)new ServiceContext());
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.user.public.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    private void _addDefaultUserPublicLayouts(User user) throws Exception {
        Group userGroup = user.getGroup();
        if (this.publicLARFile != null) {
            this._addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), false, this.publicLARFile);
        } else {
            this._addDefaultUserPublicLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    private void _deleteDefaultUserPrivateLayouts(User user) throws Exception {
        Group group = user.getGroup();
        LayoutLocalServiceUtil.deleteLayouts((long)group.getGroupId(), (boolean)true, (ServiceContext)new ServiceContext());
    }

    private void _deleteDefaultUserPublicLayouts(User user) throws Exception {
        Group userGroup = user.getGroup();
        LayoutLocalServiceUtil.deleteLayouts((long)userGroup.getGroupId(), (boolean)false, (ServiceContext)new ServiceContext());
    }

    private LayoutComposite _getDefaultUserPersonalSiteLayoutComposite(User user) {
        Layout layout = null;
        Group group = user.getGroup();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)true, (long)0L);
        if (layouts.isEmpty()) {
            layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
        }
        if (!layouts.isEmpty()) {
            layout = (Layout)layouts.get(0);
        }
        return new LayoutComposite(layout, layouts);
    }

    private LayoutComposite _getDefaultUserSitesLayoutComposite(final User user) throws Exception {
        final LinkedHashMap groupParams = LinkedHashMapBuilder.put((Object)"usersGroups", (Object)user.getUserId()).build();
        int count = GroupLocalServiceUtil.searchCount((long)user.getCompanyId(), null, null, (LinkedHashMap)groupParams);
        final IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(count);
        intervalActionProcessor.setPerformIntervalActionMethod((IntervalActionProcessor.PerformIntervalActionMethod)new IntervalActionProcessor.PerformIntervalActionMethod<LayoutComposite>(){

            public LayoutComposite performIntervalAction(int start, int end) {
                List groups = GroupLocalServiceUtil.search((long)user.getCompanyId(), null, null, (LinkedHashMap)groupParams, (int)start, (int)end);
                for (Group group : groups) {
                    List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)true, (long)0L);
                    if (layouts.isEmpty()) {
                        layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                    }
                    if (layouts.isEmpty()) continue;
                    return new LayoutComposite((Layout)layouts.get(0), layouts);
                }
                intervalActionProcessor.incrementStart(groups.size());
                return null;
            }
        });
        LayoutComposite layoutComposite = (LayoutComposite)intervalActionProcessor.performIntervalActions();
        if (layoutComposite == null) {
            return new LayoutComposite(null, new ArrayList<Layout>());
        }
        return layoutComposite;
    }

    private LayoutComposite _getDefaultViewableLayoutComposite(HttpServletRequest httpServletRequest, User user, PermissionChecker permissionChecker, boolean signedIn, boolean ignoreHiddenLayouts) throws Exception {
        LayoutComposite defaultLayoutComposite = this._getDefaultVirtualHostLayoutComposite(httpServletRequest);
        if (ListUtil.isNotEmpty((defaultLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, defaultLayoutComposite.getLayout(), defaultLayoutComposite.getLayouts(), ignoreHiddenLayouts)).getLayouts())) {
            return defaultLayoutComposite;
        }
        if (signedIn) {
            defaultLayoutComposite = this._getDefaultUserPersonalSiteLayoutComposite(user);
            if (defaultLayoutComposite.getLayout() == null) {
                defaultLayoutComposite = this._getDefaultUserSitesLayoutComposite(user);
            }
            if (ListUtil.isNotEmpty((defaultLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, defaultLayoutComposite.getLayout(), defaultLayoutComposite.getLayouts(), ignoreHiddenLayouts)).getLayouts())) {
                return defaultLayoutComposite;
            }
        }
        defaultLayoutComposite = this._getGuestSiteLayoutComposite(user);
        return this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, defaultLayoutComposite.getLayout(), defaultLayoutComposite.getLayouts(), ignoreHiddenLayouts);
    }

    private LayoutComposite _getDefaultVirtualHostLayoutComposite(HttpServletRequest httpServletRequest) throws Exception {
        Object layout = null;
        List layouts = null;
        LayoutSet layoutSet = (LayoutSet)httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null) {
            layouts = LayoutLocalServiceUtil.getLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)0L);
            Group group = null;
            if (!layouts.isEmpty()) {
                layout = (Layout)layouts.get(0);
                group = layout.getGroup();
            }
            if (layout != null && layout.isPrivateLayout()) {
                layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                if (!layouts.isEmpty()) {
                    layout = (Layout)layouts.get(0);
                } else {
                    group = null;
                    layout = null;
                }
            }
            if (group != null && group.isStagingGroup()) {
                Group liveGroup = group.getLiveGroup();
                layouts = LayoutLocalServiceUtil.getLayouts((long)liveGroup.getGroupId(), (boolean)false, (long)0L);
                layout = !layouts.isEmpty() ? (Layout)layouts.get(0) : null;
            }
        }
        return new LayoutComposite((Layout)layout, layouts);
    }

    private String _getFriendlyURL(String friendlyURL) {
        friendlyURL = GetterUtil.getString((String)friendlyURL);
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    private LayoutComposite _getGuestSiteLayoutComposite(User user) throws Exception {
        Layout layout = null;
        Group guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest");
        List layouts = LayoutLocalServiceUtil.getLayouts((long)guestGroup.getGroupId(), (boolean)false, (long)0L);
        if (!layouts.isEmpty()) {
            layout = (Layout)layouts.get(0);
        }
        return new LayoutComposite(layout, layouts);
    }

    private String _getPortalDomain(String portalURL) {
        String portalDomain = _portalDomains.get(portalURL);
        if (portalDomain == null) {
            portalDomain = HttpUtil.getDomain((String)portalURL);
            _portalDomains.put(portalURL, portalDomain);
        }
        return portalDomain;
    }

    private LayoutComposite _getViewableLayoutComposite(HttpServletRequest httpServletRequest, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts, boolean ignoreHiddenLayouts) throws Exception {
        if (ListUtil.isEmpty(layouts)) {
            return new LayoutComposite(layout, layouts);
        }
        boolean hasViewLayoutPermission = false;
        if (this._hasAccessPermission(permissionChecker, layout, false)) {
            hasViewLayoutPermission = true;
        }
        ArrayList<Layout> accessibleLayouts = new ArrayList<Layout>();
        for (Layout curLayout : layouts) {
            if (!ignoreHiddenLayouts && curLayout.isHidden() || !this._hasAccessPermission(permissionChecker, curLayout, false)) continue;
            if (accessibleLayouts.isEmpty() && !hasViewLayoutPermission) {
                layout = curLayout;
            }
            accessibleLayouts.add(curLayout);
        }
        if (accessibleLayouts.isEmpty()) {
            layouts = null;
            if (!this._isLoginRequest(httpServletRequest) && !hasViewLayoutPermission) {
                if (user.isDefaultUser() && AuthLoginGroupSettingsUtil.isPromptEnabled((long)layout.getGroupId())) {
                    throw new PrincipalException.MustBeAuthenticated(String.valueOf(user.getUserId()));
                }
                SessionErrors.add((HttpServletRequest)httpServletRequest, (String)LayoutPermissionException.class.getName());
            }
        } else {
            layouts = accessibleLayouts;
        }
        return new LayoutComposite(layout, layouts);
    }

    private boolean _hasAccessPermission(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup) throws Exception {
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (boolean)checkViewableGroup, (String)"VIEW");
    }

    private Boolean _hasPowerUserRole(User user) throws Exception {
        return RoleLocalServiceUtil.hasUserRole((long)user.getUserId(), (long)user.getCompanyId(), (String)"Power User", (boolean)true);
    }

    private void _initImportLARFiles() {
        String privateLARFileName = PropsValues.DEFAULT_USER_PRIVATE_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading private LAR file " + privateLARFileName));
        }
        if (Validator.isNotNull((String)privateLARFileName)) {
            this.privateLARFile = new File(privateLARFileName);
            if (!this.privateLARFile.exists()) {
                _log.error((Object)("Private LAR file " + this.privateLARFile + " does not exist"));
                this.privateLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using private LAR file " + privateLARFileName));
            }
        }
        String publicLARFileName = PropsValues.DEFAULT_USER_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    private ThemeDisplay _initThemeDisplay(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean initPermissionChecker) throws Exception {
        Group refererLayoutGroup;
        Layout refererLayout;
        boolean themeJsBarebone;
        long sourceGroupId;
        Group layoutGroup;
        long refererPlid;
        boolean signedIn;
        Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
        String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)httpServletRequest);
        String dynamicResourcesCDNHost = "";
        boolean cdnDynamicResourceEnabled = PortalUtil.isCDNDynamicResourcesEnabled((HttpServletRequest)httpServletRequest);
        if (cdnDynamicResourceEnabled) {
            dynamicResourcesCDNHost = cdnHost;
        }
        String contextPath = PortalUtil.getPathContext();
        String friendlyURLPrivateGroupPath = PortalUtil.getPathFriendlyURLPrivateGroup();
        String friendlyURLPrivateUserPath = PortalUtil.getPathFriendlyURLPrivateUser();
        String friendlyURLPublicPath = PortalUtil.getPathFriendlyURLPublic();
        String imagePath = dynamicResourcesCDNHost.concat(PortalUtil.getPathImage());
        String mainPath = _PATH_MAIN;
        String i18nPath = (String)httpServletRequest.getAttribute("I18N_PATH");
        if (Validator.isNotNull((String)i18nPath)) {
            if (Validator.isNotNull((String)contextPath)) {
                String i18nContextPath = contextPath.concat(i18nPath);
                friendlyURLPrivateGroupPath = StringUtil.replaceFirst((String)friendlyURLPrivateGroupPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPrivateUserPath = StringUtil.replaceFirst((String)friendlyURLPrivateUserPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPublicPath = StringUtil.replaceFirst((String)friendlyURLPublicPath, (String)contextPath, (String)i18nContextPath);
                mainPath = StringUtil.replaceFirst((String)mainPath, (String)contextPath, (String)i18nContextPath);
            } else {
                friendlyURLPrivateGroupPath = i18nPath.concat(friendlyURLPrivateGroupPath);
                friendlyURLPrivateUserPath = i18nPath.concat(friendlyURLPrivateUserPath);
                friendlyURLPublicPath = i18nPath.concat(friendlyURLPublicPath);
                mainPath = i18nPath.concat(mainPath);
            }
        }
        String companyLogo = imagePath + "/company_logo";
        long companyLogoId = company.getLogoId();
        if (companyLogoId > 0L) {
            companyLogo = StringBundler.concat((Object[])new Object[]{"?img_id=", company.getLogoId(), "&t=", WebServerServletTokenUtil.getToken((long)company.getLogoId())});
        }
        int companyLogoHeight = 0;
        int companyLogoWidth = 0;
        Image companyLogoImage = null;
        companyLogoImage = companyLogoId > 0L ? ImageLocalServiceUtil.getCompanyLogo((long)companyLogoId) : ImageToolUtil.getDefaultCompanyLogo();
        if (companyLogoImage != null) {
            companyLogoHeight = companyLogoImage.getHeight();
            companyLogoWidth = companyLogoImage.getWidth();
        }
        User user = null;
        try {
            user = PortalUtil.initUser((HttpServletRequest)httpServletRequest);
        }
        catch (NoSuchUserException noSuchUserException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchUserException, (Throwable)noSuchUserException);
            }
            return null;
        }
        boolean bl = signedIn = !user.isDefaultUser();
        if (PropsValues.BROWSER_CACHE_DISABLED || PropsValues.BROWSER_CACHE_SIGNED_IN_DISABLED && signedIn) {
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.setHeader("Pragma", "no-cache");
        }
        HttpSession httpSession = httpServletRequest.getSession();
        User realUser = user;
        Long realUserId = (Long)httpSession.getAttribute("USER_ID");
        if (realUserId != null && user.getUserId() != realUserId.longValue()) {
            realUser = UserLocalServiceUtil.getUserById((long)realUserId);
        }
        if ((refererPlid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"refererPlid")) != 0L && LayoutLocalServiceUtil.fetchLayout((long)refererPlid) == null) {
            refererPlid = 0L;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (initPermissionChecker && permissionChecker == null || permissionChecker.getUserId() != user.getUserId()) {
            permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        try {
            CookieKeys.validateSupportCookie((HttpServletRequest)httpServletRequest);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            CookieKeys.addSupportCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        TimeZone timeZone = user.getTimeZone();
        if (timeZone == null) {
            timeZone = company.getTimeZone();
        }
        if (signedIn) {
            this._updateUserLayouts(user);
        }
        Layout layout = null;
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_l_id");
        boolean viewableSourceGroup = true;
        if (plid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        } else {
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            long layoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutId");
            if (groupId > 0L && layoutId > 0L) {
                boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
                layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            }
        }
        if (layout != null && (layout.isPrivateLayout() && !PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || layout.isPublicLayout() && !PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) && (layoutGroup = layout.getGroup()).isUser()) {
            User layoutUser = UserLocalServiceUtil.getUserById((long)company.getCompanyId(), (long)layoutGroup.getClassPK());
            this._updateUserLayouts(layoutUser);
            layout = LayoutLocalServiceUtil.fetchLayout((long)layout.getPlid());
        }
        if (layout != null && (sourceGroupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_v_l_s_g_id")) > 0L && sourceGroupId != layout.getGroupId()) {
            if (layout.isTypeControlPanel() || layout.isPublicLayout() || SitesUtil.isUserGroupLayoutSetViewable((PermissionChecker)permissionChecker, (Group)layout.getGroup())) {
                Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
                if (sourceGroup.isUser() && sourceGroup.getClassPK() != user.getUserId() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)sourceGroup, (String)"VIEW")) {
                    String message = StringBundler.concat((Object[])new Object[]{"User ", user.getUserId(), " is not allowed to access the private pages of ", "user ", sourceGroup.getClassPK()});
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)message);
                    }
                    throw new NoSuchLayoutException(message);
                }
                layout = new VirtualLayout(layout, sourceGroup);
            } else {
                viewableSourceGroup = false;
            }
        }
        long doAsGroupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"doAsGroupId");
        String doAsUserId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"doAsUserLanguageId");
        Group group = null;
        List layouts = null;
        boolean loginRequest = this._isLoginRequest(httpServletRequest);
        Boolean redirectToDefaultLayout = (Boolean)httpServletRequest.getAttribute("REDIRECT_TO_DEFAULT_LAYOUT");
        if (redirectToDefaultLayout == null) {
            redirectToDefaultLayout = Boolean.FALSE;
        }
        long refererGroupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"refererGroupId");
        boolean stagingGroup = false;
        boolean viewableGroup = false;
        if (layout != null) {
            group = layout.getGroup();
            stagingGroup = group.isStagingGroup();
            if (!signedIn && PropsValues.AUTH_FORWARD_BY_REDIRECT) {
                httpServletRequest.setAttribute("REQUESTED_LAYOUT", (Object)layout);
            }
            viewableGroup = this._hasAccessPermission(permissionChecker, layout, true);
            boolean viewableStaging = false;
            if (!group.isControlPanel() && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_STAGING")) {
                viewableStaging = true;
            }
            if (viewableStaging) {
                layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
            } else if (!(viewableGroup && viewableSourceGroup || !stagingGroup)) {
                layout = null;
            } else {
                if (!(loginRequest || viewableGroup && viewableSourceGroup && (redirectToDefaultLayout.booleanValue() || this._hasAccessPermission(permissionChecker, layout, false)))) {
                    if (!group.isUser() && user.isDefaultUser() && AuthLoginGroupSettingsUtil.isPromptEnabled((long)group.getGroupId())) {
                        throw new PrincipalException.MustBeAuthenticated(user.getUserId());
                    }
                    String message = StringBundler.concat((Object[])new Object[]{"User ", user.getUserId(), " is not allowed to access the ", layout.isPrivateLayout() ? "private" : "public", " pages of group ", layout.getGroupId()});
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)message);
                    }
                    throw new NoSuchLayoutException(message);
                }
                if (loginRequest && !viewableGroup) {
                    layout = null;
                } else if (group.isLayoutPrototype()) {
                    layouts = new ArrayList<Layout>();
                } else {
                    layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
                    if (!group.isControlPanel()) {
                        doAsGroupId = 0L;
                    }
                }
            }
        }
        List unfilteredLayouts = layouts;
        LayoutComposite viewableLayoutComposite = null;
        if (layout == null) {
            boolean ignoreHiddenLayouts = false;
            if ((!viewableGroup || !viewableSourceGroup) && stagingGroup || loginRequest && !viewableGroup) {
                ignoreHiddenLayouts = true;
            }
            viewableLayoutComposite = this._getDefaultViewableLayoutComposite(httpServletRequest, user, permissionChecker, signedIn, ignoreHiddenLayouts);
            httpServletRequest.setAttribute("LAYOUT_DEFAULT", (Object)Boolean.TRUE);
        } else {
            viewableLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, layout, layouts, false);
        }
        String layoutSetLogo = null;
        layout = viewableLayoutComposite.getLayout();
        layouts = viewableLayoutComposite.getLayouts();
        if (layout != null) {
            if (group == null) {
                group = layout.getGroup();
            }
            if (!group.isControlPanel()) {
                this._rememberVisitedGroupIds(httpServletRequest, group.getGroupId());
            }
        }
        LayoutTypePortlet layoutTypePortlet = null;
        layouts = this._mergeAdditionalLayouts(httpServletRequest, user, permissionChecker, layout, layouts);
        LayoutSet layoutSet = null;
        boolean hasUpdateLayoutPermission = false;
        if (layout != null) {
            String typeSettings;
            LayoutClone layoutClone;
            LayoutTypeAccessPolicy layoutTypeAccessPolicy = LayoutTypeAccessPolicyTracker.getLayoutTypeAccessPolicy(layout);
            boolean hasCustomizeLayoutPermission = layoutTypeAccessPolicy.isCustomizeLayoutAllowed(permissionChecker, layout);
            hasUpdateLayoutPermission = layoutTypeAccessPolicy.isUpdateLayoutAllowed(permissionChecker, layout);
            layoutSet = layout.getLayoutSet();
            if (company.isSiteLogo()) {
                long logoId = 0L;
                if (layoutSet.isLogo()) {
                    logoId = layoutSet.getLogoId();
                    if (logoId == 0L) {
                        logoId = layoutSet.getLiveLogoId();
                    }
                } else {
                    LayoutSet siblingLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)layout.getGroupId(), (!layout.isPrivateLayout() ? 1 : 0) != 0);
                    if (siblingLayoutSet.isLogo() && (logoId = siblingLayoutSet.getLogoId()) == 0L) {
                        logoId = siblingLayoutSet.getLiveLogoId();
                    }
                }
                if (logoId > 0L) {
                    layoutSetLogo = StringBundler.concat((Object[])new Object[]{imagePath, "/layout_set_logo?img_id=", logoId, "&t=", WebServerServletTokenUtil.getToken((long)logoId)});
                    Image layoutSetLogoImage = ImageLocalServiceUtil.getCompanyLogo((long)logoId);
                    companyLogo = layoutSetLogo;
                    companyLogoHeight = layoutSetLogoImage.getHeight();
                    companyLogoWidth = layoutSetLogoImage.getWidth();
                }
            }
            plid = layout.getPlid();
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            boolean customizable = layoutTypePortlet.isCustomizable();
            boolean customizedView = SessionParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"customized_view", (boolean)true);
            if (!customizable || group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.isStagingGroup()) {
                customizedView = false;
            }
            layoutTypePortlet.setCustomizedView(customizedView);
            layoutTypePortlet.setUpdatePermission(hasUpdateLayoutPermission);
            if (signedIn && customizable && customizedView && hasCustomizeLayoutPermission) {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((long)user.getUserId(), (boolean)true);
                layoutTypePortlet.setPortalPreferences(portalPreferences);
            }
            if ((layoutClone = LayoutCloneFactory.getInstance()) != null && (typeSettings = layoutClone.get(httpServletRequest, plid)) != null) {
                UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).load(typeSettings).build();
                String stateMax = typeSettingsUnicodeProperties.getProperty("state-max");
                String stateMin = typeSettingsUnicodeProperties.getProperty("state-min");
                String modeAbout = typeSettingsUnicodeProperties.getProperty("mode-about");
                String modeConfig = typeSettingsUnicodeProperties.getProperty("mode-config");
                String modeEdit = typeSettingsUnicodeProperties.getProperty("mode-edit");
                String modeEditDefaults = typeSettingsUnicodeProperties.getProperty("mode-edit-defaults");
                String modeEditGuest = typeSettingsUnicodeProperties.getProperty("mode-edit-guest");
                String modeHelp = typeSettingsUnicodeProperties.getProperty("mode-help");
                String modePreview = typeSettingsUnicodeProperties.getProperty("mode-preview");
                String modePrint = typeSettingsUnicodeProperties.getProperty("mode-print");
                layoutTypePortlet.setStateMax(stateMax);
                layoutTypePortlet.setStateMin(stateMin);
                layoutTypePortlet.setModeAbout(modeAbout);
                layoutTypePortlet.setModeConfig(modeConfig);
                layoutTypePortlet.setModeEdit(modeEdit);
                layoutTypePortlet.setModeEditDefaults(modeEditDefaults);
                layoutTypePortlet.setModeEditGuest(modeEditGuest);
                layoutTypePortlet.setModeHelp(modeHelp);
                layoutTypePortlet.setModePreview(modePreview);
                layoutTypePortlet.setModePrint(modePrint);
            }
            httpServletRequest.setAttribute("LAYOUT", (Object)layout);
            httpServletRequest.setAttribute("LAYOUTS", (Object)layouts);
        }
        String i18nLanguageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID");
        Locale locale = PortalUtil.getLocale((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (boolean)true);
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest);
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)httpServletRequest);
        if (group.isInheritContent()) {
            scopeGroupId = group.getParentGroupId();
        }
        if (scopeGroupId <= 0L && doAsGroupId > 0L) {
            scopeGroupId = doAsGroupId;
        }
        long siteGroupId = 0L;
        if (layout != null) {
            siteGroupId = layout.isTypeControlPanel() ? PortalUtil.getSiteGroupId((long)scopeGroupId) : PortalUtil.getSiteGroupId((long)layout.getGroupId());
        }
        Theme theme = null;
        ColorScheme colorScheme = null;
        if (layout != null && (layout.isTypeControlPanel() || group.isControlPanel())) {
            String themeId = PrefsPropsUtil.getString(company.getCompanyId(), "control.panel.layout.regular.theme.id");
            String colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
            theme = ThemeLocalServiceUtil.getTheme((long)company.getCompanyId(), (String)themeId);
            colorScheme = ThemeLocalServiceUtil.getColorScheme((long)company.getCompanyId(), (String)theme.getThemeId(), (String)colorSchemeId);
            httpServletRequest.setAttribute("COLOR_SCHEME", (Object)colorScheme);
            httpServletRequest.setAttribute("THEME", (Object)theme);
        }
        boolean themeCssFastLoad = PropsValues.THEME_CSS_FAST_LOAD;
        if (PropsValues.THEME_CSS_FAST_LOAD_CHECK_REQUEST_PARAMETER) {
            themeCssFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"css_fast_load", (boolean)PropsValues.THEME_CSS_FAST_LOAD);
        }
        boolean themeImagesFastLoad = PropsValues.THEME_IMAGES_FAST_LOAD;
        if (PropsValues.THEME_IMAGES_FAST_LOAD_CHECK_REQUEST_PARAMETER) {
            SessionParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"images_fast_load", (boolean)PropsValues.THEME_IMAGES_FAST_LOAD);
        }
        if ((themeJsBarebone = PropsValues.JAVASCRIPT_BAREBONE_ENABLED) && (signedIn || PropsValues.JAVASCRIPT_SINGLE_PAGE_APPLICATION_ENABLED)) {
            themeJsBarebone = false;
        }
        boolean themeJsFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"js_fast_load", (boolean)PropsValues.JAVASCRIPT_FAST_LOAD);
        String lifecycle = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_lifecycle", (String)"0");
        lifecycle = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_t_lifecycle", (String)lifecycle);
        String async = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_async");
        String hub = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_hub");
        boolean isolated = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"p_p_isolated");
        boolean widget = false;
        Boolean widgetObj = (Boolean)httpServletRequest.getAttribute("WIDGET");
        if (widgetObj != null) {
            widget = widgetObj;
        }
        ThemeDisplay themeDisplay = ThemeDisplayFactory.create();
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setResponse(httpServletResponse);
        boolean secure = PortalUtil.isForwardedSecure((HttpServletRequest)httpServletRequest);
        themeDisplay.setCDNDynamicResourcesHost(dynamicResourcesCDNHost);
        themeDisplay.setCDNHost(cdnHost);
        themeDisplay.setPortalDomain(this._getPortalDomain(portalURL));
        themeDisplay.setPortalURL(portalURL);
        themeDisplay.setRefererPlid(refererPlid);
        themeDisplay.setSecure(secure);
        themeDisplay.setServerName(PortalUtil.getForwardedHost((HttpServletRequest)httpServletRequest));
        themeDisplay.setServerPort(PortalUtil.getForwardedPort((HttpServletRequest)httpServletRequest));
        themeDisplay.setWidget(widget);
        themeDisplay.setAsync(async.equals("1"));
        themeDisplay.setCompany(company);
        themeDisplay.setCompanyLogo(companyLogo);
        themeDisplay.setCompanyLogoHeight(companyLogoHeight);
        themeDisplay.setCompanyLogoWidth(companyLogoWidth);
        themeDisplay.setDoAsGroupId(doAsGroupId);
        themeDisplay.setDoAsUserId(doAsUserId);
        themeDisplay.setDoAsUserLanguageId(doAsUserLanguageId);
        themeDisplay.setHubAction(hub.equals("0"));
        themeDisplay.setHubPartialAction(hub.equals("1"));
        themeDisplay.setHubResource(hub.equals("2"));
        themeDisplay.setI18nLanguageId(i18nLanguageId);
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setIsolated(isolated);
        themeDisplay.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        themeDisplay.setLayout(layout);
        themeDisplay.setLayoutSet(layoutSet);
        themeDisplay.setLayoutSetLogo(layoutSetLogo);
        themeDisplay.setLayoutTypePortlet(layoutTypePortlet);
        themeDisplay.setLayouts(layouts);
        themeDisplay.setLifecycle(lifecycle);
        themeDisplay.setLifecycleAction(lifecycle.equals("1"));
        themeDisplay.setLifecycleEvent(lifecycle.equals("3"));
        themeDisplay.setLifecycleRender(lifecycle.equals("0"));
        themeDisplay.setLifecycleResource(lifecycle.equals("2"));
        themeDisplay.setLocale(locale);
        themeDisplay.setLookAndFeel(theme, colorScheme);
        themeDisplay.setPathApplet(contextPath.concat("/applets"));
        themeDisplay.setPathCms(contextPath.concat("/cms"));
        themeDisplay.setPathContext(contextPath);
        themeDisplay.setPathFriendlyURLPrivateGroup(friendlyURLPrivateGroupPath);
        themeDisplay.setPathFriendlyURLPrivateUser(friendlyURLPrivateUserPath);
        themeDisplay.setPathFriendlyURLPublic(friendlyURLPublicPath);
        themeDisplay.setPathImage(imagePath);
        themeDisplay.setPathJavaScript(PortalWebResourcesUtil.getContextPath((String)"js"));
        themeDisplay.setPathMain(mainPath);
        themeDisplay.setPathSound(contextPath.concat("/html/sound"));
        themeDisplay.setPermissionChecker(permissionChecker);
        themeDisplay.setPlid(plid);
        themeDisplay.setPpid(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id"));
        themeDisplay.setRealCompanyLogo(companyLogo);
        themeDisplay.setRealCompanyLogoHeight(companyLogoHeight);
        themeDisplay.setRealCompanyLogoWidth(companyLogoWidth);
        themeDisplay.setRealUser(realUser);
        themeDisplay.setRefererGroupId(refererGroupId);
        themeDisplay.setScopeGroupId(scopeGroupId);
        themeDisplay.setSignedIn(signedIn);
        themeDisplay.setSiteDefaultLocale(PortalUtil.getSiteDefaultLocale((long)siteGroupId));
        themeDisplay.setSiteGroupId(siteGroupId);
        themeDisplay.setStateExclusive(LiferayWindowState.isExclusive((HttpServletRequest)httpServletRequest));
        themeDisplay.setStateMaximized(LiferayWindowState.isMaximized((HttpServletRequest)httpServletRequest));
        themeDisplay.setStatePopUp(LiferayWindowState.isPopUp((HttpServletRequest)httpServletRequest));
        themeDisplay.setThemeCssFastLoad(themeCssFastLoad);
        themeDisplay.setThemeImagesFastLoad(themeImagesFastLoad);
        themeDisplay.setThemeJsBarebone(themeJsBarebone);
        themeDisplay.setThemeJsFastLoad(themeJsFastLoad);
        themeDisplay.setTimeZone(timeZone);
        themeDisplay.setUnfilteredLayouts(unfilteredLayouts);
        themeDisplay.setUser(user);
        boolean showControlPanelIcon = false;
        if (signedIn && PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"VIEW_CONTROL_PANEL")) {
            showControlPanelIcon = true;
        }
        themeDisplay.setShowControlPanelIcon(showControlPanelIcon);
        themeDisplay.setShowHomeIcon(true);
        themeDisplay.setShowMyAccountIcon(signedIn);
        themeDisplay.setShowPageSettingsIcon(hasUpdateLayoutPermission);
        themeDisplay.setShowPortalIcon(true);
        themeDisplay.setShowSignInIcon(!signedIn && !Objects.equals(PropsValues.AUTH_LOGIN_PORTLET_NAME, themeDisplay.getPpid()));
        boolean showSignOutIcon = signedIn;
        if (themeDisplay.isImpersonated()) {
            showSignOutIcon = false;
        }
        themeDisplay.setShowSignOutIcon(showSignOutIcon);
        themeDisplay.setShowStagingIcon(false);
        boolean showSiteAdministrationIcon = false;
        if (signedIn && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_SITE_ADMINISTRATION")) {
            showSiteAdministrationIcon = true;
        }
        themeDisplay.setShowSiteAdministrationIcon(showSiteAdministrationIcon);
        if (PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID && !CookieKeys.hasSessionId((HttpServletRequest)httpServletRequest)) {
            themeDisplay.setAddSessionIdToURL(true);
            themeDisplay.setSessionId(httpSession.getId());
        }
        String urlControlPanel = friendlyURLPrivateGroupPath.concat("/control_panel");
        if (Validator.isNotNull((String)doAsUserId)) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"doAsUserId", (String)doAsUserId);
        }
        if (refererGroupId > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererGroupId", (long)refererGroupId);
        } else if (scopeGroupId > 0L && (refererLayout = LayoutLocalServiceUtil.fetchLayout((long)plid)) != null && (refererLayoutGroup = refererLayout.getGroup()).isUserGroup()) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererGroupId", (long)scopeGroupId);
        }
        if (refererPlid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)refererPlid);
        } else if (plid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)plid);
        }
        if (themeDisplay.isAddSessionIdToURL()) {
            urlControlPanel = PortalUtil.getURLWithSessionId((String)urlControlPanel, (String)httpSession.getId());
        }
        themeDisplay.setURLControlPanel(urlControlPanel);
        themeDisplay.setURLCurrent(PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest));
        themeDisplay.setURLHome(PortalUtil.getHomeURL((HttpServletRequest)httpServletRequest));
        if (layout != null) {
            if (layout.isTypePortlet() && hasUpdateLayoutPermission) {
                themeDisplay.setShowLayoutTemplatesIcon(true);
                if (!group.isUser()) {
                    themeDisplay.setShowPageCustomizationIcon(true);
                }
            }
            if (hasUpdateLayoutPermission) {
                themeDisplay.setShowPageSettingsIcon(true);
            }
            if (group.hasStagingGroup()) {
                themeDisplay.setShowLayoutTemplatesIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isControlPanel()) {
                themeDisplay.setShowPageSettingsIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isStaged() || group.isStagingGroup()) {
                Group scopeGroup = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
                boolean hasManageStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"MANAGE_STAGING");
                boolean hasPublishStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"PUBLISH_STAGING");
                boolean hasViewStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"VIEW_STAGING");
                if (hasManageStagingPermission || hasPublishStagingPermission || hasUpdateLayoutPermission || hasViewStagingPermission) {
                    themeDisplay.setShowStagingIcon(true);
                }
                if (hasPublishStagingPermission) {
                    PortletURL publishToLiveURL = PortletURLBuilder.create((PortletURL)PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_exportimport_web_portlet_ExportImportPortlet", (long)plid, (String)"RENDER_PHASE")).setMVCRenderCommandName("/export_import/publish_layouts").buildPortletURL();
                    if (layout.isPrivateLayout()) {
                        publishToLiveURL.setParameter("tabs1", "private-pages");
                    } else {
                        publishToLiveURL.setParameter("tabs1", "public-pages");
                    }
                    publishToLiveURL.setParameter("groupId", String.valueOf(scopeGroupId));
                    publishToLiveURL.setParameter("selPlid", String.valueOf(plid));
                    publishToLiveURL.setPortletMode(PortletMode.VIEW);
                    publishToLiveURL.setWindowState(LiferayWindowState.EXCLUSIVE);
                    themeDisplay.setURLPublishToLive(publishToLiveURL);
                }
            }
        }
        if (!user.isActive() || PrefsPropsUtil.getBoolean(company.getCompanyId(), "terms.of.use.required") && !user.isAgreedToTermsOfUse()) {
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageSettingsIcon(false);
        }
        if (layout != null && layout.isLayoutPrototypeLinkActive()) {
            themeDisplay.setShowPageCustomizationIcon(false);
        }
        if (group.isLayoutPrototype()) {
            themeDisplay.setShowHomeIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowPageSettingsIcon(true);
            themeDisplay.setShowPortalIcon(false);
            themeDisplay.setShowSignInIcon(false);
            themeDisplay.setShowSignOutIcon(false);
            themeDisplay.setShowSiteAdministrationIcon(false);
            themeDisplay.setShowStagingIcon(false);
        }
        if (group.isLayoutSetPrototype()) {
            themeDisplay.setShowPageCustomizationIcon(false);
        }
        if (group.hasStagingGroup()) {
            themeDisplay.setShowLayoutTemplatesIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
        }
        themeDisplay.setURLPortal(portalURL.concat(contextPath));
        if (!secure && PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS) {
            secure = true;
        }
        String securePortalURL = PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest, (boolean)secure);
        String urlSignIn = StringBundler.concat((String[])new String[]{securePortalURL, mainPath, _PATH_PORTAL_LOGIN});
        if (layout != null) {
            urlSignIn = HttpUtil.addParameter((String)urlSignIn, (String)"p_l_id", (long)layout.getPlid());
        }
        themeDisplay.setURLSignIn(urlSignIn);
        themeDisplay.setURLSignOut(mainPath.concat(_PATH_PORTAL_LOGOUT));
        return themeDisplay;
    }

    private boolean _isLoginRequest(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        String mainPath = _PATH_MAIN;
        if (_PATH_PROXY != null) {
            if (!requestURI.startsWith(_PATH_PROXY)) {
                requestURI = _PATH_PROXY.concat(requestURI);
            }
            if (!mainPath.startsWith(_PATH_PROXY)) {
                mainPath = _PATH_PROXY.concat(mainPath);
            }
        }
        return requestURI.startsWith(mainPath) && requestURI.startsWith(_PATH_PORTAL_LOGIN, mainPath.length());
    }

    private List<Layout> _mergeAdditionalLayouts(HttpServletRequest httpServletRequest, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts) throws Exception {
        Group guestGroup;
        if (layout == null || layout.isPrivateLayout()) {
            return layouts;
        }
        long layoutGroupId = layout.getGroupId();
        if (layoutGroupId != (guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest")).getGroupId()) {
            Group layoutGroup = GroupLocalServiceUtil.getGroup((long)layoutGroupId);
            UnicodeProperties typeSettingsUnicodeProperties = layoutGroup.getTypeSettingsProperties();
            boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("mergeGuestPublicPages"));
            if (!mergeGuestPublicPages) {
                return layouts;
            }
            List<Layout> guestLayouts = LayoutLocalServiceUtil.getLayouts((long)guestGroup.getGroupId(), (boolean)false, (long)0L);
            LayoutComposite viewableLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, layout, guestLayouts, false);
            guestLayouts = viewableLayoutComposite.getLayouts();
            if (layouts == null) {
                return guestLayouts;
            }
            layouts.addAll(0, guestLayouts);
        } else {
            HttpSession httpSession = httpServletRequest.getSession();
            Long previousGroupId = (Long)httpSession.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
            if (previousGroupId != null && previousGroupId != layoutGroupId) {
                Group previousGroup = null;
                try {
                    previousGroup = GroupLocalServiceUtil.getGroup((long)previousGroupId);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)noSuchGroupException, (Throwable)noSuchGroupException);
                    }
                    return layouts;
                }
                UnicodeProperties typeSettingsUnicodeProperties = previousGroup.getTypeSettingsProperties();
                boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("mergeGuestPublicPages"));
                if (!mergeGuestPublicPages) {
                    return layouts;
                }
                List<Layout> previousLayouts = LayoutLocalServiceUtil.getLayouts((long)previousGroupId, (boolean)false, (long)0L);
                LayoutComposite viewableLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, layout, previousLayouts, false);
                if ((previousLayouts = viewableLayoutComposite.getLayouts()) != null) {
                    layouts.addAll(previousLayouts);
                }
            }
        }
        return layouts;
    }

    private void _rememberVisitedGroupIds(HttpServletRequest httpServletRequest, long currentGroupId) {
        String requestURI = GetterUtil.getString((String)httpServletRequest.getRequestURI());
        if (!requestURI.endsWith(_PATH_PORTAL_LAYOUT)) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        Long recentGroupId = (Long)httpSession.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT");
        Long previousGroupId = (Long)httpSession.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
        if (recentGroupId == null) {
            recentGroupId = currentGroupId;
            httpSession.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
        } else if (recentGroupId != currentGroupId) {
            previousGroupId = (long)recentGroupId;
            recentGroupId = currentGroupId;
            httpSession.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
            httpSession.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS", (Object)previousGroupId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Current group id " + currentGroupId));
            _log.debug((Object)("Recent group id " + recentGroupId));
            _log.debug((Object)("Previous group id " + previousGroupId));
        }
    }

    private void _updateUserLayouts(User user) throws Exception {
        Boolean hasPowerUserRole = null;
        boolean addDefaultUserPrivateLayouts = false;
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPrivateLayouts = true;
            if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this._hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPrivateLayouts = false;
                }
            }
        }
        Boolean hasPrivateLayouts = null;
        if (addDefaultUserPrivateLayouts && !(hasPrivateLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)true, (boolean)false))).booleanValue()) {
            this._addDefaultUserPrivateLayouts(user);
        }
        boolean deleteDefaultUserPrivateLayouts = false;
        if (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED) {
            deleteDefaultUserPrivateLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this._hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPrivateLayouts = true;
            }
        }
        if (deleteDefaultUserPrivateLayouts) {
            if (hasPrivateLayouts == null) {
                hasPrivateLayouts = LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)true, (boolean)false);
            }
            if (hasPrivateLayouts.booleanValue()) {
                this._deleteDefaultUserPrivateLayouts(user);
            }
        }
        boolean addDefaultUserPublicLayouts = false;
        if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPublicLayouts = true;
            if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this._hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPublicLayouts = false;
                }
            }
        }
        Boolean hasPublicLayouts = null;
        if (addDefaultUserPublicLayouts && !(hasPublicLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)false, (boolean)false))).booleanValue()) {
            this._addDefaultUserPublicLayouts(user);
        }
        boolean deleteDefaultUserPublicLayouts = false;
        if (!PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            deleteDefaultUserPublicLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this._hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPublicLayouts = true;
            }
        }
        if (deleteDefaultUserPublicLayouts) {
            if (hasPublicLayouts == null) {
                hasPublicLayouts = LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)false, (boolean)false);
            }
            if (hasPublicLayouts.booleanValue()) {
                this._deleteDefaultUserPublicLayouts(user);
            }
        }
    }

    static {
        _log = LogFactoryUtil.getLog(ServicePreAction.class);
        _portalDomains = new ConcurrentHashMap<String, String>();
        String pathProxy = PortalUtil.getPathProxy();
        _PATH_PROXY = Validator.isBlank((String)pathProxy) ? null : pathProxy;
    }

    protected class LayoutComposite {
        private final Layout _layout;
        private final List<Layout> _layouts;

        protected LayoutComposite(Layout layout, List<Layout> layouts) {
            this._layout = layout;
            this._layouts = layouts;
        }

        protected Layout getLayout() {
            return this._layout;
        }

        protected List<Layout> getLayouts() {
            return this._layouts;
        }
    }
}

