/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.metadata;

import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.metadata.RawMetadataProcessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.ClimateForcast;
import org.apache.tika.metadata.CreativeCommons;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Geographic;
import org.apache.tika.metadata.HttpHeaders;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaMetadataKeys;
import org.apache.tika.metadata.TikaMimeKeys;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TikaRawMetadataProcessor
implements RawMetadataProcessor {
    private static final Map<String, String> _fields;
    private static volatile ProcessExecutor _processExecutor;
    private final Parser _parser = new AutoDetectParser(new TikaConfig());

    public Map<String, Set<String>> getFieldNames() {
        return Collections.singletonMap("TIKARAWMETADATA", _fields.keySet());
    }

    public Map<String, DDMFormValues> getRawMetadataMap(String mimeType, InputStream inputStream) throws PortalException {
        Metadata metadata = this._extractMetadata(mimeType, inputStream);
        return this._createDDMFormValuesMap(metadata);
    }

    private static void _addFields(Class<?> clazz, Map<String, String> fields) throws IllegalAccessException {
        for (Field field : clazz.getFields()) {
            Object value = field.get(null);
            if (value instanceof Property) {
                Property property = (Property)value;
                value = property.getName();
            }
            fields.put(StringBundler.concat((String[])new String[]{clazz.getSimpleName(), "_", field.getName()}), (String)value);
        }
    }

    private DDMForm _createDDMForm(Locale defaultLocale) {
        DDMForm ddmForm = new DDMForm();
        ddmForm.addAvailableLocale(defaultLocale);
        ddmForm.setDefaultLocale(defaultLocale);
        return ddmForm;
    }

    private DDMFormValues _createDDMFormValues(Metadata metadata) {
        Locale defaultLocale = LocaleUtil.getDefault();
        DDMForm ddmForm = this._createDDMForm(defaultLocale);
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.addAvailableLocale(defaultLocale);
        ddmFormValues.setDefaultLocale(defaultLocale);
        for (Map.Entry<String, String> entry : _fields.entrySet()) {
            String value = metadata.get(entry.getValue());
            if (value == null) continue;
            String name = entry.getKey();
            DDMFormField ddmFormField = this._createTextDDMFormField(name);
            ddmForm.addDDMFormField(ddmFormField);
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(name);
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    private Map<String, DDMFormValues> _createDDMFormValuesMap(Metadata metadata) {
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        if (metadata == null) {
            return ddmFormValuesMap;
        }
        DDMFormValues ddmFormValues = this._createDDMFormValues(metadata);
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        Set names = ddmFormFieldValuesMap.keySet();
        if (!names.isEmpty()) {
            ddmFormValuesMap.put("TIKARAWMETADATA", ddmFormValues);
        }
        return ddmFormValuesMap;
    }

    private DDMFormField _createTextDDMFormField(String name) {
        DDMFormField ddmFormField = new DDMFormField(name, "text");
        ddmFormField.setDataType("string");
        return ddmFormField;
    }

    private Metadata _extractMetadata(String mimeType, InputStream inputStream) {
        boolean forkProcess = false;
        if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)mimeType)) {
            forkProcess = true;
        }
        if (forkProcess) {
            File file = FileUtil.createTempFile();
            try {
                FileUtil.write((File)file, (InputStream)inputStream);
                if (file.length() == 0L) {
                    Metadata metadata = null;
                    return metadata;
                }
                ExtractMetadataProcessCallable extractMetadataProcessCallable = new ExtractMetadataProcessCallable(file, this._parser);
                ProcessChannel processChannel = _processExecutor.execute(PortalClassPathUtil.getPortalProcessConfig(), (ProcessCallable)extractMetadataProcessCallable);
                NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                Metadata metadata = this._postProcessMetadata(mimeType, (Metadata)future.get());
                return metadata;
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            finally {
                file.delete();
            }
        }
        try {
            return this._postProcessMetadata(mimeType, ExtractMetadataProcessCallable._extractMetadata(inputStream, this._parser));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    private Metadata _postProcessMetadata(String mimeType, Metadata metadata) {
        if (!mimeType.equals("image/svg+xml") || metadata == null) {
            return metadata;
        }
        String contentType = metadata.get("Content-Type");
        if (contentType.startsWith("text/plain")) {
            metadata.set("Content-Type", StringUtil.replace((String)mimeType, (String)"text/plain", (String)"image/svg+xml"));
        }
        return metadata;
    }

    static {
        _processExecutor = (ProcessExecutor)ServiceProxyFactory.newServiceTrackedInstance(ProcessExecutor.class, TikaRawMetadataProcessor.class, (String)"_processExecutor", (boolean)true);
        HashMap<String, String> fields = new HashMap<String, String>();
        try {
            TikaRawMetadataProcessor._addFields(ClimateForcast.class, fields);
            TikaRawMetadataProcessor._addFields(CreativeCommons.class, fields);
            TikaRawMetadataProcessor._addFields(DublinCore.class, fields);
            TikaRawMetadataProcessor._addFields(Geographic.class, fields);
            TikaRawMetadataProcessor._addFields(HttpHeaders.class, fields);
            TikaRawMetadataProcessor._addFields(Message.class, fields);
            TikaRawMetadataProcessor._addFields(Office.class, fields);
            TikaRawMetadataProcessor._addFields(OfficeOpenXMLCore.class, fields);
            TikaRawMetadataProcessor._addFields(TIFF.class, fields);
            TikaRawMetadataProcessor._addFields(TikaMetadataKeys.class, fields);
            TikaRawMetadataProcessor._addFields(TikaMimeKeys.class, fields);
            TikaRawMetadataProcessor._addFields(XMPDM.class, fields);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionInInitializerError(illegalAccessException);
        }
        _fields = fields;
    }

    private static class ExtractMetadataProcessCallable
    implements ProcessCallable<Metadata> {
        private static final long serialVersionUID = 1L;
        private final File _file;
        private final Parser _parser;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Metadata call() throws ProcessException {
            Logger logger = Logger.getLogger("org.apache.tika.parser.SQLite3Parser");
            logger.setLevel(Level.SEVERE);
            logger = Logger.getLogger("org.apache.tika.parsers.PDFParser");
            logger.setLevel(Level.SEVERE);
            try (FileInputStream inputStream = new FileInputStream(this._file);){
                Metadata metadata = ExtractMetadataProcessCallable._extractMetadata(inputStream, this._parser);
                return metadata;
            }
            catch (IOException ioException) {
                throw new ProcessException((Throwable)ioException);
            }
        }

        private static Metadata _extractMetadata(InputStream inputStream, Parser parser) throws IOException {
            Metadata metadata = new Metadata();
            ParseContext parseContext = new ParseContext();
            parseContext.set(Parser.class, (Object)parser);
            try {
                parser.parse(inputStream, (ContentHandler)new DefaultHandler(), metadata, parseContext);
            }
            catch (TikaException | SAXException exception) {
                throw new IOException(exception);
            }
            metadata.remove(XMPDM.ABS_PEAK_AUDIO_FILE_PATH.getName());
            metadata.remove(XMPDM.RELATIVE_PEAK_AUDIO_FILE_PATH.getName());
            return metadata;
        }

        private ExtractMetadataProcessCallable(File file, Parser parser) {
            this._file = file;
            this._parser = parser;
        }
    }
}

