/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlPolicy;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;

public class AccessControlAdvisorImpl
implements AccessControlAdvisor {
    private static final Log _log = LogFactoryUtil.getLog((String)AccessControlAdvisorImpl.class.getName());
    private static final ServiceTrackerList<AccessControlPolicy> _accessControlPolicies = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), AccessControlPolicy.class);

    @Override
    public void accept(Method method, Object[] arguments, AccessControlled accessControlled) throws SecurityException {
        if (AccessControlThreadLocal.isRemoteAccess()) {
            try {
                for (AccessControlPolicy accessControlPolicy : _accessControlPolicies) {
                    accessControlPolicy.onServiceRemoteAccess(method, arguments, accessControlled);
                }
            }
            catch (SecurityException securityException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)securityException, (Throwable)securityException);
                }
                if (PropsValues.ACCESS_CONTROL_SANITIZE_SECURITY_EXCEPTION) {
                    throw new SecurityException();
                }
                throw securityException;
            }
        } else {
            for (AccessControlPolicy accessControlPolicy : _accessControlPolicies) {
                accessControlPolicy.onServiceAccess(method, arguments, accessControlled);
            }
        }
    }
}

