/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.TeamServiceBaseImpl;
import java.util.LinkedHashMap;
import java.util.List;

public class TeamServiceImpl
extends TeamServiceBaseImpl {
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public Team addTeam(long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_TEAMS");
        return this.teamLocalService.addTeam(this.getUserId(), groupId, name, description, serviceContext);
    }

    public void deleteTeam(long teamId) throws PortalException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"DELETE");
        this.teamLocalService.deleteTeam(teamId);
    }

    public List<Team> getGroupTeams(long groupId) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_TEAMS");
        return this.teamLocalService.getGroupTeams(groupId);
    }

    public Team getTeam(long teamId) throws PortalException {
        Team team = this.teamLocalService.getTeam(teamId);
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Team)team, (String)"VIEW");
        return team;
    }

    public Team getTeam(long groupId, String name) throws PortalException {
        Team team = this.teamLocalService.getTeam(groupId, name);
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Team)team, (String)"VIEW");
        return team;
    }

    public List<Team> getUserTeams(long userId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.teamLocalService.getUserTeams(userId);
    }

    public List<Team> getUserTeams(long userId, long groupId) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_TEAMS");
        return this.teamLocalService.getUserTeams(userId, groupId);
    }

    public boolean hasUserTeam(long userId, long teamId) throws PortalException {
        Team team;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(team = this.teamPersistence.findByPrimaryKey(teamId)).getGroupId(), (String)"MANAGE_TEAMS") && !UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userId, (String)"UPDATE")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), teamId, new String[]{"MANAGE_TEAMS", "UPDATE"});
        }
        return this._userPersistence.containsTeam(userId, teamId);
    }

    public List<Team> search(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.teamFinder.filterFindByG_N_D(groupId, name, description, params, start, end, orderByComparator);
    }

    public int searchCount(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return this.teamFinder.filterCountByG_N_D(groupId, name, description, params);
    }

    public Team updateTeam(long teamId, String name, String description) throws PortalException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"UPDATE");
        return this.teamLocalService.updateTeam(teamId, name, description);
    }
}

